/*
 *  TOPPERS/ASP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Advanced Standard Profile Kernel  
 * 
 *  Copyright (C) 2010 by Meika Sugimoto
 * 
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 * 
 */

/*
 *	V850/JG2ŗL
 */

#include "v850asm.inc"
#define	TOPPERS_MACRO_ONLY
#define UINT_C(val)			(val)		/* uint_t^̒萔}N */
#define ULONG_C(val)		(val)		/* ulong_t^̒萔}N */
#define CAST(type, val)		(val)		/* ^LXgs}N */
#include "kernel_impl.h"

	.section .text , "ax"
	.align 2

/*
 *	n[hEFAԂ̏
 *
 *	WDT2̒~PLL̈҂
 */
	.globl	hardware_init_hook
hardware_init_hook:
	/* WDT2̒~ */
	mov		WDTM2 , r10
	st.b	r0 , 0[r10]
	/* OIV[^̒~ */
	mov		RCM , r10
	mov		1 , r11
	st.b	r11 , 0[r10]

wait_pll_lock:
	ld.b 0[r11] , r12
	cmp 1 , r12
	be wait_pll_lock
	/*
	 * VXeEFCgRg[WX^ݒA01
	 * gp郁CNbNɉĐݒ肷
	 */
	movea	0x01 ,	r0 , r12
	mov		VSWC , r13
	st.b	r12 , 0[r13]
	/* NbNݒAPLLNbNCNbN */
	movea	0x02 , r0 , r12
	mov		PLLCTL , r13
	ld.bu	0[r13] , r14
	or		r12 , r14
	st.b	r14 , 0[r13]
	nop
	nop
	nop
	nop
	nop
	jmp	lp

	.end
