//------------------------------------------------------------------------------
//  TOPPERS/ASP Windows Debug Environment
//  Copyright (C) 2010-2013 Cores Co., Ltd. Japan
//------------------------------------------------------------------------------
// $Id: UnitSim.cs 115 2013-02-11 02:13:05Z nagasima $
#ifndef SifEtherCtrlH
#define SifEtherCtrlH

//---------------------------------------------------------------------------
#include "Kernel.h"
#include "V850ESJX3EReg.h"
#include "SIFLayer.h"

//------------------------------------------------------------------------------
//------------------------------------------------------------------------------
#pragma pack(push, 1)
struct TEthernetData
{
	unsigned char DstAddr[6];
	unsigned char SrcAddr[6];
	unsigned short Length;
	unsigned char Data[46];
	//unsigned char FrameChkSeq[4];
};
#pragma pack(pop)

//------------------------------------------------------------------------------
//------------------------------------------------------------------------------
#pragma pack(push, 1)
struct TEtherCtrlDataNode
{
	int Size;
	union{
		TEthernetData EthernetData;
		unsigned char Data[];
	};
};
#pragma pack(pop)

typedef list<TEtherCtrlDataNode *> CEtherCtrlDataQueue;

enum TEtherCtrlTerm
{
	ectIdle,
	ectSend,
	ectTxInt,
	ectRecv,
	ectRxInt,
};

//------------------------------------------------------------------------------
// ɂEtherCtrl NX
//------------------------------------------------------------------------------
class CSifEtherCtrl : public ISystemIF, public ISysTimerSync
{
public:
	CSifEtherCtrl(TEtherReg *etherReg, int txIntNo, int rxIntNo, int devNo);
	virtual ~CSifEtherCtrl();
private:
	TEtherReg *m_EtherReg;
	int m_TxIntNo;
	int m_RxIntNo;
	int m_DevNo;
	CRITICAL_SECTION m_Lock;
	bool m_SendReq;
	TEtherDescriper *m_TxDsp;
	unsigned char *m_SendBuf;
	int m_SendBufPos;
	TEtherDescriper *m_RxDsp;
	CEtherCtrlDataQueue m_RecvQueue;
	TEtherCtrlDataNode *m_RecvBuf;
	int m_RecvBufPos;
	TEtherCtrlTerm m_Term;
	__int64 m_Timer;

	bool m_MacReset;
	bool m_FifoReset;
	bool m_SoftReset;
	unsigned short m_PhyReg[32];
protected:
	class Lock{
		CRITICAL_SECTION *m_Lock;
	public:
		Lock(CRITICAL_SECTION *lock) { m_Lock = lock; EnterCriticalSection(m_Lock); }
		~Lock() { LeaveCriticalSection(m_Lock); }
	};
public:	// ISystemIF
	virtual unsigned char GetByte(unsigned int Addr);
	virtual void SetByte(unsigned int Addr, unsigned char Value);
	virtual unsigned short GetUInt16(unsigned int Addr);
	virtual void SetUInt16(unsigned int Addr, unsigned short Value);
	virtual unsigned int GetUInt32(unsigned int Addr);
	virtual void SetUInt32(unsigned int Addr, unsigned int Value);
public:	// ISysTimerSync
	__int64 GetTimer();
	void Progress(__int64 Timer);
	void CallTimeOut(__int64 Frequency);
	void Receive(const void *Data, int Size);
};

//---------------------------------------------------------------------------
#endif // SifEtherCtrlH
