/*
 *  TOPPERS/ASP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Advanced Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2005-2010 by Embedded and Real-Time Systems Laboratory
 *              Graduate School of Information Science, Nagoya Univ., JAPAN
 * 
 *  L쌠҂́Cȉ(1)`(4)̏𖞂ꍇɌC{\tgEF
 *  Ai{\tgEFAς̂܂ށDȉjgpEE
 *  ρEĔzziȉCpƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 *      ܂C{\tgEFÃ[U܂̓Gh[ÛȂ闝
 *      RɊÂCL쌠҂TOPPERSvWFNg
 *      Ɛӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̎gpړI
 *  ɑ΂K܂߂āCȂۏ؂sȂD܂C{\tgEF
 *  A̗pɂ蒼ړI܂͊ԐړIɐȂ鑹QɊւĂC
 *  ̐ӔC𕉂ȂD
 * 
 *  $Id: time_event.h 60 2010-09-27 10:50:44Z nagasima $
 */

/*
 *		^CCxgǗW[
 */

#ifndef TOPPERS_TIME_EVENT_H
#define TOPPERS_TIME_EVENT_H

/*
 *  Cxg̃f[^^̒`
 *
 *  EVTTIḾCRELTIMƂĎwł͈͂L͈͂\łKv
 *  DITRON4.0dl̃X^_[hvt@Cł́CRELTIM16rb
 *  gȏłȂ΂ȂȂ߁CEVTTIM17rbgȏł邱ƂKv
 *  łD̂߁C16rbgɂȂꍇuint_tł͂ȂCulong_t
 *  `ĂD
 */
typedef ulong_t	EVTTIM;

/* 
 *  ^CCxgubÑf[^^̒`
 */
typedef void	(*CBACK)(void *);	/* R[obN֐̌^ */

typedef struct time_event_block {
	uint_t	index;			/* ^CCxgq[vł̈ʒu */
	CBACK	callback;		/* R[obN֐ */
	void	*arg;			/* R[obN֐֓n */
} TMEVTB;

/*
 *  ^CCxgq[ṽm[h̃f[^^̒`
 */
typedef struct time_event_node {
	EVTTIM	time;			/* Cxg */
	TMEVTB	*p_tmevtb;		/* Ή^CCxgubN */
} TMEVTN;

/*
 *  ^CCxgq[vikernel_cfg.cj
 */
extern TMEVTN	tmevt_heap[];

/*
 *  ݂̃VXeiP: 1~bj
 *
 *  VXeN0ɏCȍ~C^CeBbNx
 *  PɑD
 */
extern EVTTIM	current_time;

/*
 *  ^CCxgq[vŗLȍŏ̃VXeiP: 1~bj
 */
extern EVTTIM	min_time;

/*
 *  ̃^CeBbÑVXeiP: 1~bj
 */
extern EVTTIM	next_time;

/*
 *  VXeώZpϐiP: 1/TIC_DENO~bj
 *
 *  ̃^CeBbÑVXẻʌiʌnext_timejD
 *  TIC_DENO1̎́Cʌ͏0ł邽߁C̕ϐ͕KvȂD
 */
#if TIC_DENO != 1U
extern uint_t	next_subtime;
#endif /* TIC_DENO != 1U */

/*
 *  ΎԂ̊iP: 1~bj
 *
 *  ̃^CeBbÑVXe؂グDTIC_DENO1̎
 *  ́Cnext_timeɈvD
 */
#if TIC_DENO == 1U
#define	base_time	(next_time)
#else /* TIC_DENO == 1U */
#define	base_time	(next_time + (next_subtime > 0U ? 1U : 0U))
#endif /* TIC_DENO == 1U */

/*
 *  ^CCxgq[v̍Ō̎gp̈̃CfbNX
 *
 *  ^CCxgq[vɓo^Ă^CCxg̐ɈvD
 */
extern uint_t	last_index;

/*
 *  ^CCxgǗW[̏
 */
extern void	initialize_tmevt(void);

/*
 *  ^CCxg̑}ʒu̒T
 */
extern uint_t	tmevt_up(uint_t index, EVTTIM time);
extern uint_t	tmevt_down(uint_t index, EVTTIM time);

/*
 *  ^CCxgq[vւ̓o^ƍ폜
 */
extern void	tmevtb_insert(TMEVTB *p_tmevtb, EVTTIM time);
extern void	tmevtb_delete(TMEVTB *p_tmevtb);

/*
 *  ^CCxgubN̓o^iΎԎwj
 *
 *  timeŎw肵ΎԂo߂ɁCargƂcallback
 *  яo悤ɁCp_tmevtbŎw肵^CCxgubNo^
 *  D
 *  
 */
Inline void
tmevtb_enqueue(TMEVTB *p_tmevtb, RELTIM time, CBACK callback, void *arg)
{
	assert(time <= TMAX_RELTIM);

	p_tmevtb->callback = callback;
	p_tmevtb->arg = arg;
	tmevtb_insert(p_tmevtb, base_time + time);
}

/*
 *  ^CCxgubN̓o^iCxgwj
 *
 *  timeŎw肵CxgɁCargƂcallbackĂяo
 *  悤ɁCp_tmevtbŎw肵^CCxgubNo^D
 */
Inline void
tmevtb_enqueue_evttim(TMEVTB *p_tmevtb, EVTTIM time, CBACK callback, void *arg)
{
	p_tmevtb->callback = callback;
	p_tmevtb->arg = arg;
	tmevtb_insert(p_tmevtb, time);
}

/*
 *  ^CCxgubN̓o^
 */
Inline void
tmevtb_dequeue(TMEVTB *p_tmevtb)
{
	tmevtb_delete(p_tmevtb);
}

/*
 *  ^CCxg܂ł̎c莞Ԃ̌vZ
 */
extern RELTIM	tmevt_lefttim(TMEVTB *p_tmevtb);

/*
 *  ^CeBbN̋
 */
extern void	signal_time(void);

#endif /* TOPPERS_TIME_EVENT_H */
