/*
 *  TINET (TCP/IP Protocol Stack)
 * 
 *  Copyright (C) 2001-2009 by Dep. of Computer Science and Engineering
 *                   Tomakomai National College of Technology, JAPAN
 *
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́C̏𖞂ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 *
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 * 
 *  @(#) $Id: route6.c,v 1.5 2009/12/24 05:48:16 abe Exp abe $
 */

/*	$FreeBSD: src/sys/netinet6/route6.c,v 1.6 2002/10/16 01:54:45 sam Exp $	*/
/*	$KAME: route6.c,v 1.24 2001/03/14 03:07:05 itojun Exp $	*/

/*
 * Copyright (C) 1995, 1996, 1997, and 1998 WIDE Project.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of the project nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE PROJECT AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE PROJECT OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ifdef TARGET_KERNEL_ASP

#include <kernel.h>
#include <sil.h>

#endif	/* of #ifdef TARGET_KERNEL_ASP */

#ifdef TARGET_KERNEL_JSP

#include <s_services.h>
#include <t_services.h>

#endif	/* of #ifdef TARGET_KERNEL_JSP */

#include <tinet_defs.h>
#include <tinet_config.h>

#include <net/net.h>
#include <net/if.h>
#include <net/if_loop.h>
#include <net/if_ppp.h>
#include <net/ethernet.h>
#include <net/if_arp.h>
#include <net/ppp_ipcp.h>
#include <net/net_buf.h>
#include <net/net_count.h>

#include <netinet/in.h>
#include <netinet6/in6.h>
#include <netinet6/in6_var.h>
#include <netinet6/nd6.h>
#include <netinet/ip6.h>
#include <netinet6/ip6_var.h>
#include <netinet/icmp6.h>

#ifdef SUPPORT_INET6

#if 0
	/*
	 *  ʐMшHԂUւ̑Ή̂߁A
	 *  ^Cv 0 oHwb_̏sȂB
	 */

/*
 *  ip6_rthdr0 -- ^Cv 0 oHwb_̓͊֐
 */

static ER
ip6_rthdr0 (T_NET_BUF *input, T_IP6_RT0_HDR *rt0h)
{
	if (rt0h->segleft == 0) {
		/* pm[h 0 Ȃ̂ŁAI_m[h */
		return E_OK;
	}

	/* len  segleft ̐`FbN */
#ifdef IP6_CFG_COMPAT_RFC1883
	if ((rt0h->len % 2) || (rt0h->len > 46)) {
#else
	if (rt0h->len % 2) {
#endif
		/*
		 *  len ͋ŁA(23 * 2) ܂ŁB
		 *  A(23 * 2) ̐ RFC 2462 ō폜ĂB
		 */
		icmp6_error(input, ICMP6_PARAM_PROB,
		                   ICMP6_PARAMPROB_HEADER,
		                   ((uint8_t*)&rt0h->len - input->buf) - IF_HDR_SIZE);
		return E_PAR;
	}

	/* len pm[hƖĂȂ`FbNB*/
	if ((rt0h->len / 2) < rt0h->segleft) {
		/*
		 *  len  8INebgPʁAsegleft  16INebgPʂȂ̂ŁA
		 *  len / 2 == segleft ƂȂ͂B
		 *  len / 2 <  segleft ̓G[B
		 */
		icmp6_error(input, ICMP6_PARAM_PROB,
		                   ICMP6_PARAMPROB_HEADER,
		                   ((uint8_t*)&rt0h->segleft - input->buf) - IF_HDR_SIZE);
		return E_PAR;
	}

	/*
	 *  c̒pm[h 1 ȏł΁Ãm[h͍ŏII
	 *  I_m[hł͂ȂB{ł́ApȂ̂ŁA
	 *  ̓f[^ȌIB
	 */
	syscall(rel_net_buf(input));
	return E_PAR;
}

#endif

/*
 *  route6_input -- oHwb_̓͊֐
 */

uint_t
route6_input (T_NET_BUF **inputp, uint_t *offp, uint_t *nextp)
{
	T_NET_BUF	*input = *inputp;
	T_IP6_RT_HDR	*rth;
	uint_t		len, off = *offp;

	/* lbg[Nobt@̎c̒`FbNB*/
	if (input->len - off < sizeof(T_IP6_RT_HDR))
		goto buf_rel;

	rth = (T_IP6_RT_HDR *)(input->buf + off);
	len = (rth->len + 1) << 3;

	/* oHwb_̒`FbNB*/
	if (input->len < off + len)
		goto buf_rel;

#if 0
	/*
	 *  ʐMшHԂUւ̑Ή̂߁A
	 *  ^Cv 0 oHwb_̏sȂB
	 */
	if (rth->type == IPV6_RTHDR_TYPE_0) {
		if (ip6_rthdr0(input, (T_IP6_RT0_HDR*)rth) != E_OK) {

			/* G[̏ꍇ́Aip6_rthdr0 Ńobt@JĂB*/
			return IPPROTO_DONE;
		}
	}
	else if (rth->segleft != 0) {

		/*
		 *  c̒pm[h 1 ȏł΁Ãm[h͍ŏII
		 *  I_m[hł͂ȂB{ł́ApȂ̂ŁA
		 *  ICMP6 G[ԑďIB
		 */
		icmp6_error(input, ICMP6_PARAM_PROB,
		                   ICMP6_PARAMPROB_HEADER,
		                   ((uint8_t*)&rth->type - input->buf) - IF_HDR_SIZE);
		return IPPROTO_DONE;
	}
#else
	if (rth->segleft != 0) {

		/*
		 *  c̒pm[h 1 ȏł΁Ãm[h͍ŏII
		 *  I_m[hł͂ȂB{ł́ApȂ̂ŁA
		 *  ICMP6 G[ԑďIB
		 */
		icmp6_error(input, ICMP6_PARAM_PROB,
		                   ICMP6_PARAMPROB_HEADER,
		                   ((uint8_t*)&rth->type - input->buf) - IF_HDR_SIZE);
		return IPPROTO_DONE;
	}
#endif

	*nextp = *offp - IF_HDR_SIZE + offsetof(T_IP6_RT_HDR, next);
	*offp += len;
	return rth->next;

buf_rel:
	syscall(rel_net_buf(input));
	return IPPROTO_DONE;
}

#endif /* of #ifdef SUPPORT_INET6 */
