﻿//------------------------------------------------------------------------------
//  TOPPERS/ASP Windows Debug Environment
//  Copyright (C) 2010-2013 Cores Co., Ltd. Japan
//------------------------------------------------------------------------------
// $Id: Sample1.cs 142 2013-03-29 13:06:16Z nagasima $
using System;
using System.Collections.Generic;
using System.Text;

namespace Console
{
	public class Sample1 : DllUnitSim
	{
		List<IUnitInterface> m_Interfaces = new List<IUnitInterface>();
		SifEtherCtrl m_EtherIF;
		PcapIF m_PcapIF;

		public Sample1()
			: base("Sample1")
		{
			m_PcapIF = new PcapIF();

			m_EtherIF = new SifEtherCtrl(this, "EtherCtrl", 255);
			m_Interfaces.Add(m_EtherIF);

			m_EtherIF.EtherConnection = m_PcapIF;
			m_PcapIF.EtherConnection = m_EtherIF;

			m_PcapIF.Init(0xC0A80100, 0xFFFFFF00);
		}

		public override void Dispose()
		{
			ClearInterfaces();
			base.Dispose();
		}

		protected override void Push(int kind, byte[] data)
		{
			if (kind == 255)
			{
				m_EtherIF.SendMsg(data);
			}
			else
			{
				string str = Encoding.Default.GetString(data);
				System.Console.Write(str);
			}
		}

		public override IList<IUnitInterface> Interfaces
		{
			get { return m_Interfaces.AsReadOnly(); }
		}

		private void ClearInterfaces()
		{
			while (m_Interfaces.Count > 0)
			{
				IUnitInterface unitInterface = m_Interfaces[0];
				DoRemoveInterface(unitInterface);
				m_Interfaces.RemoveAt(0);
			}
		}
	}
}
