﻿/*
 *  TLV - Trace Log Visualizer
 *
 *  Copyright (C) 2008-2011 by Nagoya Univ., JAPAN
 *
 *  上記著作権者は，以下の(1)〜(4)の条件を満たす場合に限り，本ソフトウェ
 *  ア（本ソフトウェアを改変したものを含む．以下同じ）を使用・複製・改
 *  変・再配布（以下，利用と呼ぶ）することを無償で許諾する．
 *  (1) 本ソフトウェアをソースコードの形で利用する場合には，上記の著作
 *      権表示，この利用条件および下記の無保証規定が，そのままの形でソー
 *      スコード中に含まれていること．
 *  (2) 本ソフトウェアを，ライブラリ形式など，他のソフトウェア開発に使
 *      用できる形で再配布する場合には，再配布に伴うドキュメント（利用
 *      者マニュアルなど）に，上記の著作権表示，この利用条件および下記
 *      の無保証規定を掲載すること．
 *  (3) 本ソフトウェアを，機器に組み込むなど，他のソフトウェア開発に使
 *      用できない形で再配布する場合には，次のいずれかの条件を満たすこ
 *      と．
 *    (a) 再配布に伴うドキュメント（利用者マニュアルなど）に，上記の著
 *        作権表示，この利用条件および下記の無保証規定を掲載すること．
 *    (b) 再配布の形態を，別に定める方法によって，TOPPERSプロジェクトに
 *        報告すること．
 *  (4) 本ソフトウェアの利用により直接的または間接的に生じるいかなる損
 *      害からも，上記著作権者およびTOPPERSプロジェクトを免責すること．
 *      また，本ソフトウェアのユーザまたはエンドユーザからのいかなる理
 *      由に基づく請求からも，上記著作権者およびTOPPERSプロジェクトを
 *      免責すること．
 *
 *  本ソフトウェアは，無保証で提供されているものである．上記著作権者お
 *  よびTOPPERSプロジェクトは，本ソフトウェアに関して，特定の使用目的
 *  に対する適合性も含めて，いかなる保証も行わない．また，本ソフトウェ
 *  アの利用により直接的または間接的に生じたいかなる損害に関しても，そ
 *  の責任を負わない．
 *
 *  @(#) $Id: VisualizeLog.cs 89 2011-04-08 11:02:14Z nagasima $
 */
using System;
using System.Collections.Generic;
using System.Text;

namespace NU.OJL.MPRTOS.TLV.Core.FileContext.VisualizeData
{
	public class VisualizeLog : IComparable
	{
		public int logID = -1;
		public string resourceName = null;
		public string ruleName = null;
		public string evntName = null;
		public string evntDetail = null;
		public decimal fromTime = -1;
		public EventShape eventShape = null;

		public VisualizeLog(string resource, string rule, string evnt, string detail, decimal from)
		{
			resourceName = resource;
			ruleName = rule;
			evntName = evnt;
			evntDetail = detail;
			fromTime = from;
		}

		public int CompareTo(object obj) //時間でソートするための比較関数
		{
			VisualizeLog log1 = this;
			VisualizeLog log2 = (VisualizeLog)obj;

			return (int)(log1.fromTime - log2.fromTime);
		}
	}
}
