﻿/*
 *  TLV - Trace Log Visualizer
 *
 *  Copyright (C) 2008-2010 by Nagoya Univ., JAPAN
 *
 *  上記著作権者は，以下の(1)〜(4)の条件を満たす場合に限り，本ソフトウェ
 *  ア（本ソフトウェアを改変したものを含む．以下同じ）を使用・複製・改
 *  変・再配布（以下，利用と呼ぶ）することを無償で許諾する．
 *  (1) 本ソフトウェアをソースコードの形で利用する場合には，上記の著作
 *      権表示，この利用条件および下記の無保証規定が，そのままの形でソー
 *      スコード中に含まれていること．
 *  (2) 本ソフトウェアを，ライブラリ形式など，他のソフトウェア開発に使
 *      用できる形で再配布する場合には，再配布に伴うドキュメント（利用
 *      者マニュアルなど）に，上記の著作権表示，この利用条件および下記
 *      の無保証規定を掲載すること．
 *  (3) 本ソフトウェアを，機器に組み込むなど，他のソフトウェア開発に使
 *      用できない形で再配布する場合には，次のいずれかの条件を満たすこ
 *      と．
 *    (a) 再配布に伴うドキュメント（利用者マニュアルなど）に，上記の著
 *        作権表示，この利用条件および下記の無保証規定を掲載すること．
 *    (b) 再配布の形態を，別に定める方法によって，TOPPERSプロジェクトに
 *        報告すること．
 *  (4) 本ソフトウェアの利用により直接的または間接的に生じるいかなる損
 *      害からも，上記著作権者およびTOPPERSプロジェクトを免責すること．
 *      また，本ソフトウェアのユーザまたはエンドユーザからのいかなる理
 *      由に基づく請求からも，上記著作権者およびTOPPERSプロジェクトを
 *      免責すること．
 *
 *  本ソフトウェアは，無保証で提供されているものである．上記著作権者お
 *  よびTOPPERSプロジェクトは，本ソフトウェアに関して，特定の使用目的
 *  に対する適合性も含めて，いかなる保証も行わない．また，本ソフトウェ
 *  アの利用により直接的または間接的に生じたいかなる損害に関しても，そ
 *  の責任を負わない．
 *
 *  @(#) $Id: CaptureCommand.cs 84 2011-02-18 12:06:06Z nagasima $
 */
using System;
using System.Windows.Forms;
using System.Drawing;
using NU.OJL.MPRTOS.TLV.Base;
using NU.OJL.MPRTOS.TLV.Base.Controls;
using NU.OJL.MPRTOS.TLV.Core.Controls;
using NU.OJL.MPRTOS.TLV.Core.Controls.Forms;

namespace NU.OJL.MPRTOS.TLV.Core.Commands
{
	class CaptureCommand : ICommand
	{
		string _text;
		private Rectangle mainPanelRectangle;

		public CaptureCommand()
		{
			TraceLogDisplayPanel tr = ApplicationFactory.WindowManager.MainPanel as TraceLogDisplayPanel;
			if (tr == null)
				return;

			_text = "スクリーンショットをキャプチャーする";

			// スクリーンショットで欲しいのは topTimeLineScale から BottomTimeLineScale までの領域である
			// 以下、不要な領域を削るための調整を行う
			Control[] ctls = tr.Controls.Find("viewingAreaToolStrip", true);
			Control[] ctls2 = tr.Controls.Find("searchToolStrip", true);
			Control[] ctls3 = tr.Controls.Find("topTimeLineScale", true);
			Control[] ctls4 = tr.Controls.Find("BottomTimeLineScale", true);
			Control[] ctls5 = tr.Controls.Find("treeGridView", true);

			int height = ctls[0].Height;
			int height2 = ctls2[0].Height;
			int height3 = ctls3[0].Height;
			int height4 = ctls4[0].Height;
			int height5 = ctls5[0].Height;

			mainPanelRectangle = tr.RectangleToScreen(tr.ClientRectangle);   // TraceLogDisplayPanel の現在位置を取得し、スクリーン上の絶対位置に変換
			mainPanelRectangle.Y = mainPanelRectangle.Y + height + height2;  //スクリーンショットの上面の位置を調整
			mainPanelRectangle.Height = height3 + height4 + height5;         //スクリーンショットの高さを調整

			//TreeGridViewに垂直スクロールバーが存在している場合、スクロールバーの幅分だけキャプチャ領域から削る処理
			int treeGridViewHscrollBarWidth = tr.Width - (ctls3[0].Left + ctls3[0].Width);
			if (treeGridViewHscrollBarWidth > 0)
			{
				mainPanelRectangle.Width -= treeGridViewHscrollBarWidth;
			}
		}

		public string Text { get { return _text; } set { _text = value; } }

		public bool CanUndo
		{
			get { return false; }
			set { }
		}

		//現在の画像を撮影し、任意パスに保存する
		public void Do()
		{
			if (_text == null)
				return;

			captureScreen();
		}

		public void Undo()
		{
		}

		private void captureScreen()
		{
			SaveFileDialog sfd = new SaveFileDialog();

			sfd.FileName = "新しいファイル";    //はじめのファイル名を指定する
			sfd.InitialDirectory = @"C:\";          //はじめに表示されるフォルダを指定する
			sfd.Filter =                            //[ファイルの種類]に表示される選択肢を指定する
				"ビットマップ(*.bmp)|*.bmp|" +
				"JPEG(*.jpg)|*.jpg|" +
				"PNG(*.png)|*.png|" +
				"GIF(*.gif)|*.gif|" +
				"すべてのファイル(*.*)|*.*";

			sfd.FilterIndex = 1;            //[ファイルの種類]ではじめに「ビットマップ」が選択されているようにする
			sfd.Title = "保存先のファイルを選択してください";
			sfd.RestoreDirectory = true;            //ダイアログボックスを閉じる前に現在のディレクトリを復元するようにする
			sfd.OverwritePrompt = true;            //既に存在するファイル名を指定したとき警告する。デフォルトでTrueなので指定する必要はない
			sfd.CheckPathExists = true;            //存在しないパスが指定されたとき警告を表示する。デフォルトでTrueなので指定する必要はない

			Bitmap bmp = new Bitmap(mainPanelRectangle.Width, mainPanelRectangle.Height, System.Drawing.Imaging.PixelFormat.Format32bppArgb);

			using (System.Drawing.Graphics g = System.Drawing.Graphics.FromImage(bmp))
			{
				g.CopyFromScreen(mainPanelRectangle.X, mainPanelRectangle.Y, 0, 0,
				  mainPanelRectangle.Size, System.Drawing.CopyPixelOperation.SourceCopy);
			}

			//ダイアログを表示する
			if (sfd.ShowDialog() == DialogResult.OK)
			{
				System.IO.Stream stream;
				stream = sfd.OpenFile();


				if (stream != null)
				{
					switch (sfd.FilterIndex)
					{
						case 1: // bitmap 形式
							bmp.Save(stream, System.Drawing.Imaging.ImageFormat.Bmp);
							break;
						case 2: // jpeg 形式
							bmp.Save(stream, System.Drawing.Imaging.ImageFormat.Jpeg);
							break;
						case 3: // png 形式
							bmp.Save(stream, System.Drawing.Imaging.ImageFormat.Png);
							break;
						case 4: // gif 形式
							bmp.Save(stream, System.Drawing.Imaging.ImageFormat.Gif);
							break;
						default: // その他不明な形式 (とりあえず Bmp として記録されるようにしておく)
							bmp.Save(stream, System.Drawing.Imaging.ImageFormat.Bmp);
							break;
					}
					stream.Close();
				}
			}
		}
	}
}

