/*
 *  TOPPERS Software
 *      Toyohashi Open Platform for Embedded Real-Time Systems
 * 
 *  Copyright (C) 2000 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2006-2009 by Embedded and Real-Time Systems Laboratory
 *              Graduate School of Information Science, Nagoya Univ., JAPAN
 * 
 *  L쌠҂́Cȉ(1)`(4)̏𖞂ꍇɌC{\tgEF
 *  Ai{\tgEFAς̂܂ށDȉjgpEE
 *  ρEĔzziȉCpƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 *      ܂C{\tgEFÃ[U܂̓Gh[ÛȂ闝
 *      RɊÂCL쌠҂TOPPERSvWFNg
 *      Ɛӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̎gpړI
 *  ɑ΂K܂߂āCȂۏ؂sȂD܂C{\tgEF
 *  A̗pɂ蒼ړI܂͊ԐړIɐȂ鑹QɊւĂC
 *  ̐ӔC𕉂ȂD
 * 
 *  @(#) $Id: queue.h 93 2012-03-03 05:14:29Z nagasima $
 */

/*
 *		L[색Cu
 *
 *  ̃L[색Cuł́CL[wb_܂ރO\̃_u
 *  NL[D̓Iɂ́CL[wb_̎Gg̓L[
 *  擪̃GgCOGg̓L[̖̃GgƂD܂CL
 *  [̐擪̃Gg̑OGgƁCL[̖̃Gg̎G
 *  ǵCL[wb_ƂD̃L[́CGgCOGg
 *  gwL[wb_ł킷D
 */

#ifndef	TOPPERS_QUEUE_H
#define	TOPPERS_QUEUE_H

#ifdef __cplusplus
extern "C" {
#endif

/*
 *  L[̃f[^\̒`
 */
typedef struct queue {
	struct queue *p_next;		/* Ggւ̃|C^ */
	struct queue *p_prev;		/* OGgւ̃|C^ */
} QUEUE;

/*
 *  L[̏
 *
 *  p_queueɂ̓L[wb_w肷D
 */
Inline void
queue_initialize(QUEUE *p_queue)
{
	p_queue->p_prev = p_queue->p_next = p_queue;
}

/*
 *  L[̑OGgւ̑}
 *
 *  p_queuȇOp_entry}Dp_queueɃL[wb_w肵
 *  ɂ́CL[̖p_entry}邱ƂɂȂD
 */
Inline void
queue_insert_prev(QUEUE *p_queue, QUEUE *p_entry)
{
	p_entry->p_prev = p_queue->p_prev;
	p_entry->p_next = p_queue;
	p_queue->p_prev->p_next = p_entry;
	p_queue->p_prev = p_entry;
}

/*
 *  L[̎Ggւ̑}
 *
 *  p_queue̎p_entry}Dp_queueɃL[wb_w肵
 *  ɂ́CL[̐擪p_entry}邱ƂɂȂD
 */
Inline void
queue_insert_next(QUEUE *p_queue, QUEUE *p_entry)
{
	p_entry->p_prev = p_queue;
	p_entry->p_next = p_queue->p_next;
	p_queue->p_next->p_prev = p_entry;
	p_queue->p_next = p_entry;
}

/*
 *  Gg̍폜
 *
 *  p_entryL[폜D
 */
Inline void
queue_delete(QUEUE *p_entry)
{
	p_entry->p_prev->p_next = p_entry->p_next;
	p_entry->p_next->p_prev = p_entry->p_prev;
}

/*
 *  L[̗
 *
 *  p_topL[ƂGg擪񋓂B
 *  ŏ̌ďoł́Ap_entryNULLnBԒlp_top̎̃Gg(܂擪)łB
 *  ȍ~͑OɓGgp_entryɓnBԒlp_entry̎̃GgƂȂB
 *  p_entry̎̃Ggp_topƂANULLԒlƂāAL[̏I[킷B
 *  p_topNULL`FbNp_entry̑Ó؂͍sĂȂBďo̐ӔCōsƁB
 *  ܂A܂łȂAXbhZ[tɂ͂Ȃ肦ȂB񋓃[v͔r
 *  ďo̐ӔCōsƁB
 */
Inline QUEUE *
queue_enumerate(QUEUE *p_top, QUEUE *p_entry)
{
	QUEUE *p_result;
	if (p_entry == NULL) {
		p_result = p_top->p_next;
	} else {
		p_result = p_entry->p_next;
	}
	if (p_result == p_top) {
		return NULL;
	}
	return p_result;
}

/*
 *  L[̎Gg̎o
 *
 *  p_queue̎GgL[폜C폜GgԂD
 *  p_queueɃL[wb_w肵ꍇɂ́CL[̐擪̃Gg
 *  oƂɂȂDp_queueɋ̃L[w肵ČĂяoĂ͂Ȃ
 *  ȂD
 */
Inline QUEUE *
queue_delete_next(QUEUE *p_queue)
{
	QUEUE	*p_entry;

	assert(p_queue->p_next != p_queue);
	p_entry = p_queue->p_next;
	p_queue->p_next = p_entry->p_next;
	p_entry->p_next->p_prev = p_queue;
	return(p_entry);
}

/*
 *  L[̎Gg̃|C^擾
 *
 *  p_queue ̎GgԂDp_queue ɃL[wb_w肵ꍇɂ́C
 *  L[̐擪̃GgoƂɂȂDp_queue ɋ̃L[
 *  w肵ČĂяoĂ͂ȂȂD
 */
Inline QUEUE *
queue_peek_next(QUEUE *p_queue)
{
	assert(p_queue->p_next != p_queue);

	return(p_queue->p_next);
}

/*
 *  L[󂩂ǂ̃`FbN
 *
 *  p_queueɂ̓L[wb_w肷D
 */
Inline bool_t
queue_empty(QUEUE *p_queue)
{
	if (p_queue->p_next == p_queue) {
		assert(p_queue->p_prev == p_queue);
		return(true);
	}
	return(false);
}

#ifdef __cplusplus
}
#endif

#endif /* TOPPERS_QUEUE_H */
