/*
 *  TINET (TCP/IP Protocol Stack)
 * 
 *  Copyright (C) 2001-2009 by Dep. of Computer Science and Engineering
 *                   Tomakomai National College of Technology, JAPAN
 *
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́C̏𖞂ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 *
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 * 
 *  @(#) $Id: tcp_echo_srv2.c,v 1.5 2009/12/24 05:44:56 abe Exp abe $
 */

/* 
 *  TCP ECHO T[o #2
 *
 *    EM^XN^
 *    EmubLOR[
 *    EIPv4/IPv6
 */

#ifdef TARGET_KERNEL_ASP

#include <kernel.h>
#include <sil.h>
#include <t_syslog.h>
#include "kernel_cfg.h"
#include "tinet_cfg.h"

#endif	/* of #ifdef TARGET_KERNEL_ASP */

#ifdef TARGET_KERNEL_JSP

#include <t_services.h>
#include "kernel_id.h"
#include "tinet_id.h"

#endif	/* of #ifdef TARGET_KERNEL_JSP */

#include <tinet_defs.h>
#include <tinet_config.h>

#include <net/if.h>
#include <net/if_ppp.h>
#include <net/if_loop.h>
#include <net/ethernet.h>
#include <net/net_timer.h>

#include <netinet/in.h>
#include <netinet/in_itron.h>
#include <netinet/ip.h>
#include <netinet/ip6.h>
#include <netinet/tcp.h>

#include <netapp/netapp.h>
#include <netapp/netapp_var.h>
#include <netapp/echo.h>

#ifdef USE_TCP_ECHO_SRV2

/*
 *  \
 */

/*#define SHOW_RCV_RANGE*/

/*
 *  RlNVؒf@̎w
 */

/*#define USE_TCP_SHT_CEP*/

/*
 *  Sϐ
 */

/* TCP MEBhobt@ */

#ifndef TCP_CFG_SWBUF_CSAVE
uint8_t tcp_echo_srv_swbuf[NUM_TCP_ECHO_SRV_TASKS][TCP_ECHO_SRV_SWBUF_SIZE];
#endif

#ifndef TCP_CFG_RWBUF_CSAVE
uint8_t tcp_echo_srv_rwbuf[NUM_TCP_ECHO_SRV_TASKS][TCP_ECHO_SRV_RWBUF_SIZE];
#endif

/*
 *  ϐ
 */

/*
 *  :
 *
 *    BUF_SIZE  TCP 
 *    MEChEobt@TCY + MEChEobt@TCY 
 *    3/2 {ȏ̑傫Ȃ΁AfbhbN\B
 */

#define BUF_SIZE	((TCP_ECHO_SRV_SWBUF_SIZE + \
                          TCP_ECHO_SRV_RWBUF_SIZE) * 3 / 2)

static char	buffer[BUF_SIZE];	/* obt@		*/

static T_IPEP	dst;			/* ڑ		*/
static bool_t	ena_rcv;		/* M\tO	*/
static char	*rptr = buffer;		/* M|C^		*/
static char	*sptr = buffer;		/* M|C^		*/
static uint32_t	rcv_total;		/* M		*/
static uint32_t	snd_total;		/* M		*/
static uint16_t	chars;			/* obt@̕	*/
static uint16_t	rcv_count;		/* M		*/
static uint16_t	snd_count;		/* M		*/

#ifdef USE_TCP_NON_BLOCKING

static ER	rcv_error = E_OK;	/* MAmubLOR[G[ */
static ER	snd_error = 1;		/* MAmubLOR[G[ */

/*
 *  mubLOR[̃R[obN֐
 */

ER
callback_nblk_tcp_echo_srv (ID cepid, FN fncd, void *p_parblk)
{
	ER		error = E_OK;
	ER_UINT		slen, rlen;
	SYSTIM		now;
	uint16_t	last;
	char		head, tail;

	get_tim(&now);

	switch (fncd) {

	case TFN_TCP_ACP_CEP:
		rcv_error = *(ER*)p_parblk;
		if (rcv_error == E_OK) {
			sptr = rptr = buffer;
			snd_count = snd_total = rcv_count = rcv_total = chars = 0;
			snd_error = 1;
			ena_rcv   = true;
			syslog(LOG_NOTICE, "[TES:%02d CBN] connected:  %6ld, from: %s.%d",
			                   cepid, now / SYSTIM_HZ, IP2STR(NULL, &dst.ipaddr), dst.portno);
		}
		else
			syslog(LOG_NOTICE, "[TES:%02d CBN] accept error: %s\n", cepid, itron_strerror(rcv_error));

		syscall(sig_sem(SEM_TCP_ECHO_SRV_RCV_READY));
		break;

	case TFN_TCP_SND_DAT:
		slen = snd_error = *(ER*)p_parblk;
		if (slen > 0) {
			head = *sptr;
			tail = *(sptr + slen - 1);
#ifdef SHOW_RCV_RANGE
			syslog(LOG_NOTICE, "[TES:%02d CBN] send len: %4d, data %02x -> %02x",
			                   cepid, (uint16_t)slen, head, tail);
#endif	/* of #ifdef SHOW_RCV_RANGE */
			snd_count ++;
			snd_total += slen;

			syscall(wai_sem(SEM_TCP_ECHO_SRV_LOCK));

			/* M|C^i߂B*/
			if (sptr - buffer + slen >= sizeof(buffer))
				sptr -= sizeof(buffer) - slen;
			else
				sptr += slen;

			/* obt@̕炷B*/
			last   = chars;
			chars -= slen;

 			/* obt@ɕ΁AM^XNNB*/
			if (chars > 0 || (!ena_rcv && chars == 0))
				sig_sem(SEM_TCP_ECHO_SRV_SND_READY);

 			/* M\ŁAobt@ɋ󂫂ł΁AM^XNNB*/
			if (ena_rcv && last == sizeof(buffer) && sizeof(buffer) - chars > 0)
				syscall(sig_sem(SEM_TCP_ECHO_SRV_RCV_READY));

			syscall(sig_sem(SEM_TCP_ECHO_SRV_LOCK));
		}
		else {
			syslog(LOG_NOTICE, "[TES:%02d CBN] send error = %s", cepid, itron_strerror(snd_error));
			sig_sem(SEM_TCP_ECHO_SRV_SND_READY);
		}
		break;

	case TFN_TCP_RCV_DAT:
		rlen = rcv_error = *(ER*)p_parblk;
		if (rlen > 0) {
			head = *rptr;
			tail = *(rptr + rlen - 1);
#ifdef SHOW_RCV_RANGE
			syslog(LOG_NOTICE, "[TES:%02d CBN] recv len: %4d, data %02x -> %02x",
			                   cepid, (uint16_t)rlen, head, tail);
#endif	/* of #ifdef SHOW_RCV_RANGE */
			rcv_count ++;
			rcv_total += rlen;

			syscall(wai_sem(SEM_TCP_ECHO_SRV_LOCK));

			/* M|C^i߂B*/
			if (rptr - buffer + rlen >= sizeof(buffer))
				rptr -= sizeof(buffer) - rlen;
			else
				rptr += rlen;

			/* obt@̕𑝂₷B*/
			last   = chars;
			chars += rlen;

 			/* obt@ɕ΁AM^XNNB*/
			if (last == 0 && chars > 0)
				sig_sem(SEM_TCP_ECHO_SRV_SND_READY);

 			/* obt@ɋ󂫂΁AM^XNNB*/
			if (sizeof(buffer) - chars > 0)
				sig_sem(SEM_TCP_ECHO_SRV_RCV_READY);

			syscall(sig_sem(SEM_TCP_ECHO_SRV_LOCK));
		}
		else {
			if (rlen < 0)
				syslog(LOG_NOTICE, "[TES:%02d CBN] recv error = %s", cepid, itron_strerror(rcv_error));
			sig_sem(SEM_TCP_ECHO_SRV_RCV_READY);
		}
		break;

	case TFN_TCP_CLS_CEP:
		snd_error = *(ER*)p_parblk;
		if (snd_error != E_OK)
			syslog(LOG_NOTICE, "[TES:%02d CBN] close error = %s", cepid, itron_strerror(snd_error));

		syslog(LOG_NOTICE, "[TES:%02d CBN] finished:   %6ld, snd: %4d, rcv: %4d, len: %ld",
		                   cepid, now / SYSTIM_HZ, snd_count, rcv_count, snd_total);

		sig_sem(SEM_TCP_ECHO_SRV_CLS_READY);
		break;

	case TFN_TCP_CON_CEP:
	case TFN_TCP_GET_BUF:
	case TFN_TCP_RCV_BUF:
	case TFN_TCP_SND_OOB:
	default:
		error = E_PAR;
	}
	return error;
}

/*
 *  TCP ECHO T[oM[` (mubLOR[gp)
 */

ER
tcp_echo_srv_rcv (ID cepid, ID repid)
{
	ER		error;
	uint16_t	blen;

	if ((error = psnd_dtq(DTQ_TCP_ECHO_SRV_SND, (intptr_t)cepid)) != E_OK) {
		syslog(LOG_NOTICE, "[TES:%02d RCV] sync error: %s", cepid, itron_strerror(error));
		return error;
	}

	if ((error = TCP_ACP_CEP(cepid, repid, &dst, TMO_NBLK)) != E_WBLK) {
		syslog(LOG_NOTICE, "[TES:%02d ACP] accept error = %s", cepid, itron_strerror(error));
		return error;
	}

	/* RlNVJ݊܂ő҂B*/
	syscall(wai_sem(SEM_TCP_ECHO_SRV_RCV_READY));

	/* ҂ĂԂɃG[ɂȂARlNV̊Jݑ҂ɖ߂B*/
	if (rcv_error != E_OK)
		return rcv_error;

#ifdef USE_TCP_EXTENTIONS
	if ((error = free_tcp_rep(repid, true)) != E_OK) {
		syslog(LOG_NOTICE, "[TES:%02d DEL] REP delete error: %s", cepid, itron_strerror(error));
		return error;
	}
#endif	/* of #ifdef USE_TCP_EXTENTIONS */

	while (true) {

		/* MTCYvZB*/
		syscall(wai_sem(SEM_TCP_ECHO_SRV_LOCK));
		if (sptr > rptr)
			blen = sptr - rptr;
		else
			blen = sizeof(buffer) - (rptr - buffer);
		syscall(sig_sem(SEM_TCP_ECHO_SRV_LOCK));

		/* MB*/
		if ((error = tcp_rcv_dat(cepid, rptr, blen, TMO_NBLK)) != E_WBLK) {
			syslog(LOG_NOTICE, "[TES:%02d RCV] recv error = %s", cepid, itron_strerror(error));
			break;
		}

		/* Mobt@ɋ󂪂ł܂ő҂B*/
		syscall(wai_sem(SEM_TCP_ECHO_SRV_RCV_READY));

		/* ҂ĂԂɁAM 0 ɂȂ邩AG[ɂȂIB*/
		if (rcv_error <= 0)
			break;

	}

	/* M */
	ena_rcv = false;

	/* Mobt@ɕ̂҂Ă鑗M^XNNB*/
	if (chars == 0)
		sig_sem(SEM_TCP_ECHO_SRV_SND_READY);

	/* RlNVؒf܂ő҂B*/
	syscall(wai_sem(SEM_TCP_ECHO_SRV_CLS_READY));

	return error == E_WBLK ? E_OK : error;
}

/*
 *  TCP ECHO T[oM^XN (mubLOR[gp)
 */

void
tcp_echo_srv_snd_task(intptr_t exinf)
{
	ER		error;
	ID		tskid, cepid;
	uint16_t	blen;

	get_tid(&tskid);
	syslog(LOG_NOTICE, "[TCP ECHO SRV (NBLK) SND:%d] started.", tskid);
	while (true) {
		if ((error = rcv_dtq(DTQ_TCP_ECHO_SRV_SND, (intptr_t*)&cepid)) != E_OK) {
			syslog(LOG_NOTICE, "[TES:%02d SND] sync error: %s",
			                   cepid, itron_strerror(error));
			continue;
		}

		while (true) {

			/* obt@ɕ܂ő҂B*/
			syscall(wai_sem(SEM_TCP_ECHO_SRV_SND_READY));

			/* ҂ĂԂɃG[ɂȂIB*/
			if (snd_error <= 0)
				break;

			/* MŁAobt@ɕȂΏIB*/
			if (!ena_rcv && chars == 0)
				break;

			/* MTCYvZB*/
			syscall(wai_sem(SEM_TCP_ECHO_SRV_LOCK));
			if (rptr > sptr)
				blen = rptr - sptr;
			else
				blen = sizeof(buffer) - (sptr - buffer);
			syscall(sig_sem(SEM_TCP_ECHO_SRV_LOCK));

			/* MB*/
			if ((error = tcp_snd_dat(cepid, sptr, blen, TMO_NBLK)) != E_WBLK) {
				syslog(LOG_NOTICE, "[TES:%02d SND] send error = %s", cepid, itron_strerror(error));
				break;
			}
		}

		/* Mobt@ɋ󂪂ł҂ĂM^XNNB*/
		if (chars == sizeof(buffer))
			sig_sem(SEM_TCP_ECHO_SRV_SND_READY);

#ifdef USE_TCP_SHT_CEP
		if ((error = tcp_sht_cep(cepid)) != E_OK)
			syslog(LOG_NOTICE, "[TES:%02d SND] shutdown error = %s", cepid, itron_strerror(error));
#endif	/* of #ifdef USE_TCP_SHT_CEP */

		if ((error = tcp_cls_cep(cepid, TMO_NBLK)) != E_WBLK) {
			syslog(LOG_NOTICE, "[TES:%02d SND] close error = %s", cepid, itron_strerror(error));
		}

		pol_sem(SEM_TCP_ECHO_SRV_SND_READY);
		pol_sem(SEM_TCP_ECHO_SRV_RCV_READY);
	}
}

#else	/* of #ifdef USE_TCP_NON_BLOCKING */

/*
 *  TCP ECHO T[oM[`
 */

ER
tcp_echo_srv_rcv (ID cepid, ID repid)
{
	ER_UINT		rlen;
	ER		error;
	SYSTIM		now;
	uint16_t	blen, last;
	char		head, tail;

	if ((error = psnd_dtq(DTQ_TCP_ECHO_SRV_SND, (intptr_t)cepid)) != E_OK) {
		syslog(LOG_NOTICE, "[TES:%02d RCV] sync error: %s", cepid, itron_strerror(error));
		return error;
	}

	if ((error = TCP_ACP_CEP(cepid, repid, &dst, TMO_FEVR)) != E_OK) {
		syslog(LOG_NOTICE, "[TES:%02d ACP] accept error = %s", cepid, itron_strerror(error));
		return error;
	}

#ifdef USE_TCP_EXTENTIONS
	if ((error = free_tcp_rep(repid, true)) != E_OK) {
		syslog(LOG_NOTICE, "[TES:%02d DEL] REP delete error: %s", cepid, itron_strerror(error));
		return error;
	}
#endif	/* of #ifdef USE_TCP_EXTENTIONS */

	syscall(get_tim(&now));
	syslog(LOG_NOTICE, "[TES:%02d ACP] connected:  %6ld, from: %s.%d",
	                   cepid, now / SYSTIM_HZ, IP2STR(NULL, &dst.ipaddr), dst.portno);
	sptr = rptr = buffer;
	snd_count = snd_total = rcv_count = rcv_total = chars = 0;
	ena_rcv   = true;
	while (true) {

		/* MTCYvZB*/
		syscall(wai_sem(SEM_TCP_ECHO_SRV_LOCK));
		if (sptr > rptr)
			blen = sptr - rptr;
		else
			blen = sizeof(buffer) - (rptr - buffer);
		syscall(sig_sem(SEM_TCP_ECHO_SRV_LOCK));

		/* MB*/
		if ((rlen = tcp_rcv_dat(cepid, rptr, blen, TMO_FEVR)) <= 0) {
			if (rlen < 0)
				syslog(LOG_NOTICE, "[TES:%02d RCV] recv error = %s",
				                   cepid, itron_strerror(rlen));
			break;
		}
		head = *rptr;
		tail = *(rptr + rlen - 1);
#ifdef SHOW_RCV_RANGE
		syslog(LOG_NOTICE, "[TES:%02d RCV] len: %4d, data %02x -> %02x",
		                   cepid, (uint16_t)rlen, head, tail);
#endif	/* of #ifdef SHOW_RCV_RANGE */
		rcv_count ++;
		rcv_total += rlen;

		syscall(wai_sem(SEM_TCP_ECHO_SRV_LOCK));

		/* M|C^i߂B*/
		if (rptr - buffer + rlen >= sizeof(buffer))
			rptr -= sizeof(buffer) - rlen;
		else
			rptr += rlen;

		/* obt@̕𑝂₷B*/
		last   =     chars;
		chars += (uint16_t)rlen;

 				/* obt@ɕ΁AM^XNNB*/
		if (last == 0 && chars > 0)
			sig_sem(SEM_TCP_ECHO_SRV_SND_READY);

 				/* obt@ɋ󂫂΁AM^XNNB*/
		if (sizeof(buffer) - chars > 0)
			sig_sem(SEM_TCP_ECHO_SRV_RCV_READY);

		syscall(sig_sem(SEM_TCP_ECHO_SRV_LOCK));

		/* obt@ɋ󂫂ł܂ő҂B*/
		syscall(wai_sem(SEM_TCP_ECHO_SRV_RCV_READY));
	}

	/* M */
	ena_rcv = false;

	/* Mobt@ɕ̂҂Ă鑗M^XNNB*/
	if (chars == 0)
		sig_sem(SEM_TCP_ECHO_SRV_SND_READY);

	/* RlNV̐ؒf܂ő҂B*/
	syscall(wai_sem(SEM_TCP_ECHO_SRV_CLS_READY));

	return error;
}

/*
 *  TCP ECHO T[oM^XN
 */

void
tcp_echo_srv_snd_task(intptr_t exinf)
{
	ID		tskid, cepid;
	ER		error;
	ER_UINT		slen;
	SYSTIM		now;
	uint16_t	blen, last;
	char		head, tail;

	get_tid(&tskid);
	syslog(LOG_NOTICE, "[TCP ECHO SRV SND:%d] started.", tskid);
	while (true) {
		if ((error = rcv_dtq(DTQ_TCP_ECHO_SRV_SND, (intptr_t*)&cepid)) != E_OK) {
			syslog(LOG_NOTICE, "[TES:%02d SND] sync error: %s",
			                   cepid, itron_strerror(error));
			continue;
		}

		while (true) {

			/* obt@ɕ܂ő҂B*/
			syscall(wai_sem(SEM_TCP_ECHO_SRV_SND_READY));

			/* MŁAobt@ɕȂΏIB*/
			if (!ena_rcv && chars == 0)
				break;

			/* MTCYvZB*/
			syscall(wai_sem(SEM_TCP_ECHO_SRV_LOCK));
			if (rptr > sptr)
				blen = rptr - sptr;
			else
				blen = sizeof(buffer) - (sptr - buffer);
			syscall(sig_sem(SEM_TCP_ECHO_SRV_LOCK));

			if ((slen = tcp_snd_dat(cepid, sptr, blen, TMO_FEVR)) <= 0) {
				syslog(LOG_NOTICE, "[TES:%02d SND] send error = %s", cepid, itron_strerror(slen));
				break;
			}

			head = *sptr;
			tail = *(sptr + slen - 1);
#ifdef SHOW_RCV_RANGE
			syslog(LOG_NOTICE, "[TES:%02d SND] len: %4d, data %02x -> %02x",
			                   cepid, (uint16_t)slen, head, tail);
#endif	/* of #ifdef SHOW_RCV_RANGE */
			snd_count ++;
			snd_total += slen;

			syscall(wai_sem(SEM_TCP_ECHO_SRV_LOCK));

			/* M|C^i߂B*/
			if (sptr - buffer + slen >= sizeof(buffer))
				sptr -= sizeof(buffer) - slen;
			else
				sptr += slen;

			/* obt@̕炷B*/
			last   =     chars;
			chars -= (uint16_t)slen;

			/* MŁAobt@ɕȂΏIB*/
			if (!ena_rcv && chars == 0) {
				syscall(sig_sem(SEM_TCP_ECHO_SRV_LOCK));
				break;
			}

 			/* obt@ɕ΁AM^XNNB*/
			if (chars > 0)
				sig_sem(SEM_TCP_ECHO_SRV_SND_READY);

 			/* M\ŁAobt@ɋ󂫂ł΁AM^XNNB*/
			if (ena_rcv && last == sizeof(buffer) && sizeof(buffer) - chars > 0)
				sig_sem(SEM_TCP_ECHO_SRV_RCV_READY);

			syscall(sig_sem(SEM_TCP_ECHO_SRV_LOCK));
		}

		/* Mobt@ɋ󂪂ł҂ĂM^XNNB*/
		if (chars == sizeof(buffer))
			sig_sem(SEM_TCP_ECHO_SRV_SND_READY);

#ifdef USE_TCP_SHT_CEP
		if ((error = tcp_sht_cep(cepid)) != E_OK)
			syslog(LOG_NOTICE, "[TES:%02d SND] shtudown error = %s", cepid, itron_strerror(error));
#endif	/* of #ifdef USE_TCP_SHT_CEP */

		if ((error = tcp_cls_cep(cepid, TMO_FEVR)) != E_OK)
			syslog(LOG_NOTICE, "[TES:%02d SND] close error = %s", cepid, itron_strerror(error));

		get_tim(&now);
		syslog(LOG_NOTICE, "[TES:%02d SND] finished:   %6ld, snd: %4d, rcv: %4d, len: %ld",
		                   cepid, now / SYSTIM_HZ, snd_count, rcv_count, snd_total);

		sig_sem(SEM_TCP_ECHO_SRV_CLS_READY);

		pol_sem(SEM_TCP_ECHO_SRV_SND_READY);
		pol_sem(SEM_TCP_ECHO_SRV_RCV_READY);
	}
}

#endif	/* of #ifdef USE_TCP_NON_BLOCKING */

#ifdef USE_TCP_EXTENTIONS

/*
 *  get_tcp_rep -- TCP tlB
 */

static ER
get_tcp_rep (ID *repid)
{
	ID		tskid;
	T_TCP_CREP	crep;

	get_tid(&tskid);

	crep.repatr = UINT_C(0);
	crep.myaddr.portno = UINT_C(7);

#if defined(SUPPORT_INET4)
	crep.myaddr.ipaddr = IPV4_ADDRANY;
#endif

#if defined(SUPPORT_INET6)
	memcpy(&crep.myaddr.ipaddr, &ipv6_addrany, sizeof(T_IN6_ADDR));
#endif

	return alloc_tcp_rep(repid, tskid, &crep);
}

/*
 *  get_tcp_cep -- TCP ʐM[_lB
 */

static ER
get_tcp_cep (ID *cepid)
{
	ID		tskid;
	T_TCP_CCEP	ccep;

	get_tid(&tskid);

	ccep.cepatr = UINT_C(0);
	ccep.sbufsz = TCP_ECHO_SRV_SWBUF_SIZE;
	ccep.rbufsz = TCP_ECHO_SRV_RWBUF_SIZE;

#ifdef TCP_CFG_SWBUF_CSAVE
	ccep.sbuf = NADR;
#else
	ccep.sbuf = tcp_echo_srv_swbuf;
#endif
#ifdef TCP_CFG_RWBUF_CSAVE
	ccep.rbuf = NADR;
#else
	ccep.rbuf = tcp_echo_srv_rwbuf;
#endif
#ifdef USE_TCP_NON_BLOCKING
	ccep.callback = (FP)callback_nblk_tcp_echo_srv;
#else
	ccep.callback = NULL;
#endif

	return alloc_tcp_cep(cepid, tskid, &ccep);
}

/*
 *  TCP ECHO T[oM^XN
 */

void
tcp_echo_srv_rcv_task (intptr_t exinf)
{
	ID	tskid, cepid, repid;
	ER	error = E_OK;

	syscall(get_tid(&tskid));
	syslog(LOG_NOTICE, "[TCP ECHO SRV:%d] started.", tskid);
	while (true) {

		syscall(slp_tsk());
		if ((error = get_tcp_cep (&cepid)) != E_OK) {
			syslog(LOG_NOTICE, "[TES:00 EXT] CEP create error: %s", itron_strerror(error));
			continue;
		}

		while (true) {

			if ((error = get_tcp_rep (&repid)) != E_OK) {
				syslog(LOG_NOTICE, "[TES:00 EXT] REP create error: %s", itron_strerror(error));
				break;
			}
			else if ((error = tcp_echo_srv_rcv(cepid, repid)) != E_OK) {
				error = free_tcp_rep(repid, error != E_DLT);
				break;
			}
		}

		if ((error = free_tcp_cep(cepid)) != E_OK)
			syslog(LOG_NOTICE, "[TES:%02d EXT] CEP delete error: %s", cepid, itron_strerror(error));

	}
}

#else	/* of #ifdef USE_TCP_EXTENTIONS */

void
tcp_echo_srv_rcv_task(intptr_t exinf)
{
	ID	tskid;

	get_tid(&tskid);
	syslog(LOG_NOTICE, "[TCP ECHO SRV RCV:%d,%d] started.", tskid, (ID)exinf);
	while (true) {
		while (tcp_echo_srv_rcv((ID)exinf, TCP_ECHO_SRV_REPID) == E_OK)
			;
	}
}

#endif	/* of #ifdef USE_TCP_EXTENTIONS */

#endif	/* of #ifdef USE_TCP_ECHO_SRV2 */
