﻿//------------------------------------------------------------------------------
// Embedded Software Simulation Base Classes
// Copyright (C) 2010-2011 Cores Co., Ltd. Japan
//------------------------------------------------------------------------------
// $Id: Caret.cs 86 2011-04-04 09:35:04Z nagasima $
using System;
using System.Collections.Generic;

namespace SimBase
{
	public interface IUnitInterface
	{
		string InterfaceName { get; }
		IUnitSim UnitSim { get; }
	}

	public interface IInterfaceHub
	{
		bool Send(IUnitInterface sender, object message);
	}

	public delegate void UnitEventHandler(IUnitSim sender);
	public delegate void UnitInterfaceEventHandler(IUnitSim sender, IUnitInterface item);
	public delegate void UnitOutputEventHandler(IUnitSim sender, int kind, byte[] data);
	public delegate void UnitGetSystemTimeEventHandler(IUnitSim sender, ref long now, ref long frequency);

	public interface IUnitSim
	{
		void Start();
		void Exit();
		void Interrupt(int IntNo);
		int ReadAddr(uint addr, byte[] dst);
		int WriteAddr(uint addr, byte[] src);
		void SetBit(uint addr, int bit, bool value);
		bool GetBit(uint addr, int bit);
		void Input(int kind, byte[] Data);
		long GetTimer();
		void Progress(long timer);
		void CallTimeOut(long frequency);
		bool ProcessEvent();
		string UnitName { get; set; }
		event UnitEventHandler UnitSetEvent;
		event UnitEventHandler UnitStart;
		event UnitEventHandler UnitExit;
		event UnitEventHandler UnitIdle;
		event UnitOutputEventHandler UnitOutput;
		event UnitGetSystemTimeEventHandler UnitGetSystemTime;
		IList<IUnitInterface> Interfaces { get; }
		event UnitInterfaceEventHandler AddInterface;
		event UnitInterfaceEventHandler RemoveInterface;
		event UnitInterfaceEventHandler UpdateInterface;
	}

	public interface IUnitSimAdpt
	{
		IUnitSim Target { get; }
		void Restart();
	}

	public interface IUnitInterfaceAdpt
	{
		IUnitInterface Target { get; set; }
	}
}
