//------------------------------------------------------------------------------
//  TOPPERS/ASP Windows Debug Environment
//  Copyright (C) 2010-2011 Cores Co., Ltd. Japan
//------------------------------------------------------------------------------
// $Id: SIFLayer.h 110 2012-09-10 12:55:37Z nagasima $
#ifndef SIFLayerH
#define SIFLayerH

//---------------------------------------------------------------------------
#define TOPPERS_size	tagSIZE
extern "C" {
#include <kernel.h>
#include <sil.h>
}

//------------------------------------------------------------------------------
// DriverSimulator
//------------------------------------------------------------------------------
class ISystemIF
{
public:
	virtual unsigned char GetByte(unsigned int Addr) = 0;
	virtual void SetByte(unsigned int Addr, unsigned char Value) = 0;
	virtual unsigned short GetUInt16(unsigned int Addr) = 0;
	virtual void SetUInt16(unsigned int Addr, unsigned short Value) = 0;
	virtual unsigned int GetUInt32(unsigned int Addr) = 0;
	virtual void SetUInt32(unsigned int Addr, unsigned int Value) = 0;
};

//-------------------------------------------------------------------------
// TSystemIFItem
//-------------------------------------------------------------------------
struct TSystemIFItem
{
	unsigned int Addr;
	int Size;
	void *Substitute;
	ISystemIF *SystemIF;
};

//------------------------------------------------------------------------------
// DriverSimulator
//------------------------------------------------------------------------------
class CSystemIF : public ISystemIF
{
public:
	CSystemIF(intptr_t BaseAddr, int Size);
	virtual ~CSystemIF();
private:
	intptr_t m_BaseAddr;
	int m_Size;
protected:
	virtual bool HasReadEvent(intptr_t Index) = 0;
	virtual void GetByte2(intptr_t Index, unsigned char &Value) = 0;
	virtual bool SetByte2(intptr_t Index, unsigned char Value) = 0;
	virtual void ReadEvent(intptr_t Index) = 0;
	virtual void WriteEvent(intptr_t Index) = 0;
public:
	unsigned char GetByte(unsigned int Addr);
	void SetByte(unsigned int Addr, unsigned char Value);
	unsigned short GetUInt16(unsigned int Addr);
	void SetUInt16(unsigned int Addr, unsigned short Value);
	unsigned int GetUInt32(unsigned int Addr);
	void SetUInt32(unsigned int Addr, unsigned int Value);
};

//---------------------------------------------------------------------------
#endif // SIFLayerH
