/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 *
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2005-2007 by Embedded and Real-Time Systems Laboratory
 *              Graduate School of Information Science, Nagoya Univ., JAPAN
 *  Copyright (C) 2010 by TOPPERS/ASP for LPC project
 *              http://sourceforge.jp/projects/toppersasp4lpc/
 * 
 *  上記著作権者は，Free Software Foundation によって公表されている 
 *  GNU General Public License の Version 2 に記述されている条件か，以
 *  下の(1)〜(4)の条件を満たす場合に限り，本ソフトウェア（本ソフトウェ
 *  アを改変したものを含む．以下同じ）を使用・複製・改変・再配布（以下，
 *  利用と呼ぶ）することを無償で許諾する．
 *  (1) 本ソフトウェアをソースコードの形で利用する場合には，上記の著作
 *      権表示，この利用条件および下記の無保証規定が，そのままの形でソー
 *      スコード中に含まれていること．
 *  (2) 本ソフトウェアを再利用可能なバイナリコード（リロケータブルオブ
 *      ジェクトファイルやライブラリなど）の形で利用する場合には，利用
 *      に伴うドキュメント（利用者マニュアルなど）に，上記の著作権表示，
 *      この利用条件および下記の無保証規定を掲載すること．
 *  (3) 本ソフトウェアを再利用不可能なバイナリコードの形または機器に組
 *      み込んだ形で利用する場合には，次のいずれかの条件を満たすこと．
 *    (a) 利用に伴うドキュメント（利用者マニュアルなど）に，上記の著作
 *        権表示，この利用条件および下記の無保証規定を掲載すること．
 *    (b) 利用の形態を，別に定める方法によって，上記著作権者に報告する
 *        こと．
 *  (4) 本ソフトウェアの利用により直接的または間接的に生じるいかなる損
 *      害からも，上記著作権者を免責すること．
 * 
 *  本ソフトウェアは，無保証で提供されているものである．上記著作権者は，
 *  本ソフトウェアに関して，その適用可能性も含めて，いかなる保証も行わ
 *  ない．また，本ソフトウェアの利用により直接的または間接的に生じたい
 *  かなる損害に関しても，その責任を負わない．
 * 
 */

/**
 * \ingroup TOPPERS_ASP
 * \defgroup TOPPERS_CHIP LPC18XX チップ依存部
 * \{
 */
/**
 * \file lpc1800.h
 * \details NXP LPC1800シリーズのハードウェア宣言
 */
#ifndef TOPPERS_CHIP_LPC1800_H
#define TOPPERS_CHIP_LPC1800_H

#include <sil.h>

/*
 * CORTEX-M3 CPUの依存部のインクルード
 */
#include "arm_m_gcc/common/arm_m.h"
#ifndef TOPPERS_MACRO_ONLY
#define CMSIS_BITPOSITIONS
#include "LPC18xx.h"
#endif

/**
 * \brief 割込み番号の最大値
 * \details
 * CORTEX-M3のNVIC割り込みコントローラは任意個の割り込み源を持つ。このマクロは、
 * 最大の割り込み番号の値を表す。
 */
#define TMAX_INTNO   (16 + 52)			// LPC1830の最大割り込み番号は16+52

/**
 * \brief 割込み優先度のビット幅
 * \details
 * CORTEX-M3のNVIC割り込みコントローラはSoC実装者の判断で最大8bitの割り込み優先値を
 * 持つことができる。TBITW_IPRIは、その優先値を表すフィールドの幅を示す。フィールド幅は
 * SoC設計者が決める。通常はユーザーズマニュアルなどに書いてある。
 *
 * LPC18xxでは現在不明であるが、UM10430 の 6.3節には
 * "Eight programmable interrupt priority levels with hardware priority level masking."
 * とある。一方、IPRxの説明には5-bitの割り込み優先順位とあり、混乱している。
 */
#define TBITW_IPRI     3					// LPC1830	の優先度は8順位3bit

/**
 * \brief 割込み優先度ビット幅中のサブ優先度のビット幅
 * \details
 * サブ優先度はAIRCRレジスタで指定できる。無指定の場合、0ビットが使われる。
 * todo bits数を調べる
 */
#define TBITW_SUBIPRI  0

/**
 *  \brief 割込みベクタ番号定義
 *  \details
 *  NXP提供のCMSIS LPC18xx.hで宣言されているXXXX_IRQnに以下のスクリプトを適応して生成した。irqsは、宣言を格納したファイル名である。
 *  \code
 *  sed -e "s/  //" < irqs | sed -e "s/_IRQn//" | awk '{print("#define IRQ_VECTOR_"$1"\t\t(16+"$1"_IRQn)")}' -
 *  \endcode
 *  XXX_IRQnはCMSISの定義により、NVICの割り込み番号である。これはCORTEX-M3の例外番号から16を引いたものである。TOPPERS/ASPのCORTEX-M3実装では
 *  IRQ_VECTOR_XXXXを例外番号として宣言している。つまりXXX_IRQnに16を足す。
 */

#define IRQ_VECTOR_DAC      (16+DAC_IRQn)
#define IRQ_VECTOR_RESERVED0        (16+RESERVED0_IRQn)
#define IRQ_VECTOR_DMA      (16+DMA_IRQn)
#define IRQ_VECTOR_RESERVED1        (16+RESERVED1_IRQn)
#define IRQ_VECTOR_RESERVED2        (16+RESERVED2_IRQn)
#define IRQ_VECTOR_ETHERNET     (16+ETHERNET_IRQn)
#define IRQ_VECTOR_SDIO     (16+SDIO_IRQn)
#define IRQ_VECTOR_LCD      (16+LCD_IRQn)
#define IRQ_VECTOR_USB0     (16+USB0_IRQn)
#define IRQ_VECTOR_USB1     (16+USB1_IRQn)
#define IRQ_VECTOR_SCT      (16+SCT_IRQn)
#define IRQ_VECTOR_RITIMER      (16+RITIMER_IRQn)
#define IRQ_VECTOR_TIMER0       (16+TIMER0_IRQn)
#define IRQ_VECTOR_TIMER1       (16+TIMER1_IRQn)
#define IRQ_VECTOR_TIMER2       (16+TIMER2_IRQn)
#define IRQ_VECTOR_TIMER3       (16+TIMER3_IRQn)
#define IRQ_VECTOR_MCPWM        (16+MCPWM_IRQn)
#define IRQ_VECTOR_ADC0     (16+ADC0_IRQn)
#define IRQ_VECTOR_I2C0     (16+I2C0_IRQn)
#define IRQ_VECTOR_I2C1     (16+I2C1_IRQn)
#define IRQ_VECTOR_RESERVED3        (16+RESERVED3_IRQn)
#define IRQ_VECTOR_ADC1     (16+ADC1_IRQn)
#define IRQ_VECTOR_SSP0     (16+SSP0_IRQn)
#define IRQ_VECTOR_SSP1     (16+SSP1_IRQn)
#define IRQ_VECTOR_USART0       (16+USART0_IRQn)
#define IRQ_VECTOR_UART1        (16+UART1_IRQn)
#define IRQ_VECTOR_USART2       (16+USART2_IRQn)
#define IRQ_VECTOR_USART3       (16+USART3_IRQn)
#define IRQ_VECTOR_I2S0     (16+I2S0_IRQn)
#define IRQ_VECTOR_I2S1     (16+I2S1_IRQn)
#define IRQ_VECTOR_RESERVED4        (16+RESERVED4_IRQn)
#define IRQ_VECTOR_RESERVED5        (16+RESERVED5_IRQn)
#define IRQ_VECTOR_PIN_INT0     (16+PIN_INT0_IRQn)
#define IRQ_VECTOR_PIN_INT1     (16+PIN_INT1_IRQn)
#define IRQ_VECTOR_PIN_INT2     (16+PIN_INT2_IRQn)
#define IRQ_VECTOR_PIN_INT3     (16+PIN_INT3_IRQn)
#define IRQ_VECTOR_PIN_INT4     (16+PIN_INT4_IRQn)
#define IRQ_VECTOR_PIN_INT5     (16+PIN_INT5_IRQn)
#define IRQ_VECTOR_PIN_INT6     (16+PIN_INT6_IRQn)
#define IRQ_VECTOR_PIN_INT7     (16+PIN_INT7_IRQn)
#define IRQ_VECTOR_GINT0        (16+GINT0_IRQn)
#define IRQ_VECTOR_GINT1        (16+GINT1_IRQn)
#define IRQ_VECTOR_EVENTROUTER      (16+EVENTROUTER_IRQn)
#define IRQ_VECTOR_C_CAN1       (16+C_CAN1_IRQn)
#define IRQ_VECTOR_RESERVED6        (16+RESERVED6_IRQn)
#define IRQ_VECTOR_RESERVED7        (16+RESERVED7_IRQn)
#define IRQ_VECTOR_ATIMER       (16+ATIMER_IRQn)
#define IRQ_VECTOR_RTC      (16+RTC_IRQn)
#define IRQ_VECTOR_RESERVED8        (16+RESERVED8_IRQn)
#define IRQ_VECTOR_WWDT     (16+WWDT_IRQn)
#define IRQ_VECTOR_RESERVED9        (16+RESERVED9_IRQn)
#define IRQ_VECTOR_C_CAN0       (16+C_CAN0_IRQn)
#define IRQ_VECTOR_QEI      (16+QEI_IRQn)


/**
 *  \brief 割込みハンドラ番号定義
 *  \details
 *  NXP提供のCMSIS LPC18xx.hで宣言されているXXXX_IRQnに以下のスクリプトを適応して生成した。irqsは、宣言を格納したファイル名である。
 *  \code
 *  sed -e "s/  //" < irqs | sed -e "s/_IRQn//" | awk '{print("#define INHNO_"$1"\t\tIRQ_VECTOR_"$1)}' -
 *  \endcode
 *  XXX_IRQnはCMSISの定義により、NVICの割り込み番号である。これはCORTEX-M3の例外番号から16を引いたものである。TOPPERS/ASPのCORTEX-M3実装では
 *  INHNO_XXXXを例外番号として宣言している。つまりIRQ_VECTOR_XXXと同じ値である
 */

#define INHNO_DAC       IRQ_VECTOR_DAC
#define INHNO_RESERVED0     IRQ_VECTOR_RESERVED0
#define INHNO_DMA       IRQ_VECTOR_DMA
#define INHNO_RESERVED1     IRQ_VECTOR_RESERVED1
#define INHNO_RESERVED2     IRQ_VECTOR_RESERVED2
#define INHNO_ETHERNET      IRQ_VECTOR_ETHERNET
#define INHNO_SDIO      IRQ_VECTOR_SDIO
#define INHNO_LCD       IRQ_VECTOR_LCD
#define INHNO_USB0      IRQ_VECTOR_USB0
#define INHNO_USB1      IRQ_VECTOR_USB1
#define INHNO_SCT       IRQ_VECTOR_SCT
#define INHNO_RITIMER       IRQ_VECTOR_RITIMER
#define INHNO_TIMER0        IRQ_VECTOR_TIMER0
#define INHNO_TIMER1        IRQ_VECTOR_TIMER1
#define INHNO_TIMER2        IRQ_VECTOR_TIMER2
#define INHNO_TIMER3        IRQ_VECTOR_TIMER3
#define INHNO_MCPWM     IRQ_VECTOR_MCPWM
#define INHNO_ADC0      IRQ_VECTOR_ADC0
#define INHNO_I2C0      IRQ_VECTOR_I2C0
#define INHNO_I2C1      IRQ_VECTOR_I2C1
#define INHNO_RESERVED3     IRQ_VECTOR_RESERVED3
#define INHNO_ADC1      IRQ_VECTOR_ADC1
#define INHNO_SSP0      IRQ_VECTOR_SSP0
#define INHNO_SSP1      IRQ_VECTOR_SSP1
#define INHNO_USART0        IRQ_VECTOR_USART0
#define INHNO_UART1     IRQ_VECTOR_UART1
#define INHNO_USART2        IRQ_VECTOR_USART2
#define INHNO_USART3        IRQ_VECTOR_USART3
#define INHNO_I2S0      IRQ_VECTOR_I2S0
#define INHNO_I2S1      IRQ_VECTOR_I2S1
#define INHNO_RESERVED4     IRQ_VECTOR_RESERVED4
#define INHNO_RESERVED5     IRQ_VECTOR_RESERVED5
#define INHNO_PIN_INT0      IRQ_VECTOR_PIN_INT0
#define INHNO_PIN_INT1      IRQ_VECTOR_PIN_INT1
#define INHNO_PIN_INT2      IRQ_VECTOR_PIN_INT2
#define INHNO_PIN_INT3      IRQ_VECTOR_PIN_INT3
#define INHNO_PIN_INT4      IRQ_VECTOR_PIN_INT4
#define INHNO_PIN_INT5      IRQ_VECTOR_PIN_INT5
#define INHNO_PIN_INT6      IRQ_VECTOR_PIN_INT6
#define INHNO_PIN_INT7      IRQ_VECTOR_PIN_INT7
#define INHNO_GINT0     IRQ_VECTOR_GINT0
#define INHNO_GINT1     IRQ_VECTOR_GINT1
#define INHNO_EVENTROUTER       IRQ_VECTOR_EVENTROUTER
#define INHNO_C_CAN1        IRQ_VECTOR_C_CAN1
#define INHNO_RESERVED6     IRQ_VECTOR_RESERVED6
#define INHNO_RESERVED7     IRQ_VECTOR_RESERVED7
#define INHNO_ATIMER        IRQ_VECTOR_ATIMER
#define INHNO_RTC       IRQ_VECTOR_RTC
#define INHNO_RESERVED8     IRQ_VECTOR_RESERVED8
#define INHNO_WWDT      IRQ_VECTOR_WWDT
#define INHNO_RESERVED9     IRQ_VECTOR_RESERVED9
#define INHNO_C_CAN0        IRQ_VECTOR_C_CAN0
#define INHNO_QEI       IRQ_VECTOR_QEI


/**
 *  \brief TOPPERS/ASP割込み番号定義
 *  \details
 *  NXP提供のCMSIS LPC18xx.hで宣言されているXXXX_IRQnに以下のスクリプトを適応して生成した。irqsは、宣言を格納したファイル名である。
 *  \code
 *  sed -e "s/  //" < irqs | sed -e "s/_IRQn//" | awk '{print("#define INTNO_"$1"\t\tIRQ_VECTOR_"$1)}' -
 *  \endcode
 *  XXX_IRQnはCMSISの定義により、NVICの割り込み番号である。これはCORTEX-M3の例外番号から16を引いたものである。TOPPERS/ASPのCORTEX-M3実装では
 *  INTNO_XXXXを例外番号として宣言している。つまりIRQ_VECTOR_XXXと同じ値である
 */
#define INTNO_DAC       IRQ_VECTOR_DAC
#define INTNO_RESERVED0     IRQ_VECTOR_RESERVED0
#define INTNO_DMA       IRQ_VECTOR_DMA
#define INTNO_RESERVED1     IRQ_VECTOR_RESERVED1
#define INTNO_RESERVED2     IRQ_VECTOR_RESERVED2
#define INTNO_ETHERNET      IRQ_VECTOR_ETHERNET
#define INTNO_SDIO      IRQ_VECTOR_SDIO
#define INTNO_LCD       IRQ_VECTOR_LCD
#define INTNO_USB0      IRQ_VECTOR_USB0
#define INTNO_USB1      IRQ_VECTOR_USB1
#define INTNO_SCT       IRQ_VECTOR_SCT
#define INTNO_RITIMER       IRQ_VECTOR_RITIMER
#define INTNO_TIMER0        IRQ_VECTOR_TIMER0
#define INTNO_TIMER1        IRQ_VECTOR_TIMER1
#define INTNO_TIMER2        IRQ_VECTOR_TIMER2
#define INTNO_TIMER3        IRQ_VECTOR_TIMER3
#define INTNO_MCPWM     IRQ_VECTOR_MCPWM
#define INTNO_ADC0      IRQ_VECTOR_ADC0
#define INTNO_I2C0      IRQ_VECTOR_I2C0
#define INTNO_I2C1      IRQ_VECTOR_I2C1
#define INTNO_RESERVED3     IRQ_VECTOR_RESERVED3
#define INTNO_ADC1      IRQ_VECTOR_ADC1
#define INTNO_SSP0      IRQ_VECTOR_SSP0
#define INTNO_SSP1      IRQ_VECTOR_SSP1
#define INTNO_USART0        IRQ_VECTOR_USART0
#define INTNO_UART1     IRQ_VECTOR_UART1
#define INTNO_USART2        IRQ_VECTOR_USART2
#define INTNO_USART3        IRQ_VECTOR_USART3
#define INTNO_I2S0      IRQ_VECTOR_I2S0
#define INTNO_I2S1      IRQ_VECTOR_I2S1
#define INTNO_RESERVED4     IRQ_VECTOR_RESERVED4
#define INTNO_RESERVED5     IRQ_VECTOR_RESERVED5
#define INTNO_PIN_INT0      IRQ_VECTOR_PIN_INT0
#define INTNO_PIN_INT1      IRQ_VECTOR_PIN_INT1
#define INTNO_PIN_INT2      IRQ_VECTOR_PIN_INT2
#define INTNO_PIN_INT3      IRQ_VECTOR_PIN_INT3
#define INTNO_PIN_INT4      IRQ_VECTOR_PIN_INT4
#define INTNO_PIN_INT5      IRQ_VECTOR_PIN_INT5
#define INTNO_PIN_INT6      IRQ_VECTOR_PIN_INT6
#define INTNO_PIN_INT7      IRQ_VECTOR_PIN_INT7
#define INTNO_GINT0     IRQ_VECTOR_GINT0
#define INTNO_GINT1     IRQ_VECTOR_GINT1
#define INTNO_EVENTROUTER       IRQ_VECTOR_EVENTROUTER
#define INTNO_C_CAN1        IRQ_VECTOR_C_CAN1
#define INTNO_RESERVED6     IRQ_VECTOR_RESERVED6
#define INTNO_RESERVED7     IRQ_VECTOR_RESERVED7
#define INTNO_ATIMER        IRQ_VECTOR_ATIMER
#define INTNO_RTC       IRQ_VECTOR_RTC
#define INTNO_RESERVED8     IRQ_VECTOR_RESERVED8
#define INTNO_WWDT      IRQ_VECTOR_WWDT
#define INTNO_RESERVED9     IRQ_VECTOR_RESERVED9
#define INTNO_C_CAN0        IRQ_VECTOR_C_CAN0
#define INTNO_QEI       IRQ_VECTOR_QEI

#ifndef TOPPERS_MACRO_ONLY

#endif /* TOPPERS_MACRO_ONLY */
#endif /* TOPPERS_CHIP_LPC17XX_H */

/**
 * \}
 */
