/**
 * @file mmr.c
 * @brief メモリマップレジスタをGDBからアクセスするための補助ファイル
 *
 *
 * GDBからたとえば次のようなコマンドを入力してレジスタにアクセスする。
 * @code
 * set mmrLPC_PINCON->PINSEL3 = 0
 * set mmrLPC_GPIO1->FIODIR = 0x10000000
 * set mmrLPC_GPIO1->FIOCLR = 0x10000000
 * set mmrLPC_GPIO1->FIOSET = 0x10000000
 * @endcode
 *
 * レジスタの型の定義はCMSISをそのまま利用している。
 */

#include "LPC17xx.h"




InterruptType_Type * const mmrSCS =		(InterruptType_Type *) 	SCS_BASE;
SCB_Type *           const mmrSCB = 		(SCB_Type *) 				SCB_BASE;
SysTick_Type *       const mmrSysTick	=	(SysTick_Type *) 			SysTick_BASE;
NVIC_Type *          const mmrNVIC = 		(NVIC_Type *) 			NVIC_BASE;
ITM_Type *           const mmrITM = 		(ITM_Type *) 				ITM_BASE;
CoreDebug_Type *     const mmrCoreDebug = (CoreDebug_Type *) 		CoreDebug_BASE;


#if defined (__MPU_PRESENT) && (__MPU_PRESENT == 1)
MPU_Type*            const mmrMPU = 		(MPU_Type*) 				MPU_BASE;
#endif

LPC_SC_TypeDef        *	const mmrLPC_SC	= (	LPC_SC_TypeDef        *	)	LPC_SC_BASE	;
LPC_GPIO_TypeDef      *	const mmrLPC_GPIO0	= (	LPC_GPIO_TypeDef      *	)	LPC_GPIO0_BASE	;
LPC_GPIO_TypeDef      *	const mmrLPC_GPIO1	= (	LPC_GPIO_TypeDef      *	)	LPC_GPIO1_BASE	;
LPC_GPIO_TypeDef      *	const mmrLPC_GPIO2	= (	LPC_GPIO_TypeDef      *	)	LPC_GPIO2_BASE	;
LPC_GPIO_TypeDef      *	const mmrLPC_GPIO3	= (	LPC_GPIO_TypeDef      *	)	LPC_GPIO3_BASE	;
LPC_GPIO_TypeDef      *	const mmrLPC_GPIO4	= (	LPC_GPIO_TypeDef      *	)	LPC_GPIO4_BASE	;
LPC_WDT_TypeDef       *	const mmrLPC_WDT	= (	LPC_WDT_TypeDef       *	)	LPC_WDT_BASE	;
LPC_TIM_TypeDef       *	const mmrLPC_TIM0	= (	LPC_TIM_TypeDef       *	)	LPC_TIM0_BASE	;
LPC_TIM_TypeDef       *	const mmrLPC_TIM1	= (	LPC_TIM_TypeDef       *	)	LPC_TIM1_BASE	;
LPC_TIM_TypeDef       *	const mmrLPC_TIM2	= (	LPC_TIM_TypeDef       *	)	LPC_TIM2_BASE	;
LPC_TIM_TypeDef       *	const mmrLPC_TIM3	= (	LPC_TIM_TypeDef       *	)	LPC_TIM3_BASE	;
LPC_RIT_TypeDef       *	const mmrLPC_RIT	= (	LPC_RIT_TypeDef       *	)	LPC_RIT_BASE	;
LPC_UART_TypeDef     *	const mmrLPC_UART0	= (	LPC_UART_TypeDef     *	)	LPC_UART0_BASE 	;
LPC_UART1_TypeDef     *	const mmrLPC_UART1	= (	LPC_UART1_TypeDef     *	)	LPC_UART1_BASE	;
LPC_UART_TypeDef      *	const mmrLPC_UART2	= (	LPC_UART_TypeDef      *	)	LPC_UART2_BASE	;
LPC_UART_TypeDef      *	const mmrLPC_UART3	= (	LPC_UART_TypeDef      *	)	LPC_UART3_BASE	;
LPC_PWM_TypeDef       *	const mmrLPC_PWM1	= (	LPC_PWM_TypeDef       *	)	LPC_PWM1_BASE	;
LPC_I2C_TypeDef       *	const mmrLPC_I2C0	= (	LPC_I2C_TypeDef       *	)	LPC_I2C0_BASE	;
LPC_I2C_TypeDef       *	const mmrLPC_I2C1	= (	LPC_I2C_TypeDef       *	)	LPC_I2C1_BASE	;
LPC_I2C_TypeDef       *	const mmrLPC_I2C2	= (	LPC_I2C_TypeDef       *	)	LPC_I2C2_BASE	;
LPC_I2S_TypeDef       *	const mmrLPC_I2S	= (	LPC_I2S_TypeDef       *	)	LPC_I2S_BASE	;
LPC_SPI_TypeDef       *	const mmrLPC_SPI	= (	LPC_SPI_TypeDef       *	)	LPC_SPI_BASE	;
LPC_RTC_TypeDef       *	const mmrLPC_RTC	= (	LPC_RTC_TypeDef       *	)	LPC_RTC_BASE	;
LPC_GPIOINT_TypeDef   *	const mmrLPC_GPIOINT	= (	LPC_GPIOINT_TypeDef   *	)	LPC_GPIOINT_BASE	;
LPC_PINCON_TypeDef    *	const mmrLPC_PINCON	= (	LPC_PINCON_TypeDef    *	)	LPC_PINCON_BASE	;
LPC_SSP_TypeDef       *	const mmrLPC_SSP0	= (	LPC_SSP_TypeDef       *	)	LPC_SSP0_BASE	;
LPC_SSP_TypeDef       *	const mmrLPC_SSP1	= (	LPC_SSP_TypeDef       *	)	LPC_SSP1_BASE	;
LPC_ADC_TypeDef       *	const mmrLPC_ADC	= (	LPC_ADC_TypeDef       *	)	LPC_ADC_BASE	;
LPC_DAC_TypeDef       *	const mmrLPC_DAC	= (	LPC_DAC_TypeDef       *	)	LPC_DAC_BASE	;
LPC_CANAF_RAM_TypeDef *	const mmrLPC_CANAF_RAM	= (	LPC_CANAF_RAM_TypeDef *	)	LPC_CANAF_RAM_BASE	;
LPC_CANAF_TypeDef     *	const mmrLPC_CANAF	= (	LPC_CANAF_TypeDef     *	)	LPC_CANAF_BASE	;
LPC_CANCR_TypeDef     *	const mmrLPC_CANCR	= (	LPC_CANCR_TypeDef     *	)	LPC_CANCR_BASE	;
LPC_CAN_TypeDef       *	const mmrLPC_CAN1	= (	LPC_CAN_TypeDef       *	)	LPC_CAN1_BASE	;
LPC_CAN_TypeDef       *	const mmrLPC_CAN2	= (	LPC_CAN_TypeDef       *	)	LPC_CAN2_BASE	;
LPC_MCPWM_TypeDef     *	const mmrLPC_MCPWM	= (	LPC_MCPWM_TypeDef     *	)	LPC_MCPWM_BASE	;
LPC_QEI_TypeDef       *	const mmrLPC_QEI	= (	LPC_QEI_TypeDef       *	)	LPC_QEI_BASE	;
LPC_EMAC_TypeDef      *	const mmrLPC_EMAC	= (	LPC_EMAC_TypeDef      *	)	LPC_EMAC_BASE	;
LPC_GPDMA_TypeDef     *	const mmrLPC_GPDMA	= (	LPC_GPDMA_TypeDef     *	)	LPC_GPDMA_BASE	;
__IO uint32_t 		 *	const mmrDMAREQSEL	= (	__IO uint32_t *	)	0x4000C1C4	;
LPC_GPDMACH_TypeDef   *	const mmrLPC_GPDMACH0	= (	LPC_GPDMACH_TypeDef   *	)	LPC_GPDMACH0_BASE	;
LPC_GPDMACH_TypeDef   *	const mmrLPC_GPDMACH1	= (	LPC_GPDMACH_TypeDef   *	)	LPC_GPDMACH1_BASE	;
LPC_GPDMACH_TypeDef   *	const mmrLPC_GPDMACH2	= (	LPC_GPDMACH_TypeDef   *	)	LPC_GPDMACH2_BASE	;
LPC_GPDMACH_TypeDef   *	const mmrLPC_GPDMACH3	= (	LPC_GPDMACH_TypeDef   *	)	LPC_GPDMACH3_BASE	;
LPC_GPDMACH_TypeDef   *	const mmrLPC_GPDMACH4	= (	LPC_GPDMACH_TypeDef   *	)	LPC_GPDMACH4_BASE	;
LPC_GPDMACH_TypeDef   *	const mmrLPC_GPDMACH5	= (	LPC_GPDMACH_TypeDef   *	)	LPC_GPDMACH5_BASE	;
LPC_GPDMACH_TypeDef   *	const mmrLPC_GPDMACH6	= (	LPC_GPDMACH_TypeDef   *	)	LPC_GPDMACH6_BASE	;
LPC_GPDMACH_TypeDef   *	const mmrLPC_GPDMACH7	= (	LPC_GPDMACH_TypeDef   *	)	LPC_GPDMACH7_BASE	;
LPC_USB_TypeDef       *	const mmrLPC_USB	= (	LPC_USB_TypeDef       *	)	LPC_USB_BASE	;
