<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0"
  xmlns    ="http://www.w3.org/1999/xhtml"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:xs ="http://www.w3.org/2001/XMLSchema">
<xsl:template match="/">
 <xsl:apply-templates select="xs:schema" />
</xsl:template>

<xsl:template match="xs:schema">
 <html xml:lang="ja">
  <head>
   <title>XML Schema</title>
   <meta http-equiv="content-type" content="application/xhtml+xml; charset=utf-8" />
   <link rel="stylesheet" href="style.css" type="text/css" />
  </head>
  <body>
   <h1>XML Schema</h1>

  <ul id="menu">
   <li><a href="readme.html">Readme</a></li>
   <li><a href="files.html">Files</a></li>
   <li><a href="history.html">History</a></li>
   <li><a href="api/index.html">TPI spec</a></li>
   <li>XML spec</li>
   <li><a href="license.txt">License</a></li>
   <li><br /></li>
   <li>XML spec:</li>
   <li><a href="#about">About</a></li>
   <li><a href="#element">Element</a></li>
   <li><a href="#complex">Complex type</a></li>
   <li><a href="#simple">Simple type</a></li>
   <li><a href="#attrgrp">Attribute group</a></li>
  </ul>

   <h2 id="about">About</h2>
   <p>This is schema file of TPI's common XML.</p>
   <h2 id="element">Element</h2>
   <xsl:apply-templates select="xs:element" />
   <h2 id="complex">Complex type</h2>
   <xsl:apply-templates select="xs:complexType" />
   <h2 id="simple">Simple type</h2>
   <xsl:apply-templates select="xs:simpleType" />
   <h2 id="attrgrp">Attribute group</h2>
   <xsl:apply-templates select="xs:attributeGroup" />
  </body>
 </html>
</xsl:template>

<xsl:template name="base">
 <h3>
  <xsl:attribute name="id">
   <xsl:value-of select="@name" />
  </xsl:attribute>
  <xsl:value-of select="@name" />
 </h3>
 <div style="white-space:pre">
  <xsl:value-of select="xs:annotation/xs:documentation" />
 </div>
 <xsl:apply-templates select="xs:sequence" />
</xsl:template>

<xsl:template name="type">
 <xsl:choose>
  <xsl:when test="@type='xs:string'">(string)</xsl:when>
  <xsl:when test="@type='xs:int'">(int)</xsl:when>
  <xsl:when test="@type='xs:boolean'">(bool)</xsl:when>
  <xsl:otherwise>
   <a>
    <xsl:attribute name="href">#<xsl:value-of select="@type" /></xsl:attribute>
    <xsl:value-of select="@type" />
   </a>
  </xsl:otherwise>
 </xsl:choose>
</xsl:template>

<xsl:template name="attributes">
 <xsl:if test="count(xs:attribute)!=0">
 <table>
  <colgroup span="1" />
  <colgroup>
   <col span="1" style="text-align: center" />
   <col span="1" style="text-align: right" />
  </colgroup>
  <thead>
   <tr><th>attribute</th><th>type</th><th>default</th><th>description</th></tr>
  </thead>
  <tbody>
   <xsl:for-each select="xs:attribute">
    <tr>
     <td>
      <xsl:if test="@use='required'">
       <xsl:attribute name="style">color: red</xsl:attribute>
       <xsl:attribute name="title">Required</xsl:attribute>
      </xsl:if>
      <xsl:value-of select="@name" />
     </td>
     <td><xsl:call-template name="type" /></td>
     <td><xsl:value-of select="@default" /></td>
     <td><xsl:value-of select="xs:annotation/xs:documentation" /></td>
    </tr>
   </xsl:for-each>
   <xsl:if test="count(xs:attributeGroup)!=0">
    <tr>
     <td colspan="4">
      Attribute group: 
      <xsl:for-each select="xs:attributeGroup">
       <a>
        <xsl:attribute name="href">#<xsl:value-of select="@ref" /></xsl:attribute>
        <xsl:value-of select="@ref" />
       </a>
       <xsl:if test="position()!=last()">, </xsl:if>
      </xsl:for-each>
     </td>
    </tr>
   </xsl:if>
  </tbody>
 </table>
 </xsl:if>
</xsl:template>

<xsl:template match="xs:simpleType">
 <xsl:call-template name="base" />
 <h4>Restriction</h4>
 <p>Derived from <xsl:value-of select="xs:restriction/@base" />.</p>
</xsl:template>

<xsl:template match="xs:complexType">
 <xsl:call-template name="base" />
 <xsl:call-template name="attributes" />
</xsl:template>

<xsl:template match="xs:attributeGroup">
 <xsl:call-template name="base" />
 <xsl:call-template name="attributes" />
</xsl:template>

<xsl:template match="xs:element">
 <xsl:call-template name="base" />
 <p>Type is <xsl:call-template name="type" />.</p>
</xsl:template>

<xsl:template match="xs:sequence">
 <h4>Children</h4>
 <table>
  <thead>
   <tr><th>name</th><th>min</th><th>max</th></tr>
  </thead>
  <tbody>
   <xsl:for-each select="xs:element">
    <tr>
     <td>
      <a>
       <xsl:attribute name="href">#<xsl:value-of select="@ref" /></xsl:attribute>
       <xsl:value-of select="@ref" />
      </a>
     </td>
     <td><xsl:value-of select="@minOccurs" /></td>
     <td><xsl:value-of select="@maxOccurs" /></td>
    </tr>
   </xsl:for-each>
  </tbody>
 </table>
</xsl:template>

</xsl:stylesheet>