/*******************************************************************************
  TPI - flexible but useless plug-in framework.
  Copyright (C) 2002-2009 Silky

  This library is free software; you can redistribute it and/or modify it under
  the terms of the GNU Lesser General Public License as published by the Free
  Software Foundation; either version 2.1 of the License, or (at your option)
  any later version.

  This library is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or 
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License
  for more details.

  You should have received a copy of the GNU Lesser General Public License along
  with this library; if not, write to the Free Software Foundation, Inc.,
  51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA

  $Id$
*******************************************************************************/

#include "lychee.h"
#include "cls_config.h"

//******************************************************************************
// myConfig
//******************************************************************************

myConfig::myConfig() : wxFileConfig(wxEmptyString, wxEmptyString, L_DIR_BIN wxT("lychee.conf"), wxEmptyString, wxCONFIG_USE_LOCAL_FILE | wxCONFIG_USE_RELATIVE_PATH)
{
	// 設定名とIDを対応。
	this->label[CONF_WINDOW_HEIGHT]     = wxT("Window-Height");
	this->label[CONF_WINDOW_WIDTH]      = wxT("Window-Width");
	this->label[CONF_WINDOW_X]          = wxT("Window-X");
	this->label[CONF_WINDOW_Y]          = wxT("Window-Y");
	this->label[CONF_WINDOW_SPLITTER_POS]=wxT("Window-SplitterPos");
	this->label[CONF_WINDOW_STATUSBAR]  = wxT("Window-StatusBar");
	this->label[CONF_WINDOW_TOOLBAR]    = wxT("Window-ToolBar");

	this->label[CONF_LISTVIEW_SHOWMODE] = wxT("ListView-ShowMode");
	this->label[CONF_LISTVIEW_C_FILENAME]=wxT("ListView-C-Filename");
	this->label[CONF_LISTVIEW_C_UNPACKED]=wxT("ListView-C-Unpacked");
	this->label[CONF_LISTVIEW_C_PACKED] = wxT("ListView-C-Packed");
	this->label[CONF_LISTVIEW_C_RATIO]  = wxT("ListView-C-Ratio");
	this->label[CONF_LISTVIEW_C_METHOD] = wxT("ListView-C-Method");
	this->label[CONF_LISTVIEW_C_ATTR]   = wxT("ListView-C-Attr");
	this->label[CONF_LISTVIEW_C_LASTMOD]= wxT("ListView-C-LastMod");
	this->label[CONF_LISTVIEW_C_PATH]   = wxT("ListView-C-Path");
	this->label[CONF_LISTVIEW_C_TYPE]   = wxT("ListView-C-Type");
	this->label[CONF_LISTVIEW_C_NO]     = wxT("ListView-C-No");
	this->label[CONF_LISTVIEW_C_COMMENT]= wxT("ListView-C-Comment");
	this->label[CONF_LISTVIEW_S_COLUMN] = wxT("ListView-SortColumn");
	this->label[CONF_LISTVIEW_S_ASCEND] = wxT("ListView-SortAscend");

	this->label[CONF_DEFAULT_EXT]       = wxT("DefaultExt");
	this->label[CONF_DEFAULT_PATH]      = wxT("DefaultPath");

	this->label[CONF_HISTORY_PATH]      = wxT("History-Path%d");
	this->label[CONF_HISTORY_NAME]      = wxT("History-Name%d");
	this->label[CONF_HISTORY_FULL]      = wxT("History-Full%d");
	this->label[CONF_HISTORY_COUNT]     = wxT("History-Count");

	this->label[CONF_PROCESS_DLG]       = wxT("Process-Dialog");

	// 履歴読み込み。
	for (long i = 0; i < this->ReadId(CONF_HISTORY_COUNT, 7l); i++)
	{
		this->myReadHistory(CONF_HISTORY_PATH, i);
		this->myReadHistory(CONF_HISTORY_NAME, i);
		this->myReadHistory(CONF_HISTORY_FULL, i);
	}
	this->bWriteHistory = false;
}

myConfig::~myConfig()
{
	// 設定ファイルに書き込めない場合にエラーダイアログが表示されるのを抑制。
	if (! wxFileName::IsDirWritable(L_DIR_BIN))
	{
		wxLog::EnableLogging(false);
	}

	if (this->bWriteHistory)
	{
		this->myWriteHistoryLoop(CONF_HISTORY_PATH);
		this->myWriteHistoryLoop(CONF_HISTORY_NAME);
		this->myWriteHistoryLoop(CONF_HISTORY_FULL);
	}
}

//******************************************************************************
// General
//******************************************************************************

wxString myConfig::ReadId(myConfigId confId, const wxString & defaultVal)
{
	return this->Read(this->label[confId], defaultVal);
}

long myConfig::ReadId(myConfigId confId, long defaultVal)
{
	return this->Read(this->label[confId], defaultVal);
}

bool myConfig::ReadId(myConfigId confId, bool defaultVal)
{
	bool b = defaultVal;
	this->Read(this->label[confId], & b, defaultVal);
	return b;
}

bool myConfig::WriteId(myConfigId confId, const wxString & value)
{
	return this->Write(this->label[confId], value);
}

bool myConfig::WriteId(myConfigId confId, int value)
{
	return this->Write(this->label[confId], value);
}

bool myConfig::WriteId(myConfigId confId, bool value)
{
	return this->Write(this->label[confId], value);
}

//******************************************************************************
// History
//******************************************************************************

void myConfig::myReadHistory(myConfigId confId, size_t i)
{
	wxArrayString * as = & this->asHistory[confId - CONF_HISTORY_PATH];
	wxString sz = this->Read(wxString::Format(this->label[confId], i), wxEmptyString);
	if (! sz.IsEmpty() && as->Index(sz) == wxNOT_FOUND)
	{
		as->Add(sz);
	}
}

void myConfig::myWriteHistory(myConfigId confId, size_t i)
{
	this->Write(wxString::Format(this->label[confId], i), this->asHistory[confId - CONF_HISTORY_PATH][i]);
}

void myConfig::myWriteHistoryLoop(myConfigId confId)
{
	for (size_t i = 0; i < (size_t) this->ReadId(CONF_HISTORY_COUNT, 7l) && i < this->GetHistoryCount(confId); i++)
	{
		this->myWriteHistory(confId, i);
	}
}

size_t myConfig::GetHistoryCount(myConfigId confId)
{
	return this->asHistory[confId - CONF_HISTORY_PATH].GetCount();
}

wxString myConfig::ReadHistory(myConfigId confId, size_t i)
{
	return i < this->GetHistoryCount(confId) ? this->asHistory[confId - CONF_HISTORY_PATH][i] : (wxString) wxEmptyString;
}

void myConfig::WriteHistory(myConfigId confId, const wxString & sz)
{
	if (sz.IsEmpty())
	{
		return;
	}
	this->bWriteHistory = true;

	wxArrayString * as = & this->asHistory[confId - CONF_HISTORY_PATH];
	if (as->Index(sz) != wxNOT_FOUND)
	{
		as->Remove(sz);
	}
	as->Insert(sz, 0);
}
