/*******************************************************************************
  TPI - flexible but useless plug-in framework.
  Copyright (C) 2002-2009 Silky

  This library is free software; you can redistribute it and/or modify it under
  the terms of the GNU Lesser General Public License as published by the Free
  Software Foundation; either version 2.1 of the License, or (at your option)
  any later version.

  This library is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or 
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License
  for more details.

  You should have received a copy of the GNU Lesser General Public License along
  with this library; if not, write to the Free Software Foundation, Inc.,
  51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA

  $Id$
*******************************************************************************/

#include "lychee.h"

#include "cls_listctrl.h"
#include "dlg_make.h"
#include "frm_main.h"
#include "functions.h"

//******************************************************************************
// myListCtrl
//******************************************************************************

IMPLEMENT_DYNAMIC_CLASS(myListCtrl, wxListView)

//******************************************************************************
// Event Table.
//******************************************************************************

BEGIN_EVENT_TABLE(myListCtrl, wxListView)
	// ListView
	EVT_LIST_COL_CLICK(XRCID("ListView"), myListCtrl::OnColClick)
END_EVENT_TABLE()

//******************************************************************************
// Event handler.
//******************************************************************************

wxString myListCtrl::OnGetItemText(long i, long column) const
{
	// リストビューに項目を追加。
	TPI_FILEINFO * fi = (TPI_FILEINFO *) this->apShowFile[i];
	switch (column)
	{
	case 0:
		return fi->fnFileName.GetFullName();
	case 1:
		return wxString::Format(wxString("%" wxLongLongFmtSpec "u"), fi->nUnpackedSize);
	case 2:
		return wxString::Format(wxString("%" wxLongLongFmtSpec "u"), fi->nPackedSize);
	case 3:
		return wxString::Format(wxT("%3.1f%%"), fi->wCompressRatio / 10.0);
	case 4:
		return fi->szMethod;
	case 5:
	{
#ifdef __WINDOWS__
		wxString szTemp = wxT("---w-");
		szTemp[0] = fi->dwAttribute & TPI_ATTRIBUTE_DIRECTORY ? wxT('d') :
		            fi->dwAttribute & TPI_ATTRIBUTE_ARCHIVE   ? wxT('a') : wxT('-');
		szTemp[1] = fi->dwAttribute & TPI_ATTRIBUTE_SYSTEM    ? wxT('s') : wxT('-');
		szTemp[2] = fi->dwAttribute & TPI_ATTRIBUTE_HIDDEN    ? wxT('h') : wxT('-');
		szTemp[3] = fi->dwAttribute & TPI_ATTRIBUTE_READONLY  ? wxT('r') : wxT('w');
		szTemp[4] = fi->dwAttribute & TPI_ATTRIBUTE_ENCRYPTED ? wxT('g') : wxT('-');
		return szTemp;
#else
		return wxString::Format(wxT("%o"), fi->wPermission);
#endif
	}
	case 6:
		return fi->tmModify.Format(_("%Y/%m/%d %H:%M:%S"));
	case 7:
		return fi->fnFileName.GetPath();
	case 8:
		return GetFileTypeName(fi->fnFileName);
	case 9:
		return wxString::Format(wxString("%" wxLongLongFmtSpec "u"), fi->nFileId);
	case 10:
		return fi->szComment;
	default:
		return wxEmptyString;
	}
}

int myListCtrl::OnGetItemImage(long i) const
{
	wxIcon icon = GetFileTypeIcon(((TPI_FILEINFO *) this->apShowFile[i])->fnFileName);
	g_hIconLL.Add(icon);
	return g_hIconLS.Add(myRescaleIcon(icon));
}

wxListItemAttr * myListCtrl::OnGetItemAttr(long i) const
{
	TPI_FILEINFO * fi = (TPI_FILEINFO *) this->apShowFile[i];
	return
		fi->eDanger                               ? (wxListItemAttr *) & this->atDangerItem :
		fi->dwAttribute & TPI_ATTRIBUTE_ENCRYPTED ? (wxListItemAttr *) & this->atEncryptedItem : nullptr;
}

void myListCtrl::OnColClick(wxListEvent& e)
{
	g_nSortColumn = e.GetColumn();
	g_fSortAscend = ! (g_nSortColumn == e.GetColumn() && g_fSortAscend);

	// ソート。
	size_t nCount = this->apShowFile.GetCount();
	this->apShowFile.Sort(& ListCtrlCompareProc);
	this->SetItemCount(nCount);
	this->RefreshItems(0, nCount - 1);
}

//******************************************************************************
//    諸処理関数
//******************************************************************************

#define NumCmp(member) (item1->member < item2->member) ? -1 : ((item1->member > item2->member) ? 1 : 0)

int ListCtrlCompareProc(void ** pItem1, void ** pItem2)
{
	TPI_FILEINFO * item1 = (TPI_FILEINFO *) * pItem1, * item2 = (TPI_FILEINFO *) * pItem2;
	return (g_fSortAscend ? 1 : -1) * (
		g_nSortColumn == 0 ? ::wxStricmp(item1->fnFileName.GetFullName(), item2->fnFileName.GetFullName()) : // Filename
		g_nSortColumn == 1 ? NumCmp(nUnpackedSize) : // Unpacked
		g_nSortColumn == 2 ? NumCmp(nPackedSize) : // Packed
		g_nSortColumn == 3 ? NumCmp(wCompressRatio) : // Ratio
		g_nSortColumn == 6 ? NumCmp(tmModify) : // Last modified
		g_nSortColumn == 7 ? ::wxStricmp(item1->fnFileName.GetPath(), item2->fnFileName.GetPath()) : // Path
		g_nSortColumn == 8 ? ::wxStricmp(GetFileTypeName(item1->fnFileName), GetFileTypeName(item2->fnFileName)) : // Type
		g_nSortColumn == 9 ? NumCmp(nFileId) : // No
		g_nSortColumn == 10? ::wxStricmp(item1->szComment, item2->szComment) : // Comment
		0);
}
