/*
 * Decompiled with CFR 0.152.
 */
package org.afree.chart.demo;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.PointF;
import android.os.Handler;
import android.util.AttributeSet;
import android.util.Log;
import android.view.MotionEvent;
import android.view.View;
import java.util.ArrayList;
import org.afree.chart.AFreeChart;
import org.afree.chart.ChartRenderingInfo;
import org.afree.chart.ChartTouchListener;
import org.afree.chart.entity.EntityCollection;
import org.afree.chart.plot.Movable;
import org.afree.chart.plot.Plot;
import org.afree.chart.plot.PlotOrientation;
import org.afree.chart.plot.PlotRenderingInfo;
import org.afree.chart.plot.Zoomable;
import org.afree.graphics.SolidColor;
import org.afree.graphics.geom.Dimension;
import org.afree.graphics.geom.RectShape;
import org.afree.ui.RectangleInsets;

public class DemoView
extends View {
    private Handler mHandler;
    public static final boolean DEFAULT_BUFFER_USED = true;
    public static final int DEFAULT_WIDTH = 680;
    public static final int DEFAULT_HEIGHT = 420;
    public static final int DEFAULT_MINIMUM_DRAW_WIDTH = 10;
    public static final int DEFAULT_MINIMUM_DRAW_HEIGHT = 10;
    public static final int DEFAULT_MAXIMUM_DRAW_WIDTH = 1024;
    public static final int DEFAULT_MAXIMUM_DRAW_HEIGHT = 1000;
    public static final int DEFAULT_ZOOM_TRIGGER_DISTANCE = 10;
    public static final int DEFAULT_MOVE_TRIGGER_DISTANCE = 10;
    private AFreeChart chart;
    private ChartRenderingInfo info;
    private double scaleX;
    private double scaleY;
    private PlotOrientation orientation = PlotOrientation.VERTICAL;
    private PointF zoomPoint = null;
    private int moveTriggerDistance;
    private RectangleInsets insets = null;
    private int minimumDrawWidth;
    private int minimumDrawHeight;
    private int maximumDrawWidth;
    private int maximumDrawHeight;
    private Dimension size = null;
    private PointF anchor;
    private boolean domainMovable = false;
    private boolean rangeMovable = false;
    private double accelX;
    private double accelY;
    private double friction = 0.8;
    private boolean inertialMovedFlag = false;
    private PointF lastTouch;
    private float mScale = 1.0f;
    private long mPrevTimeMillis = 0L;
    private long mNowTimeMillis = System.currentTimeMillis();
    private MultiTouchStartInfo multiTouchStartInfo = null;
    private SingleTouchStartInfo singleTouchStartInfo = null;

    public DemoView(Context context) {
        super(context);
        this.mHandler = new Handler();
        this.initialize();
    }

    public DemoView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.mHandler = new Handler();
        this.initialize();
    }

    private void initialize() {
        this.info = new ChartRenderingInfo();
        this.minimumDrawWidth = 10;
        this.minimumDrawHeight = 10;
        this.maximumDrawWidth = 1024;
        this.maximumDrawHeight = 1000;
        this.moveTriggerDistance = 10;
        new SolidColor(-16776961);
        new SolidColor(Color.argb((int)0, (int)0, (int)255, (int)63));
        new ArrayList();
    }

    public boolean onTouchEvent(MotionEvent ev) {
        super.onTouchEvent(ev);
        int action = ev.getAction();
        int count = ev.getPointerCount();
        this.anchor = new PointF(ev.getX(), ev.getY());
        if (this.info != null) {
            EntityCollection entityCollection = this.info.getEntityCollection();
        }
        switch (action & 0xFF) {
            case 0: 
            case 5: {
                Log.i((String)"TouchEvent", (String)"ACTION_DOWN");
                if (count == 2 && this.multiTouchStartInfo == null) {
                    this.setMultiTouchStartInfo(ev);
                } else if (count == 1 && this.singleTouchStartInfo == null) {
                    this.setSingleTouchStartInfo(ev);
                }
                this.chart.handleClick((int)ev.getX(), (int)ev.getY(), this.info);
                this.invalidate();
                this.inertialMovedFlag = false;
                break;
            }
            case 2: {
                Log.i((String)"TouchEvent", (String)"ACTION_MOVE");
                if (count == 1 && this.singleTouchStartInfo != null) {
                    this.moveAdjustment(ev);
                } else if (count == 2 && this.multiTouchStartInfo != null) {
                    this.zoomAdjustment(ev);
                }
                this.inertialMovedFlag = false;
                break;
            }
            case 1: 
            case 6: {
                Log.i((String)"TouchEvent", (String)"ACTION_UP");
                if (count <= 2) {
                    this.multiTouchStartInfo = null;
                    this.singleTouchStartInfo = null;
                }
                if (count <= 1) {
                    this.singleTouchStartInfo = null;
                }
                this.mNowTimeMillis = System.currentTimeMillis();
                if (this.mNowTimeMillis - this.mPrevTimeMillis < 400L) {
                    if (this.chart.getPlot() instanceof Movable) {
                        this.restoreAutoBounds();
                        this.inertialMovedFlag = false;
                    }
                } else {
                    this.inertialMovedFlag = true;
                }
                this.mPrevTimeMillis = this.mNowTimeMillis;
                break;
            }
        }
        return true;
    }

    private void setMultiTouchStartInfo(MotionEvent ev) {
        if (this.multiTouchStartInfo == null) {
            this.multiTouchStartInfo = new MultiTouchStartInfo();
        }
        double distance = Math.sqrt(Math.pow(ev.getX(0) - ev.getX(1), 2.0) + Math.pow(ev.getY(0) - ev.getY(1), 2.0));
        this.multiTouchStartInfo.setDistance(distance);
    }

    private void setSingleTouchStartInfo(MotionEvent ev) {
        if (this.singleTouchStartInfo == null) {
            this.singleTouchStartInfo = new SingleTouchStartInfo();
        }
        this.singleTouchStartInfo.setX(ev.getX(0));
        this.singleTouchStartInfo.setY(ev.getY(0));
    }

    private void moveAdjustment(MotionEvent ev) {
        boolean moveTrigger2;
        boolean hMove = false;
        boolean vMove = false;
        if (this.orientation == PlotOrientation.HORIZONTAL) {
            hMove = this.rangeMovable;
            vMove = this.domainMovable;
        } else {
            hMove = this.domainMovable;
            vMove = this.rangeMovable;
        }
        boolean moveTrigger1 = hMove && Math.abs((double)ev.getX(0) - this.singleTouchStartInfo.getX()) >= (double)this.moveTriggerDistance;
        boolean bl = moveTrigger2 = vMove && Math.abs((double)ev.getY(0) - this.singleTouchStartInfo.getY()) >= (double)this.moveTriggerDistance;
        if (moveTrigger1 || moveTrigger2) {
            double moveBoundY;
            double moveBoundX;
            RectShape dataArea = this.info.getPlotInfo().getDataArea();
            double dataAreaWidth = dataArea.getWidth();
            double dataAreaHeight = dataArea.getHeight();
            if (!vMove) {
                moveBoundX = this.singleTouchStartInfo.getX() - (double)ev.getX(0);
                moveBoundY = 0.0;
            } else if (!hMove) {
                moveBoundX = 0.0;
                moveBoundY = this.singleTouchStartInfo.getY() - (double)ev.getY(0);
            } else {
                moveBoundX = this.singleTouchStartInfo.getX() - (double)ev.getX(0);
                moveBoundY = this.singleTouchStartInfo.getY() - (double)ev.getY(0);
            }
            this.accelX = moveBoundX;
            this.accelY = moveBoundY;
            this.lastTouch = new PointF(ev.getX(0), ev.getY(0));
            this.move(this.lastTouch, moveBoundX, moveBoundY, dataAreaWidth, dataAreaHeight);
        }
        this.setSingleTouchStartInfo(ev);
    }

    private void move(PointF source, double moveBoundX, double moveBoundY, double dataAreaWidth, double dataAreaHeight) {
        double hMovePercent = moveBoundX / dataAreaWidth;
        double vMovePercent = -moveBoundY / dataAreaHeight;
        Plot p = this.chart.getPlot();
        if (p instanceof Movable) {
            PlotRenderingInfo info = this.info.getPlotInfo();
            Movable z = (Movable)((Object)p);
            if (z.getOrientation() == PlotOrientation.HORIZONTAL) {
                z.moveDomainAxes(vMovePercent, info, source);
                z.moveRangeAxes(hMovePercent, info, source);
            } else {
                z.moveDomainAxes(hMovePercent, info, source);
                z.moveRangeAxes(vMovePercent, info, source);
            }
            this.invalidate();
        }
    }

    public void restoreAutoBounds() {
        Plot plot = this.chart.getPlot();
        if (plot == null) {
            return;
        }
        this.restoreAutoDomainBounds();
        this.restoreAutoRangeBounds();
    }

    public void restoreAutoDomainBounds() {
        Plot plot = this.chart.getPlot();
        if (plot instanceof Zoomable) {
            Zoomable z = (Zoomable)((Object)plot);
            PointF zp = this.zoomPoint != null ? this.zoomPoint : new PointF();
            z.zoomDomainAxes(0.0, this.info.getPlotInfo(), zp);
        }
    }

    public void restoreAutoRangeBounds() {
        Plot plot = this.chart.getPlot();
        if (plot instanceof Zoomable) {
            Zoomable z = (Zoomable)((Object)plot);
            PointF zp = this.zoomPoint != null ? this.zoomPoint : new PointF();
            z.zoomRangeAxes(0.0, this.info.getPlotInfo(), zp);
        }
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        this.insets = new RectangleInsets(0.0, 0.0, 0.0, 0.0);
        this.size = new Dimension(w, h);
    }

    private RectangleInsets getInsets() {
        return this.insets;
    }

    public double getScaleX() {
        return this.scaleX;
    }

    public double getScaleY() {
        return this.scaleY;
    }

    public void setChart(AFreeChart chart) {
        this.chart = chart;
        if (chart != null) {
            Object z;
            Plot plot = chart.getPlot();
            if (plot instanceof Zoomable) {
                z = (Zoomable)((Object)plot);
                z.isRangeZoomable();
                this.orientation = z.getOrientation();
            }
            this.domainMovable = false;
            this.rangeMovable = false;
            if (plot instanceof Movable) {
                z = (Movable)((Object)plot);
                this.domainMovable = z.isDomainMovable();
                this.rangeMovable = z.isRangeMovable();
                this.orientation = z.getOrientation();
            }
        } else {
            this.domainMovable = false;
            this.rangeMovable = false;
        }
    }

    public int getMinimumDrawWidth() {
        return this.minimumDrawWidth;
    }

    public void setMinimumDrawWidth(int width) {
        this.minimumDrawWidth = width;
    }

    public int getMaximumDrawWidth() {
        return this.maximumDrawWidth;
    }

    public void setMaximumDrawWidth(int width) {
        this.maximumDrawWidth = width;
    }

    public int getMinimumDrawHeight() {
        return this.minimumDrawHeight;
    }

    public void setMinimumDrawHeight(int height) {
        this.minimumDrawHeight = height;
    }

    public int getMaximumDrawHeight() {
        return this.maximumDrawHeight;
    }

    public void setMaximumDrawHeight(int height) {
        this.maximumDrawHeight = height;
    }

    public ChartRenderingInfo getChartRenderingInfo() {
        return this.info;
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        this.inertialMove();
        this.paintComponent(canvas);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
    }

    public void paintComponent(Canvas canvas) {
        Dimension size = this.getSize();
        RectangleInsets insets = this.getInsets();
        RectShape available = new RectShape(insets.getLeft(), insets.getTop(), (double)size.getWidth() - insets.getLeft() - insets.getRight(), (double)size.getHeight() - insets.getTop() - insets.getBottom());
        double drawWidth = available.getWidth();
        double drawHeight = available.getHeight();
        this.scaleX = 1.0;
        this.scaleY = 1.0;
        if (drawWidth < (double)this.minimumDrawWidth) {
            this.scaleX = drawWidth / (double)this.minimumDrawWidth;
            drawWidth = this.minimumDrawWidth;
        } else if (drawWidth > (double)this.maximumDrawWidth) {
            this.scaleX = drawWidth / (double)this.maximumDrawWidth;
            drawWidth = this.maximumDrawWidth;
        }
        if (drawHeight < (double)this.minimumDrawHeight) {
            this.scaleY = drawHeight / (double)this.minimumDrawHeight;
            drawHeight = this.minimumDrawHeight;
        } else if (drawHeight > (double)this.maximumDrawHeight) {
            this.scaleY = drawHeight / (double)this.maximumDrawHeight;
            drawHeight = this.maximumDrawHeight;
        }
        RectShape chartArea = new RectShape(0.0, 0.0, drawWidth, drawHeight);
        this.chart.draw(canvas, chartArea, this.anchor, this.info);
        this.anchor = null;
    }

    public Dimension getSize() {
        return this.size;
    }

    public PointF getAnchor() {
        return this.anchor;
    }

    public ChartRenderingInfo getInfo() {
        return this.info;
    }

    protected void setAnchor(PointF anchor) {
        this.anchor = anchor;
    }

    private void zoomAdjustment(MotionEvent ev) {
        PointF point = new PointF((ev.getX(0) + ev.getX(1)) / 2.0f, (ev.getY(0) + ev.getY(1)) / 2.0f);
        double endDistance = Math.sqrt(Math.pow(ev.getX(0) - ev.getX(1), 2.0) + Math.pow(ev.getY(0) - ev.getY(1), 2.0));
        this.zoom(point, this.multiTouchStartInfo.getDistance(), endDistance);
        this.setMultiTouchStartInfo(ev);
    }

    private void zoom(PointF source, double startDistance, double endDistance) {
        float scaleDistance;
        Plot plot = this.chart.getPlot();
        PlotRenderingInfo info = this.info.getPlotInfo();
        if (plot instanceof Zoomable && this.mScale * (scaleDistance = (float)(startDistance / endDistance)) < 10.0f && this.mScale * scaleDistance > 0.1f) {
            this.mScale *= scaleDistance;
            Zoomable z = (Zoomable)((Object)plot);
            z.zoomDomainAxes((double)scaleDistance, info, source, false);
            z.zoomRangeAxes((double)scaleDistance, info, source, false);
        }
        this.invalidate();
    }

    private void inertialMove() {
        if (this.inertialMovedFlag) {
            RectShape dataArea = this.info.getPlotInfo().getDataArea();
            this.accelX *= this.friction;
            this.accelY *= this.friction;
            double dataAreaWidth = dataArea.getWidth();
            double dataAreaHeight = dataArea.getHeight();
            this.move(this.lastTouch, this.accelX, this.accelY, dataAreaWidth, dataAreaHeight);
            if (this.accelX < 0.1 && this.accelX > -0.1) {
                this.accelX = 0.0;
            }
            if (this.accelY < 0.1 && this.accelY > -0.1) {
                this.accelY = 0.0;
            }
            if (this.accelX == 0.0 && this.accelY == 0.0) {
                this.inertialMovedFlag = false;
            }
        }
    }

    public void touched(MotionEvent event) {
        int x = (int)((double)event.getX() / this.scaleX);
        int y = (int)((double)event.getY() / this.scaleY);
        this.anchor = new PointF((float)x, (float)y);
        if (this.chart == null) {
            return;
        }
        this.chart.setNotify(true);
        if (this.info != null) {
            EntityCollection entityCollection = this.info.getEntityCollection();
        }
    }

    public AFreeChart getChart() {
        return this.chart;
    }

    public void addChartTouchListener(ChartTouchListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Null 'listener' argument.");
        }
    }

    public void removeChartTouchListener(ChartTouchListener listener) {
    }

    public void repaint() {
        this.mHandler.post(new Runnable(){

            public void run() {
                DemoView.this.invalidate();
            }
        });
    }

    private class MultiTouchStartInfo {
        private double distance = 0.0;

        private MultiTouchStartInfo() {
        }

        public double getDistance() {
            return this.distance;
        }

        public void setDistance(double distance) {
            this.distance = distance;
        }
    }

    private class SingleTouchStartInfo {
        private double x = 0.0;
        private double y = 0.0;

        private SingleTouchStartInfo() {
        }

        public double getX() {
            return this.x;
        }

        public void setX(double x) {
            this.x = x;
        }

        public double getY() {
            return this.y;
        }

        public void setY(double y) {
            this.y = y;
        }
    }
}

