/*
 * Decompiled with CFR 0.152.
 */
package org.afree.chart.plot.dial;

import android.graphics.Canvas;
import android.graphics.PointF;
import android.graphics.Region;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.List;
import org.afree.chart.plot.Plot;
import org.afree.chart.plot.PlotRenderingInfo;
import org.afree.chart.plot.PlotState;
import org.afree.chart.plot.dial.AbstractDialLayer;
import org.afree.chart.plot.dial.ArcDialFrame;
import org.afree.chart.plot.dial.DialFrame;
import org.afree.chart.plot.dial.DialLayer;
import org.afree.chart.plot.dial.DialLayerChangeEvent;
import org.afree.chart.plot.dial.DialLayerChangeListener;
import org.afree.chart.plot.dial.DialPointer;
import org.afree.chart.plot.dial.DialScale;
import org.afree.data.general.DatasetChangeEvent;
import org.afree.data.general.ValueDataset;
import org.afree.graphics.geom.RectShape;
import org.afree.util.ObjectList;

public class DialPlot
extends Plot
implements DialLayerChangeListener {
    private static final long serialVersionUID = -3662054685572621903L;
    private DialLayer background = null;
    private DialLayer cap = null;
    private DialFrame dialFrame = new ArcDialFrame();
    private ObjectList datasets = new ObjectList();
    private ObjectList scales;
    private ObjectList datasetToScaleMap;
    private List layers;
    private List pointers;
    private double viewX;
    private double viewY;
    private double viewW;
    private double viewH;

    public DialPlot() {
        this(null);
    }

    public DialPlot(ValueDataset dataset) {
        if (dataset != null) {
            this.setDataset(dataset);
        }
        this.scales = new ObjectList();
        this.datasetToScaleMap = new ObjectList();
        this.layers = new ArrayList();
        this.pointers = new ArrayList();
        this.viewX = 0.0;
        this.viewY = 0.0;
        this.viewW = 1.0;
        this.viewH = 1.0;
    }

    public DialLayer getBackground() {
        return this.background;
    }

    public void setBackground(DialLayer background) {
        if (this.background != null) {
            this.background.removeChangeListener(this);
        }
        this.background = background;
        if (background != null) {
            background.addChangeListener(this);
        }
    }

    public DialLayer getCap() {
        return this.cap;
    }

    public void setCap(DialLayer cap) {
        if (this.cap != null) {
            this.cap.removeChangeListener(this);
        }
        this.cap = cap;
        if (cap != null) {
            cap.addChangeListener(this);
        }
    }

    public DialFrame getDialFrame() {
        return this.dialFrame;
    }

    public void setDialFrame(DialFrame frame) {
        if (frame == null) {
            throw new IllegalArgumentException("Null 'frame' argument.");
        }
        this.dialFrame.removeChangeListener(this);
        this.dialFrame = frame;
        frame.addChangeListener(this);
    }

    public double getViewX() {
        return this.viewX;
    }

    public double getViewY() {
        return this.viewY;
    }

    public double getViewWidth() {
        return this.viewW;
    }

    public double getViewHeight() {
        return this.viewH;
    }

    public void setView(double x, double y, double w, double h) {
        this.viewX = x;
        this.viewY = y;
        this.viewW = w;
        this.viewH = h;
    }

    public void addLayer(DialLayer layer) {
        if (layer == null) {
            throw new IllegalArgumentException("Null 'layer' argument.");
        }
        this.layers.add(layer);
        layer.addChangeListener(this);
    }

    public int getLayerIndex(DialLayer layer) {
        if (layer == null) {
            throw new IllegalArgumentException("Null 'layer' argument.");
        }
        return this.layers.indexOf(layer);
    }

    public void removeLayer(int index) {
        DialLayer layer = (DialLayer)this.layers.get(index);
        if (layer != null) {
            layer.removeChangeListener(this);
        }
        this.layers.remove(index);
    }

    public void removeLayer(DialLayer layer) {
        this.removeLayer(this.getLayerIndex(layer));
    }

    public void addPointer(DialPointer pointer) {
        if (pointer == null) {
            throw new IllegalArgumentException("Null 'pointer' argument.");
        }
        this.pointers.add(pointer);
        pointer.addChangeListener(this);
    }

    public int getPointerIndex(DialPointer pointer) {
        if (pointer == null) {
            throw new IllegalArgumentException("Null 'pointer' argument.");
        }
        return this.pointers.indexOf(pointer);
    }

    public void removePointer(int index) {
        DialPointer pointer = (DialPointer)this.pointers.get(index);
        if (pointer != null) {
            pointer.removeChangeListener(this);
        }
        this.pointers.remove(index);
    }

    public void removePointer(DialPointer pointer) {
        this.removeLayer(this.getPointerIndex(pointer));
    }

    public DialPointer getPointerForDataset(int datasetIndex) {
        DialPointer result = null;
        for (DialPointer p : this.pointers) {
            if (p.getDatasetIndex() != datasetIndex) continue;
            return p;
        }
        return result;
    }

    public ValueDataset getDataset() {
        return this.getDataset(0);
    }

    public ValueDataset getDataset(int index) {
        ValueDataset result = null;
        if (this.datasets.size() > index) {
            result = (ValueDataset)this.datasets.get(index);
        }
        return result;
    }

    public void setDataset(ValueDataset dataset) {
        this.setDataset(0, dataset);
    }

    public void setDataset(int index, ValueDataset dataset) {
        ValueDataset existing = (ValueDataset)this.datasets.get(index);
        if (existing != null) {
            existing.removeChangeListener(this);
        }
        this.datasets.set(index, dataset);
        if (dataset != null) {
            dataset.addChangeListener(this);
        }
        DatasetChangeEvent event = new DatasetChangeEvent(this, dataset);
        this.datasetChanged(event);
    }

    public int getDatasetCount() {
        return this.datasets.size();
    }

    public void draw(Canvas canvas, RectShape area, PointF anchor, PlotState parentState, PlotRenderingInfo info) {
        RectShape savedClip;
        canvas.getClipBounds();
        canvas.save();
        canvas.clipRect(area.getMinX(), area.getMinY(), area.getMaxX(), area.getMaxY());
        RectShape frame = this.viewToFrame(area);
        if (this.background != null && this.background.isVisible()) {
            if (this.background.isClippedToWindow()) {
                RectShape savedClip2 = new RectShape(canvas.getClipBounds());
                canvas.clipPath(this.dialFrame.getWindow(frame).getPath());
                this.background.draw(canvas, this, frame, area);
                canvas.clipRect(savedClip2.getRectF(), Region.Op.REPLACE);
            } else {
                this.background.draw(canvas, this, frame, area);
            }
        }
        for (DialLayer current : this.layers) {
            if (!current.isVisible()) continue;
            if (current.isClippedToWindow()) {
                savedClip = new RectShape(canvas.getClipBounds());
                canvas.clipPath(this.dialFrame.getWindow(frame).getPath());
                current.draw(canvas, this, frame, area);
                canvas.clipRect(savedClip.getRectF(), Region.Op.REPLACE);
                continue;
            }
            current.draw(canvas, this, frame, area);
        }
        for (DialLayer current : this.pointers) {
            if (!((AbstractDialLayer)current).isVisible()) continue;
            if (((DialPointer)current).isClippedToWindow()) {
                savedClip = new RectShape(canvas.getClipBounds());
                canvas.clipPath(this.dialFrame.getWindow(frame).getPath());
                current.draw(canvas, this, frame, area);
                canvas.clipRect(savedClip.getRectF(), Region.Op.REPLACE);
                continue;
            }
            current.draw(canvas, this, frame, area);
        }
        if (this.cap != null && this.cap.isVisible()) {
            if (this.cap.isClippedToWindow()) {
                RectShape savedClip3 = new RectShape(canvas.getClipBounds());
                canvas.clipPath(this.dialFrame.getWindow(frame).getPath());
                this.cap.draw(canvas, this, frame, area);
                canvas.clipRect(savedClip3.getRectF(), Region.Op.REPLACE);
            } else {
                this.cap.draw(canvas, this, frame, area);
            }
        }
        if (this.dialFrame.isVisible()) {
            this.dialFrame.draw(canvas, this, frame, area);
        }
        canvas.restore();
    }

    private RectShape viewToFrame(RectShape view) {
        double width = (double)view.getWidth() / this.viewW;
        double height = (double)view.getHeight() / this.viewH;
        double x = (double)view.getX() - width * this.viewX;
        double y = (double)view.getY() - height * this.viewY;
        return new RectShape(x, y, width, height);
    }

    public double getValue(int datasetIndex) {
        Number n;
        double result = Double.NaN;
        ValueDataset dataset = this.getDataset(datasetIndex);
        if (dataset != null && (n = dataset.getValue()) != null) {
            result = n.doubleValue();
        }
        return result;
    }

    public void addScale(int index, DialScale scale) {
        if (scale == null) {
            throw new IllegalArgumentException("Null 'scale' argument.");
        }
        DialScale existing = (DialScale)this.scales.get(index);
        if (existing != null) {
            this.removeLayer(existing);
        }
        this.layers.add(scale);
        this.scales.set(index, scale);
        scale.addChangeListener(this);
    }

    public DialScale getScale(int index) {
        DialScale result = null;
        if (this.scales.size() > index) {
            result = (DialScale)this.scales.get(index);
        }
        return result;
    }

    public void mapDatasetToScale(int index, int scaleIndex) {
        this.datasetToScaleMap.set(index, new Integer(scaleIndex));
    }

    public DialScale getScaleForDataset(int datasetIndex) {
        DialScale result = (DialScale)this.scales.get(0);
        Integer scaleIndex = (Integer)this.datasetToScaleMap.get(datasetIndex);
        if (scaleIndex != null) {
            result = this.getScale(scaleIndex);
        }
        return result;
    }

    public static RectShape RectShapeByRadius(RectShape rect, double radiusW, double radiusH) {
        if (rect == null) {
            throw new IllegalArgumentException("Null 'rect' argument.");
        }
        double x = rect.getCenterX();
        double y = rect.getCenterY();
        double w = (double)rect.getWidth() * radiusW;
        double h = (double)rect.getHeight() * radiusH;
        return new RectShape(x - w / 2.0, y - h / 2.0, w, h);
    }

    public void dialLayerChanged(DialLayerChangeEvent event) {
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof DialPlot)) {
            return false;
        }
        DialPlot that = (DialPlot)obj;
        if (!this.dialFrame.equals(that.dialFrame)) {
            return false;
        }
        if (this.viewX != that.viewX) {
            return false;
        }
        if (this.viewY != that.viewY) {
            return false;
        }
        if (this.viewW != that.viewW) {
            return false;
        }
        if (this.viewH != that.viewH) {
            return false;
        }
        if (!this.layers.equals(that.layers)) {
            return false;
        }
        if (!this.pointers.equals(that.pointers)) {
            return false;
        }
        return super.equals(obj);
    }

    public String getPlotType() {
        return "DialPlot";
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
    }
}

