/*
 * Decompiled with CFR 0.152.
 */
package org.afree.chart.title;

import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import java.io.Serializable;
import org.afree.chart.block.BlockResult;
import org.afree.chart.block.EntityBlockParams;
import org.afree.chart.block.LengthConstraintType;
import org.afree.chart.block.RectangleConstraint;
import org.afree.chart.entity.StandardEntityCollection;
import org.afree.chart.entity.TitleEntity;
import org.afree.chart.text.G2TextMeasurer;
import org.afree.chart.text.TextBlock;
import org.afree.chart.text.TextBlockAnchor;
import org.afree.chart.text.TextUtilities;
import org.afree.chart.title.Title;
import org.afree.data.Range;
import org.afree.graphics.PaintType;
import org.afree.graphics.PaintUtility;
import org.afree.graphics.SolidColor;
import org.afree.graphics.geom.Font;
import org.afree.graphics.geom.RectShape;
import org.afree.ui.HorizontalAlignment;
import org.afree.ui.RectangleEdge;
import org.afree.ui.RectangleInsets;
import org.afree.ui.Size2D;
import org.afree.ui.VerticalAlignment;

public class TextTitle
extends Title
implements Serializable,
Cloneable {
    public static final PaintType paintBlack = new SolidColor(Color.argb((int)255, (int)0, (int)0, (int)0));
    private static final long serialVersionUID = 8372008692127477443L;
    public static final Font DEFAULT_FONT = new Font("SansSerif", 1, 12);
    public static final PaintType DEFAULT_TEXT_PAINT_TYPE = paintBlack;
    private String text;
    private Font font;
    private HorizontalAlignment textAlignment;
    private transient PaintType paintType;
    private transient Paint backgroundPaint;
    private String toolTipText;
    private String urlText;
    private TextBlock content;
    private boolean expandToFitSpace = false;
    private int maximumLinesToDisplay = Integer.MAX_VALUE;

    public TextTitle() {
        this("");
    }

    public TextTitle(String text) {
        this(text, DEFAULT_FONT, DEFAULT_TEXT_PAINT_TYPE, Title.DEFAULT_POSITION, Title.DEFAULT_HORIZONTAL_ALIGNMENT, Title.DEFAULT_VERTICAL_ALIGNMENT, Title.DEFAULT_PADDING);
    }

    public TextTitle(String text, Font font) {
        this(text, font, DEFAULT_TEXT_PAINT_TYPE, Title.DEFAULT_POSITION, Title.DEFAULT_HORIZONTAL_ALIGNMENT, Title.DEFAULT_VERTICAL_ALIGNMENT, Title.DEFAULT_PADDING);
    }

    public TextTitle(String text, Font font, PaintType paintType, RectangleEdge position, HorizontalAlignment horizontalAlignment, VerticalAlignment verticalAlignment, RectangleInsets padding) {
        super(position, horizontalAlignment, verticalAlignment, padding);
        if (text == null) {
            throw new NullPointerException("Null 'text' argument.");
        }
        if (font == null) {
            throw new NullPointerException("Null 'font' argument.");
        }
        if (paintType == null) {
            throw new NullPointerException("Null 'paint' argument.");
        }
        this.text = text;
        this.font = font;
        this.paintType = paintType;
        this.textAlignment = horizontalAlignment;
        this.backgroundPaint = null;
        this.content = null;
        this.toolTipText = null;
        this.urlText = null;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        if (text == null) {
            throw new IllegalArgumentException("Null 'text' argument.");
        }
        if (!this.text.equals(text)) {
            this.text = text;
        }
    }

    public HorizontalAlignment getTextAlignment() {
        return this.textAlignment;
    }

    public void setTextAlignment(HorizontalAlignment alignment) {
        if (alignment == null) {
            throw new IllegalArgumentException("Null 'alignment' argument.");
        }
        this.textAlignment = alignment;
    }

    public Font getFont() {
        return this.font;
    }

    public void setFont(Font font) {
        if (font == null) {
            throw new IllegalArgumentException("Null 'font' argument.");
        }
        if (!this.font.equals(font)) {
            this.font = font;
        }
    }

    public PaintType getPaintType() {
        return this.paintType;
    }

    public void setPaintType(PaintType paintType) {
        if (paintType == null) {
            throw new IllegalArgumentException("Null 'paint' argument.");
        }
        if (!this.paintType.equals(paintType)) {
            this.paintType = paintType;
        }
    }

    public Paint getBackgroundPaint() {
        return this.backgroundPaint;
    }

    public void setBackgroundPaint(Paint paint) {
        this.backgroundPaint = paint;
    }

    public String getToolTipText() {
        return this.toolTipText;
    }

    public void setToolTipText(String text) {
        this.toolTipText = text;
    }

    public String getURLText() {
        return this.urlText;
    }

    public void setURLText(String text) {
        this.urlText = text;
    }

    public boolean getExpandToFitSpace() {
        return this.expandToFitSpace;
    }

    public void setExpandToFitSpace(boolean expand) {
        this.expandToFitSpace = expand;
    }

    public int getMaximumLinesToDisplay() {
        return this.maximumLinesToDisplay;
    }

    public void setMaximumLinesToDisplay(int max) {
        this.maximumLinesToDisplay = max;
    }

    public Size2D arrange(Canvas canvas, RectangleConstraint constraint) {
        RectangleConstraint cc = this.toContentConstraint(constraint);
        LengthConstraintType w = cc.getWidthConstraintType();
        LengthConstraintType h = cc.getHeightConstraintType();
        Size2D contentSize = null;
        if (w == LengthConstraintType.NONE) {
            if (h == LengthConstraintType.NONE) {
                contentSize = this.arrangeNN(canvas);
            } else {
                if (h == LengthConstraintType.RANGE) {
                    throw new RuntimeException("Not yet implemented.");
                }
                if (h == LengthConstraintType.FIXED) {
                    throw new RuntimeException("Not yet implemented.");
                }
            }
        } else if (w == LengthConstraintType.RANGE) {
            if (h == LengthConstraintType.NONE) {
                contentSize = this.arrangeRN(canvas, cc.getWidthRange());
            } else if (h == LengthConstraintType.RANGE) {
                contentSize = this.arrangeRR(canvas, cc.getWidthRange(), cc.getHeightRange());
            } else if (h == LengthConstraintType.FIXED) {
                throw new RuntimeException("Not yet implemented.");
            }
        } else if (w == LengthConstraintType.FIXED) {
            if (h == LengthConstraintType.NONE) {
                contentSize = this.arrangeFN(canvas, cc.getWidth());
            } else {
                if (h == LengthConstraintType.RANGE) {
                    throw new RuntimeException("Not yet implemented.");
                }
                if (h == LengthConstraintType.FIXED) {
                    throw new RuntimeException("Not yet implemented.");
                }
            }
        }
        return new Size2D(this.calculateTotalWidth(contentSize.getWidth()), this.calculateTotalHeight(contentSize.getHeight()));
    }

    protected Size2D arrangeNN(Canvas canvas) {
        Range max = new Range(0.0, 3.4028234663852886E38);
        return this.arrangeRR(canvas, max, max);
    }

    protected Size2D arrangeFN(Canvas canvas, double w) {
        RectangleEdge position = this.getPosition();
        Paint paint = PaintUtility.createPaint(1, this.paintType, this.font);
        if (position == RectangleEdge.TOP || position == RectangleEdge.BOTTOM) {
            float maxWidth = (float)w;
            this.content = TextUtilities.createTextBlock(this.text, this.font, this.paintType, maxWidth, this.maximumLinesToDisplay, new G2TextMeasurer(paint));
            this.content.setLineAlignment(this.textAlignment);
            Size2D contentSize = this.content.calculateDimensions(canvas);
            if (this.expandToFitSpace) {
                return new Size2D(maxWidth, contentSize.getHeight());
            }
            return contentSize;
        }
        if (position == RectangleEdge.LEFT || position == RectangleEdge.RIGHT) {
            float maxWidth = Float.MAX_VALUE;
            this.content = TextUtilities.createTextBlock(this.text, this.font, this.paintType, maxWidth, this.maximumLinesToDisplay, new G2TextMeasurer(paint));
            this.content.setLineAlignment(this.textAlignment);
            Size2D contentSize = this.content.calculateDimensions(canvas);
            if (this.expandToFitSpace) {
                return new Size2D(contentSize.getHeight(), maxWidth);
            }
            return new Size2D(contentSize.height, contentSize.width);
        }
        throw new RuntimeException("Unrecognised exception.");
    }

    protected Size2D arrangeRN(Canvas canvas, Range widthRange) {
        Size2D s = this.arrangeNN(canvas);
        if (widthRange.contains(s.getWidth())) {
            return s;
        }
        double ww = widthRange.constrain(s.getWidth());
        return this.arrangeFN(canvas, ww);
    }

    protected Size2D arrangeRR(Canvas canvas, Range widthRange, Range heightRange) {
        RectangleEdge position = this.getPosition();
        Paint paint = PaintUtility.createPaint(1, this.paintType, this.font);
        if (position == RectangleEdge.TOP || position == RectangleEdge.BOTTOM) {
            float maxWidth = (float)widthRange.getUpperBound();
            this.content = TextUtilities.createTextBlock(this.text, this.font, this.paintType, maxWidth, this.maximumLinesToDisplay, new G2TextMeasurer(paint));
            this.content.setLineAlignment(this.textAlignment);
            Size2D contentSize = this.content.calculateDimensions(canvas);
            if (this.expandToFitSpace) {
                return new Size2D(maxWidth, contentSize.getHeight());
            }
            return contentSize;
        }
        if (position == RectangleEdge.LEFT || position == RectangleEdge.RIGHT) {
            float maxWidth = (float)heightRange.getUpperBound();
            this.content = TextUtilities.createTextBlock(this.text, this.font, this.paintType, maxWidth, this.maximumLinesToDisplay, new G2TextMeasurer(paint));
            this.content.setLineAlignment(this.textAlignment);
            Size2D contentSize = this.content.calculateDimensions(canvas);
            if (this.expandToFitSpace) {
                return new Size2D(contentSize.getHeight(), maxWidth);
            }
            return new Size2D(contentSize.height, contentSize.width);
        }
        throw new RuntimeException("Unrecognised exception.");
    }

    public void draw(Canvas canvas, RectShape area) {
        this.draw(canvas, area, null);
    }

    public Object draw(Canvas canvas, RectShape area, Object params) {
        EntityBlockParams p;
        if (this.content == null) {
            return null;
        }
        area = this.trimMargin(area);
        this.drawBorder(canvas, area);
        if (this.text.equals("")) {
            return null;
        }
        TitleEntity entity = null;
        if (params instanceof EntityBlockParams && (p = (EntityBlockParams)params).getGenerateEntities()) {
            entity = new TitleEntity(area, this, this.toolTipText, this.urlText);
        }
        area = this.trimBorder(area);
        if (this.backgroundPaint != null) {
            area.fill(canvas, this.backgroundPaint);
        }
        area = this.trimPadding(area);
        RectangleEdge position = this.getPosition();
        if (position == RectangleEdge.TOP || position == RectangleEdge.BOTTOM) {
            this.drawHorizontal(canvas, area);
        } else if (position == RectangleEdge.LEFT || position == RectangleEdge.RIGHT) {
            this.drawVertical(canvas, area);
        }
        BlockResult result = new BlockResult();
        if (entity != null) {
            StandardEntityCollection sec = new StandardEntityCollection();
            sec.add(entity);
            result.setEntityCollection(sec);
        }
        return result;
    }

    protected void drawHorizontal(Canvas canvas, RectShape area) {
        RectShape titleArea = area.clone();
        TextBlockAnchor anchor = null;
        float x = 0.0f;
        HorizontalAlignment horizontalAlignment = this.getHorizontalAlignment();
        if (horizontalAlignment == HorizontalAlignment.LEFT) {
            x = titleArea.getX();
            anchor = TextBlockAnchor.TOP_LEFT;
        } else if (horizontalAlignment == HorizontalAlignment.RIGHT) {
            x = titleArea.getMaxX();
            anchor = TextBlockAnchor.TOP_RIGHT;
        } else if (horizontalAlignment == HorizontalAlignment.CENTER) {
            x = titleArea.getCenterX();
            anchor = TextBlockAnchor.TOP_CENTER;
        }
        float y = 0.0f;
        RectangleEdge position = this.getPosition();
        if (position == RectangleEdge.TOP) {
            y = titleArea.getY();
        } else if (position == RectangleEdge.BOTTOM) {
            y = titleArea.getMaxY();
            if (horizontalAlignment == HorizontalAlignment.LEFT) {
                anchor = TextBlockAnchor.BOTTOM_LEFT;
            } else if (horizontalAlignment == HorizontalAlignment.CENTER) {
                anchor = TextBlockAnchor.BOTTOM_CENTER;
            } else if (horizontalAlignment == HorizontalAlignment.RIGHT) {
                anchor = TextBlockAnchor.BOTTOM_RIGHT;
            }
        }
        this.content.draw(canvas, x, y, anchor);
    }

    protected void drawVertical(Canvas canvas, RectShape area) {
        RectShape titleArea = area.clone();
        TextBlockAnchor anchor = null;
        float y = 0.0f;
        VerticalAlignment verticalAlignment = this.getVerticalAlignment();
        if (verticalAlignment == VerticalAlignment.TOP) {
            y = titleArea.getY();
            anchor = TextBlockAnchor.TOP_RIGHT;
        } else if (verticalAlignment == VerticalAlignment.BOTTOM) {
            y = titleArea.getMaxY();
            anchor = TextBlockAnchor.TOP_LEFT;
        } else if (verticalAlignment == VerticalAlignment.CENTER) {
            y = titleArea.getCenterY();
            anchor = TextBlockAnchor.TOP_CENTER;
        }
        float x = 0.0f;
        RectangleEdge position = this.getPosition();
        if (position == RectangleEdge.LEFT) {
            x = titleArea.getX();
        } else if (position == RectangleEdge.RIGHT) {
            x = titleArea.getMaxX();
            if (verticalAlignment == VerticalAlignment.TOP) {
                anchor = TextBlockAnchor.BOTTOM_RIGHT;
            } else if (verticalAlignment == VerticalAlignment.CENTER) {
                anchor = TextBlockAnchor.BOTTOM_CENTER;
            } else if (verticalAlignment == VerticalAlignment.BOTTOM) {
                anchor = TextBlockAnchor.BOTTOM_LEFT;
            }
        }
        this.content.draw(canvas, x, y, anchor, x, y, -1.5707963267948966);
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 29 * result + (this.text != null ? this.text.hashCode() : 0);
        result = 29 * result + (this.font != null ? this.font.hashCode() : 0);
        result = 29 * result + (this.paintType != null ? this.paintType.hashCode() : 0);
        result = 29 * result + (this.backgroundPaint != null ? this.backgroundPaint.hashCode() : 0);
        return result;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

