/*
 * Decompiled with CFR 0.152.
 */
package org.afree.graphics.geom;

import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PointF;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Region;
import android.graphics.RegionIterator;
import org.afree.graphics.geom.RectShape;
import org.afree.graphics.geom.Shape;

public class Polygon
implements Shape {
    private Path mPath;
    private Region mRegion;
    private Path mClosedTempPath = new Path();
    private boolean mFirstPoint = true;

    public Polygon() {
        this.mPath = new Path();
        this.mRegion = new Region();
    }

    public Polygon(Polygon polygon) {
        this.mPath = new Path(polygon.mPath);
        this.mRegion = new Region(polygon.mRegion);
        this.mFirstPoint = polygon.mFirstPoint;
    }

    public Polygon(int[] xs, int[] ys, int vertexNum) {
        if (xs.length != vertexNum || ys.length != vertexNum) {
            throw new IllegalArgumentException("No match array length.");
        }
        this.mPath = new Path();
        this.mPath.moveTo((float)xs[0], (float)ys[0]);
        int i = 1;
        while (i < vertexNum) {
            this.mPath.lineTo((float)xs[i], (float)ys[i]);
            ++i;
        }
        RectF rect = new RectF();
        this.mPath.computeBounds(rect, false);
        this.mRegion = new Region();
        this.mFirstPoint = false;
        this.update();
    }

    public Polygon(float[] xs, float[] ys, int vertexNum) {
        if (xs.length != vertexNum || ys.length != vertexNum) {
            throw new IllegalArgumentException("No match array length.");
        }
        this.mPath = new Path();
        this.mPath.moveTo(xs[0], ys[0]);
        int i = 1;
        while (i < vertexNum) {
            this.mPath.lineTo(xs[i], ys[i]);
            ++i;
        }
        RectF rect = new RectF();
        this.mPath.computeBounds(rect, false);
        this.mRegion = new Region();
        this.mFirstPoint = false;
        this.update();
    }

    public Path getPath() {
        return this.mPath;
    }

    public void draw(Canvas canvas, Paint paint) {
        this.updateTempPath();
        paint.setStyle(Paint.Style.STROKE);
        canvas.drawPath(this.mClosedTempPath, paint);
    }

    public void fill(Canvas canvas, Paint paint) {
        this.updateTempPath();
        paint.setStyle(Paint.Style.FILL);
        canvas.drawPath(this.mClosedTempPath, paint);
    }

    public void fillAndStroke(Canvas canvas, Paint paint) {
        this.updateTempPath();
        paint.setStyle(Paint.Style.FILL_AND_STROKE);
        canvas.drawPath(this.mClosedTempPath, paint);
    }

    public void clip(Canvas canvas) {
        this.updateTempPath();
        canvas.clipPath(this.mClosedTempPath);
    }

    public boolean contains(RectShape rect) {
        Region tmpRegion = new Region();
        Region targetRegion = new Region((int)rect.getX(), (int)rect.getY(), (int)(rect.getWidth() + rect.getX()), (int)(rect.getHeight() + rect.getY()));
        tmpRegion.op(this.mRegion, targetRegion, Region.Op.INTERSECT);
        return !targetRegion.op(tmpRegion, Region.Op.XOR);
    }

    public boolean contains(float x, float y) {
        return this.mRegion.contains((int)x, (int)y);
    }

    public boolean contains(float x, float y, float width, float height) {
        Region tmpRegion = new Region();
        Region targetRegion = new Region((int)x, (int)y, (int)(width + x), (int)(height + y));
        tmpRegion.op(this.mRegion, targetRegion, Region.Op.INTERSECT);
        return !targetRegion.op(tmpRegion, Region.Op.XOR);
    }

    public boolean contains(PointF point) {
        return this.mRegion.contains((int)point.x, (int)point.y);
    }

    @Deprecated
    public RectShape getBounds() {
        return new RectShape(this.mRegion.getBounds());
    }

    public void getBounds(RectShape rect) {
        rect.setRect(this.mRegion.getBounds());
    }

    public boolean intersects(float x, float y, float width, float height) {
        if (this.mRegion.isEmpty()) {
            return false;
        }
        Rect rect = new Rect();
        RegionIterator iterator = new RegionIterator(this.mRegion);
        Region region = new Region(this.mRegion);
        if (iterator.next(rect)) {
            float tmph;
            float tmpy;
            float tmpw;
            float tmpx;
            if (x < width + x) {
                tmpx = x;
                tmpw = width;
            } else {
                tmpx = width + x;
                tmpw = Math.abs(width);
            }
            if (y < height + y) {
                tmpy = y;
                tmph = height;
            } else {
                tmpy = height + y;
                tmph = Math.abs(height);
            }
            return region.op((int)tmpx, (int)tmpy, (int)(tmpx + tmpw), (int)(tmpy + tmph), Region.Op.INTERSECT);
        }
        return false;
    }

    public boolean intersects(Rect rect) {
        return this.intersects(rect.left, rect.top, rect.right - rect.left, rect.bottom - rect.top);
    }

    public boolean intersects(RectShape rect) {
        return this.intersects(rect.getX(), rect.getY(), rect.getWidth(), rect.getHeight());
    }

    public void translate(float x, float y) {
        Matrix mat = new Matrix();
        mat.postTranslate(x, y);
        this.mPath.transform(mat);
        this.update();
    }

    public void addPoint(float x, float y) {
        if (this.mFirstPoint) {
            this.mPath.moveTo(x, y);
            this.mFirstPoint = false;
        } else {
            this.mPath.lineTo(x, y);
        }
        this.update();
    }

    public void reset() {
        this.mPath.reset();
        this.update();
    }

    public void update() {
        this.updateTempPath();
        RectF rect = new RectF();
        this.mPath.computeBounds(rect, false);
        this.mRegion = new Region((int)rect.left, (int)rect.top, (int)rect.right, (int)rect.bottom);
        this.mRegion.setPath(this.mClosedTempPath, this.mRegion);
    }

    private void updateTempPath() {
        this.mClosedTempPath.reset();
        this.mClosedTempPath.set(this.mPath);
        this.mClosedTempPath.close();
    }

    public Shape clone() {
        return new Polygon(this);
    }

    public boolean equals(Object o) {
        if (o instanceof Polygon) {
            Polygon polygon = (Polygon)o;
            Region region = new Region(this.mRegion);
            if (!region.op(polygon.mRegion, Region.Op.XOR)) {
                return true;
            }
        }
        return false;
    }
}

