/*
 * Decompiled with CFR 0.152.
 */
package org.afree.ui;

import org.afree.graphics.geom.RectShape;
import org.afree.ui.LengthAdjustmentType;
import org.afree.util.UnitType;

public class RectangleInsets {
    public static final RectangleInsets ZERO_INSETS = new RectangleInsets(UnitType.ABSOLUTE, 0.0, 0.0, 0.0, 0.0);
    private UnitType unitType;
    private double top;
    private double bottom;
    private double left;
    private double right;

    public RectangleInsets(double top, double left, double bottom, double right) {
        this(UnitType.ABSOLUTE, top, left, bottom, right);
    }

    public RectangleInsets(UnitType unitType, double top, double left, double bottom, double right) {
        if (unitType == null) {
            throw new IllegalArgumentException("Null 'unitType' argument.");
        }
        this.unitType = unitType;
        this.top = top;
        this.bottom = bottom;
        this.left = left;
        this.right = right;
    }

    public UnitType getUnitType() {
        return this.unitType;
    }

    public void trim(RectShape area) {
        double w = area.getWidth();
        double h = area.getHeight();
        double l = this.calculateLeftInset(w);
        double r = this.calculateRightInset(w);
        double t = this.calculateTopInset(h);
        double b = this.calculateBottomInset(h);
        area.setRect((double)area.getX() + l, (double)area.getY() + t, w - l - r, h - t - b);
    }

    public double calculateBottomInset(double height) {
        double result = this.bottom;
        if (this.unitType == UnitType.RELATIVE) {
            result = this.bottom * height;
        }
        return result;
    }

    public double calculateLeftInset(double width) {
        double result = this.left;
        if (this.unitType == UnitType.RELATIVE) {
            result = this.left * width;
        }
        return result;
    }

    public double calculateRightInset(double width) {
        double result = this.right;
        if (this.unitType == UnitType.RELATIVE) {
            result = this.right * width;
        }
        return result;
    }

    public double calculateTopInset(double height) {
        double result = this.top;
        if (this.unitType == UnitType.RELATIVE) {
            result = this.top * height;
        }
        return result;
    }

    public double getTop() {
        return this.top;
    }

    public double getBottom() {
        return this.bottom;
    }

    public double getLeft() {
        return this.left;
    }

    public double getRight() {
        return this.right;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof RectangleInsets)) {
            return false;
        }
        RectangleInsets that = (RectangleInsets)obj;
        if (that.unitType != this.unitType) {
            return false;
        }
        if (this.left != that.left) {
            return false;
        }
        if (this.right != that.right) {
            return false;
        }
        if (this.top != that.top) {
            return false;
        }
        return this.bottom == that.bottom;
    }

    public RectShape createInsetRectShape(RectShape base) {
        return this.createInsetRectShape(base, true, true);
    }

    public RectShape createInsetRectShape(RectShape base, boolean horizontal, boolean vertical) {
        if (base == null) {
            throw new IllegalArgumentException("Null 'base' argument.");
        }
        double topMargin = 0.0;
        double bottomMargin = 0.0;
        if (vertical) {
            topMargin = this.calculateTopMargin(base.getHeight());
            bottomMargin = this.calculateBottomMargin(base.getHeight());
        }
        double leftMargin = 0.0;
        double rightMargin = 0.0;
        if (horizontal) {
            leftMargin = this.calculateLeftMargin(base.getWidth());
            rightMargin = this.calculateRightMargin(base.getWidth());
        }
        return new RectShape((double)base.getX() + leftMargin, (double)base.getY() + topMargin, (double)base.getWidth() - leftMargin - rightMargin, (double)base.getHeight() - topMargin - bottomMargin);
    }

    public double calculateTopMargin(double height) {
        double result = this.top;
        if (this.unitType == UnitType.RELATIVE) {
            result = this.top * height;
        }
        return result;
    }

    public double calculateBottomMargin(double height) {
        double result = this.bottom;
        if (this.unitType == UnitType.RELATIVE) {
            result = this.bottom * height;
        }
        return result;
    }

    public double calculateLeftMargin(double width) {
        double result = this.left;
        if (this.unitType == UnitType.RELATIVE) {
            result = this.left * width;
        }
        return result;
    }

    public double calculateRightMargin(double width) {
        double result = this.right;
        if (this.unitType == UnitType.RELATIVE) {
            result = this.right * width;
        }
        return result;
    }

    public double trimWidth(double width) {
        return width - this.calculateLeftInset(width) - this.calculateRightInset(width);
    }

    public double extendWidth(double width) {
        return width + this.calculateLeftOutset(width) + this.calculateRightOutset(width);
    }

    public double trimHeight(double height) {
        return height - this.calculateTopInset(height) - this.calculateBottomInset(height);
    }

    public double extendHeight(double height) {
        return height + this.calculateTopOutset(height) + this.calculateBottomOutset(height);
    }

    public double calculateRightOutset(double width) {
        double result = this.right;
        if (this.unitType == UnitType.RELATIVE) {
            result = width / (1.0 - this.left - this.right) * this.right;
        }
        return result;
    }

    public double calculateLeftOutset(double width) {
        double result = this.left;
        if (this.unitType == UnitType.RELATIVE) {
            result = width / (1.0 - this.left - this.right) * this.left;
        }
        return result;
    }

    public double calculateBottomOutset(double height) {
        double result = this.bottom;
        if (this.unitType == UnitType.RELATIVE) {
            result = height / (1.0 - this.top - this.bottom) * this.bottom;
        }
        return result;
    }

    public double calculateTopOutset(double height) {
        double result = this.top;
        if (this.unitType == UnitType.RELATIVE) {
            result = height / (1.0 - this.top - this.bottom) * this.top;
        }
        return result;
    }

    public RectShape createOutsetRectangle(RectShape base, boolean horizontal, boolean vertical) {
        if (base == null) {
            throw new IllegalArgumentException("Null 'base' argument.");
        }
        double topMargin = 0.0;
        double bottomMargin = 0.0;
        if (vertical) {
            topMargin = this.calculateTopOutset(base.getHeight());
            bottomMargin = this.calculateBottomOutset(base.getHeight());
        }
        double leftMargin = 0.0;
        double rightMargin = 0.0;
        if (horizontal) {
            leftMargin = this.calculateLeftOutset(base.getWidth());
            rightMargin = this.calculateRightOutset(base.getWidth());
        }
        return new RectShape((double)base.getX() - leftMargin, (double)base.getY() - topMargin, (double)base.getWidth() + leftMargin + rightMargin, (double)base.getHeight() + topMargin + bottomMargin);
    }

    public RectShape createOutsetRectangle(RectShape base) {
        return this.createOutsetRectangle(base, true, true);
    }

    public RectShape createAdjustedRectShape(RectShape base, LengthAdjustmentType horizontal, LengthAdjustmentType vertical) {
        double topMargin;
        if (base == null) {
            throw new IllegalArgumentException("Null 'base' argument.");
        }
        double x = base.getX();
        double y = base.getY();
        double w = base.getWidth();
        double h = base.getHeight();
        if (horizontal == LengthAdjustmentType.EXPAND) {
            double leftOutset = this.calculateLeftOutset(w);
            x -= leftOutset;
            w = w + leftOutset + this.calculateRightOutset(w);
        } else if (horizontal == LengthAdjustmentType.CONTRACT) {
            double leftMargin = this.calculateLeftInset(w);
            x += leftMargin;
            w = w - leftMargin - this.calculateRightInset(w);
        }
        if (vertical == LengthAdjustmentType.EXPAND) {
            topMargin = this.calculateTopOutset(h);
            y -= topMargin;
            h = h + topMargin + this.calculateBottomOutset(h);
        } else if (vertical == LengthAdjustmentType.CONTRACT) {
            topMargin = this.calculateTopInset(h);
            y += topMargin;
            h = h - topMargin - this.calculateBottomInset(h);
        }
        return new RectShape(x, y, w, h);
    }
}

