/*
 * Decompiled with CFR 0.152.
 */
package org.afree.ui;

import android.graphics.LinearGradient;
import android.graphics.Shader;
import java.io.Serializable;
import org.afree.graphics.GradientColor;
import org.afree.graphics.geom.RectShape;
import org.afree.graphics.geom.Shape;
import org.afree.ui.GradientShaderFactory;
import org.afree.ui.GradientShaderType;

public class StandardGradientShaderFactory
implements GradientShaderFactory,
Cloneable,
Serializable {
    private static final long serialVersionUID = -8155025776964678320L;
    private GradientShaderType type;

    public StandardGradientShaderFactory() {
        this(GradientShaderType.VERTICAL);
    }

    public StandardGradientShaderFactory(GradientShaderType type) {
        this.type = type;
    }

    public LinearGradient create(GradientColor gradientPaint, Shape target) {
        RectShape bounds = new RectShape();
        target.getBounds(bounds);
        LinearGradient result = null;
        if (this.type.equals(GradientShaderType.VERTICAL)) {
            result = new LinearGradient(bounds.getCenterX(), bounds.getMinY(), bounds.getCenterX(), bounds.getMaxY(), gradientPaint.getColor1(), gradientPaint.getColor2(), Shader.TileMode.CLAMP);
        } else if (this.type.equals(GradientShaderType.HORIZONTAL)) {
            result = new LinearGradient(bounds.getMinX(), bounds.getCenterY(), bounds.getMaxX(), bounds.getCenterY(), gradientPaint.getColor1(), gradientPaint.getColor2(), Shader.TileMode.CLAMP);
        } else if (this.type.equals(GradientShaderType.CENTER_HORIZONTAL)) {
            result = new LinearGradient(bounds.getMinX(), bounds.getCenterY(), bounds.getMaxX(), bounds.getCenterY(), gradientPaint.getColor2(), gradientPaint.getColor1(), Shader.TileMode.MIRROR);
        } else if (this.type.equals(GradientShaderType.CENTER_VERTICAL)) {
            result = new LinearGradient(bounds.getCenterX(), bounds.getMinY(), bounds.getCenterX(), bounds.getCenterY(), gradientPaint.getColor2(), gradientPaint.getColor1(), Shader.TileMode.MIRROR);
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof StandardGradientShaderFactory)) {
            return false;
        }
        StandardGradientShaderFactory that = (StandardGradientShaderFactory)obj;
        return this.type == that.type;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public int hashCode() {
        return this.type != null ? this.type.hashCode() : 0;
    }
}

