package com.td;

import java.util.Calendar;
import java.util.Date;
import java.util.List;

import org.afree.chart.AFreeChart;
import org.afree.chart.ChartFactory;
import org.afree.chart.plot.PlotOrientation;
import org.afree.data.category.DefaultCategoryDataset;

import android.content.Context;
import android.content.Intent;
import android.content.res.Configuration;
import android.os.Bundle;
import android.view.View;
import android.view.View.OnClickListener;
import android.widget.Button;
import android.widget.HorizontalScrollView;
import android.widget.TextView;

import com.td.db.History;
import com.td.db.HistoryDao;
import com.td.db.Train;
import com.td.db.TrainDao;
import com.td.utility.BaseActivity;
import com.td.utility.DBCache;
import com.td.utility.DateUtil;
import com.td.utility.Debug;
import com.td.utility.EditPrefUtil;

public class HistoryActivity extends BaseActivity {
	public static final String PREF_HIS_YMD_POS = "HIS_YMD_POS";

	public static final String PREF_HIS_ST_HOUR = "HIS_ST_HOUR";
	public static final String PREF_HIS_ST_MINUTE = "HIS_ST_MINUTE";
	public static final String PREF_HIS_EN_HOUR = "HIS_EN_HOUR";
	public static final String PREF_HIS_EN_MINUTE = "HIS_EN_MINUTE";

	public static final String PREF_HIS_YMD = "HIS_YMD";

	public static final String PREF_HIS_DATA = "HIS_DATA";

	public static final int[] unit = { 10, 30, 60 };

	private EditPrefUtil pref = new EditPrefUtil(this);
	private TextView textView1;
    private HorizontalScrollView scrollView;
    private HistoryView historyView;
    
	private int prefYmdPos;

	private int prefStHour;
	private int prefStMinute;
	private int prefEnHour;
	private int prefEnMinute;

	private Date currentDate;
	
	private int scrollViewWidth = 0;
	private int prevSx;

	@Override
	public void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.history);
		
		try {
			Button button1 = (Button) findViewById(R.id.button11);
			button1.setOnClickListener(new OnClickListener() {
				public void onClick(View view) {
					Intent intent = new Intent(HistoryActivity.this,
							(Class<?>) HistoryListActivity.class);
					startActivityForResult(intent, 0);
				}
			});

			Button button2 = (Button) findViewById(R.id.button12);
			button2.setOnClickListener(new OnClickListener() {
				public void onClick(View view) {
					HistoryConfActivity.init(HistoryActivity.this);
					Intent intent = new Intent(HistoryActivity.this,
							(Class<?>) HistoryConfActivity.class);
					startActivityForResult(intent, 0);
				}
			});

			Button button3 = (Button) findViewById(R.id.button13);
			button3.setOnClickListener(new OnClickListener() {
				public void onClick(View view) {
					HistoryActivity.this.finish();
				}
			});

			textView1 = (TextView) findViewById(R.id.textView11);
			scrollView = (HorizontalScrollView) findViewById(R.id.scrollView11);
			historyView = (HistoryView) findViewById(R.id.historyView11);
			historyView.setHistoryActivity(this);
		} catch (Exception e) {
			Debug.d(this, null, e);
			showDialog(this, e);			
		}
	}

	@Override
	public void onWindowFocusChanged(boolean hasFocus) {
		int width = scrollView.getWidth();
		setScrollViewWidth(width);		
		
		super.onWindowFocusChanged(hasFocus);
	}

	// TODO
//	@Override
//    public void onConfigurationChanged(Configuration newConfig ) {
//		int width = scrollView.getWidth();
//		setScrollViewWidth(width);		
//		
//        super.onConfigurationChanged(newConfig);
//    }
        
	@Override
	protected void onStart() {
		super.onStart();

		try {
			Calendar cal = Calendar.getInstance();
			Date date = cal.getTime();

			int H = 3;
			
			prefEnHour = pref.getInt(PREF_HIS_EN_HOUR, date.getHours());
			prefEnMinute = pref.getInt(PREF_HIS_EN_MINUTE, date.getMinutes());
			cal = Calendar.getInstance();
			cal.set(Calendar.HOUR_OF_DAY, prefEnHour);
			cal.set(Calendar.MINUTE, prefEnMinute);
			date = cal.getTime();
			int h = date.getHours();
 			int hour = 0;
			int minute = 0;
			if (h >= H){
				cal.add(Calendar.HOUR, -H);
			
				Date startDate = cal.getTime();
	 			hour = startDate.getHours();
				minute = startDate.getMinutes();
			}
			prefStHour = pref.getInt(PREF_HIS_ST_HOUR, hour);
			prefStMinute = pref.getInt(PREF_HIS_ST_MINUTE, minute);

			int M = DateUtil.WEEK;
			prefYmdPos = pref.getInt(PREF_HIS_YMD_POS, M - 1);

			cal.add(Calendar.DATE, -(M - (prefYmdPos + 1)));
			currentDate = cal.getTime();

			pref.update();
			
			HistoryDao hisDao = HistoryDao.getInstance();
			TrainDao traDao = TrainDao.getInstance();
			DBCache<Train, Long> cache = new DBCache<Train, Long>(traDao);
			
			int ymd = DateUtil.getYmd(currentDate.getYear(),
					currentDate.getMonth(), currentDate.getDate());
			int from = DateUtil.getHm(prefStHour, prefStMinute);
			int to = DateUtil.getHm(prefEnHour, prefEnMinute);
			
			pref.put(PREF_HIS_YMD, ymd);
			pref.update();
			
			List<History> list = hisDao.search(this, ymd, from, to);

			DefaultCategoryDataset dataset = new DefaultCategoryDataset();
			for (History history : list) {
				long val = history.getNum();
				int hm = history.getHm();
				String text = DateUtil.formattedHm(hm);
				
				long id = history.getRouteId();
				Train train = cache.get(Long.valueOf(id));
				if (train != null){
					String route = train.getName();

					if (Debug.isDebug()){
						Debug.d(this, id + " " + route + " " + text + " " + val);
					}
					dataset.setValue(val, route, text);
				}
			}

			AFreeChart chart = ChartFactory.createLineChart(
					getString(R.string.history_tite),
					getString(R.string.time_title),
					getString(R.string.tpm_title),
					dataset, PlotOrientation.VERTICAL, true,
					false, false);
			historyView.setChart(chart);
			
			String text = DateUtil.formattedDate(ymd, from, to);
			textView1.setText(text);
			
		} catch (Exception e) {
			Debug.d(this, null, e);
			showDialog(this, e);			
		}
	}

	@Override
	protected void onStop() {
		super.onStop();
	}

	@Override
	protected void onActivityResult(int requestCode, int resultCode, Intent data) {
		super.onActivityResult(requestCode, resultCode, data);
		
		switch (resultCode){
		case RESULT_OK:
			// ݒ肪ύXꂽ̂ŁAlǂݒ
			pref.remove(PREF_HIS_DATA);
			break;
		case RESULT_CANCELED:
			break;
		}
	}

	public void setScrollViewWidth(int scrollViewWidth) {
		if (scrollViewWidth <= 0){
			return;
		}
		this.scrollViewWidth = scrollViewWidth;
		scrollView.requestLayout();
	}

	public int getScrollViewWidth() {
		return scrollViewWidth;
	}

	public static void init(Context context) {
		EditPrefUtil pref = new EditPrefUtil(context);

		pref.remove(PREF_HIS_YMD_POS);

		pref.remove(PREF_HIS_ST_HOUR);
		pref.remove(PREF_HIS_ST_MINUTE);
		pref.remove(PREF_HIS_EN_HOUR);
		pref.remove(PREF_HIS_EN_MINUTE);

		pref.remove(PREF_HIS_DATA);
		
		pref.update();
	}
	
	public void preMagnification(){
		prevSx = scrollView.getScrollX();
	}
	
	public void magnification(float prefDw, float dw){
		float ddw = dw / prefDw;
		float prevCx = prevSx + scrollViewWidth / 2;
		// float cx = sx * ddw + scrollViewWidth / 2;
		// prevCx - cx = (1 - ddw) * sx;
		// cx = prevCx - (1 - ddw) * sx;
		float sx = prevCx - (1 - ddw) * prevSx - scrollViewWidth / 2;
		
		scrollView.scrollTo((int)sx, 0);
	}
}
