package com.td;

import java.util.List;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ArrayAdapter;
import android.widget.TextView;

import com.td.db.History;
import com.td.utility.DateUtil;

public class HistoryListViewArrayAdapter extends ArrayAdapter<History> {
    private LayoutInflater inflater;

    public HistoryListViewArrayAdapter(Context context, int resourceId, List<History> items) {
        super(context, resourceId, items);
        this.inflater = (LayoutInflater) context.getSystemService(Context.LAYOUT_INFLATER_SERVICE);
    }

    @Override
    public View getView(int position, View convertView, ViewGroup parent){
        View view = convertView;  
        if(view == null){  
            view = inflater.inflate(R.layout.history_list_item_1, null);  
        }      

        History item = getItem(position);
        
        TextView textView1 = (TextView)view.findViewById(R.id.text911);  
        TextView textView2 = (TextView)view.findViewById(R.id.text912);  

        textView1.setText(DateUtil.formattedHm(item.getHm()));  
        textView2.setText(String.valueOf(item.getNum()));  
        
        return view;
    }

}
