package com.td.db;

import android.content.Context;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;

public class SQLiteOpenHelperImpl extends SQLiteOpenHelper {
	private static final String DATABASE_NAME = "history.db";
	private static final int DATABASE_VERSION = 1;
	
	public SQLiteOpenHelperImpl(Context context) {
		super(context, DATABASE_NAME, null, DATABASE_VERSION);
	}

	@Override
	public void onCreate(SQLiteDatabase db) {
		db.execSQL(
				"CREATE TABLE HISTORY ("
				+ android.provider.BaseColumns._ID + " INTEGER PRIMARY KEY AUTOINCREMENT,"
				+ "ROUTE_ID INTEGER,"
				+ "YMD INTEGER,"
				+ "HM INTEGER,"
				+ "WEEK INTEGER,"
				+ "PERIOD INTEGER,"
				+ "NUM INTEGER,"
				+ "STATUS INTEGER"
				+ ");");
	}

	@Override
	public void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
		db.execSQL("DROP TABLE IF EXISTS HISTORY");
	}

}
