/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.conversion;

import com.google.appengine.repackaged.com.google.common.base.Objects;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.base.StringUtil;

public final class ConversionOptions {
    private Integer imageWidth = 800;
    private Integer firstPage = 1;
    private Integer lastPage = -1;
    private String ocrInputLanguage;

    private ConversionOptions() {
    }

    public ConversionOptions imageWidth(int imageWidth) {
        Preconditions.checkArgument(imageWidth > 0, "image width must be > 0, got " + imageWidth);
        this.imageWidth = imageWidth;
        return this;
    }

    public ConversionOptions firstPage(int firstPage) {
        Preconditions.checkArgument(firstPage > 0, "first page must be > 0, got " + firstPage);
        this.firstPage = firstPage;
        return this;
    }

    public ConversionOptions lastPage(int lastPage) {
        Preconditions.checkArgument(lastPage > 0, "last page must be > 0, got " + lastPage);
        this.lastPage = lastPage;
        return this;
    }

    public ConversionOptions ocrInputLanguage(String ocrInputLanguage) {
        Preconditions.checkArgument(!StringUtil.isEmptyOrWhitespace(ocrInputLanguage), "OCR input language should not be null, empty or comprises only whitespace characters");
        this.ocrInputLanguage = ocrInputLanguage.toLowerCase();
        return this;
    }

    Integer getImageWidth() {
        return this.imageWidth;
    }

    Integer getFirstPage() {
        return this.firstPage;
    }

    Integer getLastPage() {
        return this.lastPage;
    }

    String getOcrInputLanguage() {
        return this.ocrInputLanguage;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConversionOptions other = (ConversionOptions)o;
        return Objects.equal(this.imageWidth, other.getImageWidth()) && Objects.equal(this.firstPage, other.getFirstPage()) && Objects.equal(this.lastPage, other.getLastPage()) && Objects.equal(this.ocrInputLanguage, other.getOcrInputLanguage());
    }

    public int hashCode() {
        return Objects.hashCode(this.imageWidth, this.firstPage, this.lastPage, this.ocrInputLanguage);
    }

    public static final class Builder {
        private Builder() {
        }

        public static ConversionOptions withDefaults() {
            return new ConversionOptions();
        }

        public static ConversionOptions withImageWidth(int imageWidth) {
            return Builder.withDefaults().imageWidth(imageWidth);
        }

        public static ConversionOptions withFirstPage(int firstPage) {
            return Builder.withDefaults().firstPage(firstPage);
        }

        public static ConversionOptions withLastPage(int lastPage) {
            return Builder.withDefaults().lastPage(lastPage);
        }

        public static ConversionOptions withOcrInputLanguage(String ocrInputLanguage) {
            return Builder.withDefaults().ocrInputLanguage(ocrInputLanguage);
        }
    }
}

