/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.base;

import com.google.appengine.repackaged.com.google.common.annotations.GoogleInternal;
import com.google.appengine.repackaged.com.google.common.annotations.GwtCompatible;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import javax.annotation.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@GoogleInternal
@GwtCompatible
public final class Holder<T> {
    private T reference;

    public static <T> Holder<T> unset() {
        return new Holder<Object>(null);
    }

    public static <T> Holder<T> of(T initialReference) {
        return new Holder<T>(Preconditions.checkNotNull(initialReference));
    }

    private Holder(@Nullable T reference) {
        this.reference = reference;
    }

    public T get() {
        Preconditions.checkState(this.isSet());
        return this.reference;
    }

    public boolean isSet() {
        return this.reference != null;
    }

    public void set(T reference) {
        this.reference = Preconditions.checkNotNull(reference);
    }

    public void clear() {
        this.reference = null;
    }

    public String toString() {
        return this.isSet() ? "Holder.of(" + this.reference + ")" : "Holder.unset()";
    }
}

