/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.collect;

import com.google.appengine.repackaged.com.google.common.annotations.Beta;
import com.google.appengine.repackaged.com.google.common.base.FinalizableReferenceQueue;
import com.google.appengine.repackaged.com.google.common.base.FinalizableWeakReference;
import com.google.appengine.repackaged.com.google.common.base.Function;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.collect.Interner;
import com.google.appengine.repackaged.com.google.common.collect.MapMaker;
import java.util.concurrent.ConcurrentMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Beta
public final class Interners {
    private Interners() {
    }

    public static <E> Interner<E> newStrongInterner() {
        final ConcurrentMap map = new MapMaker().makeMap();
        return new Interner<E>(){

            @Override
            public E intern(E sample) {
                Object canonical = map.putIfAbsent(Preconditions.checkNotNull(sample), sample);
                return canonical == null ? sample : canonical;
            }
        };
    }

    public static <E> Interner<E> newWeakInterner() {
        return new WeakInterner();
    }

    public static <E> Function<E, E> asFunction(Interner<E> interner) {
        return new InternerFunction<E>(Preconditions.checkNotNull(interner));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class InternerFunction<E>
    implements Function<E, E> {
        private final Interner<E> interner;

        public InternerFunction(Interner<E> interner) {
            this.interner = interner;
        }

        @Override
        public E apply(E input) {
            return this.interner.intern(input);
        }

        public int hashCode() {
            return this.interner.hashCode();
        }

        @Override
        public boolean equals(Object other) {
            if (other instanceof InternerFunction) {
                InternerFunction that = (InternerFunction)other;
                return this.interner.equals(that.interner);
            }
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class WeakInterner<E>
    implements Interner<E> {
        private final ConcurrentMap<InternReference, InternReference> map = new MapMaker().makeMap();
        private static final FinalizableReferenceQueue frq = new FinalizableReferenceQueue();

        private WeakInterner() {
        }

        @Override
        public E intern(final E sample) {
            InternReference sneakyRef;
            Object canonical;
            Object canonical2;
            final int hashCode = sample.hashCode();
            Object fakeReference = new Object(){

                public int hashCode() {
                    return hashCode;
                }

                public boolean equals(Object object) {
                    if (object.hashCode() != hashCode) {
                        return false;
                    }
                    InternReference that = (InternReference)object;
                    return sample.equals(that.get());
                }
            };
            InternReference existingRef = (InternReference)this.map.get(fakeReference);
            if (existingRef != null && (canonical2 = existingRef.get()) != null) {
                return canonical2;
            }
            InternReference newRef = new InternReference(sample, hashCode);
            do {
                if ((sneakyRef = this.map.putIfAbsent(newRef, newRef)) != null) continue;
                return sample;
            } while ((canonical = sneakyRef.get()) == null);
            return canonical;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class InternReference
        extends FinalizableWeakReference<E> {
            final int hashCode;

            InternReference(E key, int hash) {
                super(key, frq);
                this.hashCode = hash;
            }

            @Override
            public void finalizeReferent() {
                WeakInterner.this.map.remove(this);
            }

            @Override
            public E get() {
                Object referent = super.get();
                if (referent == null) {
                    this.finalizeReferent();
                }
                return referent;
            }

            public int hashCode() {
                return this.hashCode;
            }

            public boolean equals(Object object) {
                if (object == this) {
                    return true;
                }
                if (object instanceof InternReference) {
                    InternReference that = (InternReference)object;
                    if (that.hashCode != this.hashCode) {
                        return false;
                    }
                    Object referent = super.get();
                    return referent != null && referent.equals(that.get());
                }
                return object.equals(this);
            }
        }
    }
}

