/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.admin;

import com.google.appengine.tools.admin.AppAdminFactory;
import com.google.appengine.tools.admin.JspCompilationException;
import com.google.appengine.tools.admin.OutputPump;
import com.google.appengine.tools.admin.UpdateListener;
import com.google.appengine.tools.admin.UpdateProgressEvent;
import com.google.appengine.tools.admin.Utility;
import com.google.appengine.tools.info.SdkImplInfo;
import com.google.appengine.tools.info.SdkInfo;
import com.google.appengine.tools.util.ApiVersionFinder;
import com.google.appengine.tools.util.FileIterator;
import com.google.appengine.tools.util.JarSplitter;
import com.google.apphosting.utils.config.AppEngineConfigException;
import com.google.apphosting.utils.config.AppEngineWebXml;
import com.google.apphosting.utils.config.AppEngineWebXmlReader;
import com.google.apphosting.utils.config.AppYaml;
import com.google.apphosting.utils.config.BackendsXml;
import com.google.apphosting.utils.config.BackendsXmlReader;
import com.google.apphosting.utils.config.BackendsYamlReader;
import com.google.apphosting.utils.config.CronXml;
import com.google.apphosting.utils.config.CronXmlReader;
import com.google.apphosting.utils.config.CronYamlReader;
import com.google.apphosting.utils.config.DosXml;
import com.google.apphosting.utils.config.DosXmlReader;
import com.google.apphosting.utils.config.DosYamlReader;
import com.google.apphosting.utils.config.GenerationDirectory;
import com.google.apphosting.utils.config.IndexesXml;
import com.google.apphosting.utils.config.IndexesXmlReader;
import com.google.apphosting.utils.config.QueueXml;
import com.google.apphosting.utils.config.QueueXmlReader;
import com.google.apphosting.utils.config.QueueYamlReader;
import com.google.apphosting.utils.config.WebXml;
import com.google.apphosting.utils.config.WebXmlReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URL;
import java.util.Arrays;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.SchemaFactory;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Application {
    private static Pattern JSP_REGEX = Pattern.compile(".*\\.jspx?");
    private static File ln = Utility.findLink();
    private static File sdkDocsDir;
    private static final String STAGEDIR_PREFIX = "appcfg";
    private static final Logger logger;
    private AppEngineWebXml appEngineWebXml;
    private WebXml webXml;
    private CronXml cronXml;
    private DosXml dosXml;
    private QueueXml queueXml;
    private IndexesXml indexesXml;
    private BackendsXml backendsXml;
    private File baseDir;
    private File stageDir;
    private String apiVersion;
    private UpdateListener listener;
    private PrintWriter detailsWriter;
    private int updateProgress = 0;
    private int progressAmount = 0;
    private static final String JSPC_MAIN = "com.google.appengine.tools.development.LocalJspC";
    private static final Pattern SKIP_FILES;

    private static synchronized File getSdkDocsDir() {
        if (null == sdkDocsDir) {
            sdkDocsDir = new File(SdkInfo.getSdkRoot(), "docs");
        }
        return sdkDocsDir;
    }

    protected Application() {
    }

    private Application(String explodedPath) {
        File webinf;
        this.baseDir = new File(explodedPath);
        explodedPath = this.baseDir.getPath();
        if (File.separatorChar == '\\') {
            explodedPath = explodedPath.replace('\\', '/');
        }
        if (!(webinf = new File(this.baseDir, "WEB-INF")).getName().equals("WEB-INF")) {
            throw new AppEngineConfigException("WEB-INF directory must be capitalized.");
        }
        String webinfPath = webinf.getPath();
        AppEngineWebXmlReader aewebReader = new AppEngineWebXmlReader(explodedPath);
        WebXmlReader webXmlReader = new WebXmlReader(explodedPath);
        AppYaml.convert(webinf, aewebReader.getFilename(), webXmlReader.getFilename());
        Application.validateXml(aewebReader.getFilename(), new File(Application.getSdkDocsDir(), "appengine-web.xsd"));
        this.appEngineWebXml = aewebReader.readAppEngineWebXml();
        this.appEngineWebXml.setSourcePrefix(explodedPath);
        this.webXml = webXmlReader.readWebXml();
        this.webXml.validate();
        CronXmlReader cronReader = new CronXmlReader(explodedPath);
        Application.validateXml(cronReader.getFilename(), new File(Application.getSdkDocsDir(), "cron.xsd"));
        this.cronXml = cronReader.readCronXml();
        if (this.cronXml == null) {
            CronYamlReader cronYaml = new CronYamlReader(webinfPath);
            this.cronXml = cronYaml.parse();
        }
        QueueXmlReader queueReader = new QueueXmlReader(explodedPath);
        Application.validateXml(queueReader.getFilename(), new File(Application.getSdkDocsDir(), "queue.xsd"));
        this.queueXml = queueReader.readQueueXml();
        if (this.queueXml == null) {
            QueueYamlReader queueYaml = new QueueYamlReader(webinfPath);
            this.queueXml = queueYaml.parse();
        }
        DosXmlReader dosReader = new DosXmlReader(explodedPath);
        Application.validateXml(dosReader.getFilename(), new File(Application.getSdkDocsDir(), "dos.xsd"));
        this.dosXml = dosReader.readDosXml();
        if (this.dosXml == null) {
            DosYamlReader dosYaml = new DosYamlReader(webinfPath);
            this.dosXml = dosYaml.parse();
        }
        IndexesXmlReader indexReader = new IndexesXmlReader(explodedPath);
        Application.validateXml(indexReader.getFilename(), new File(Application.getSdkDocsDir(), "datastore-indexes.xsd"));
        this.indexesXml = indexReader.readIndexesXml();
        BackendsXmlReader backendsReader = new BackendsXmlReader(explodedPath);
        Application.validateXml(backendsReader.getFilename(), new File(Application.getSdkDocsDir(), "backends.xsd"));
        this.backendsXml = backendsReader.readBackendsXml();
        if (this.backendsXml == null) {
            BackendsYamlReader backendsYaml = new BackendsYamlReader(webinfPath);
            this.backendsXml = backendsYaml.parse();
        }
    }

    public static Application readApplication(String path) throws IOException {
        return new Application(path);
    }

    public String getAppId() {
        return this.appEngineWebXml.getAppId();
    }

    public String getVersion() {
        return this.appEngineWebXml.getMajorVersionId();
    }

    public AppEngineWebXml getAppEngineWebXml() {
        return this.appEngineWebXml;
    }

    public CronXml getCronXml() {
        return this.cronXml;
    }

    public QueueXml getQueueXml() {
        return this.queueXml;
    }

    public DosXml getDosXml() {
        return this.dosXml;
    }

    public IndexesXml getIndexesXml() {
        return this.indexesXml;
    }

    public WebXml getWebXml() {
        return this.webXml;
    }

    public BackendsXml getBackendsXml() {
        return this.backendsXml;
    }

    String getApiVersion() {
        if (this.apiVersion == null) {
            throw new IllegalStateException("Must call createStagingDirectory first.");
        }
        return this.apiVersion;
    }

    public String getPath() {
        return this.baseDir.getAbsolutePath();
    }

    public File getStagingDir() {
        return this.stageDir;
    }

    void resetProgress() {
        this.updateProgress = 0;
        this.progressAmount = 0;
    }

    File createStagingDirectory(AppAdminFactory.ApplicationProcessingOptions opts) throws IOException {
        if (this.stageDir != null) {
            return this.stageDir;
        }
        int i = 0;
        while (this.stageDir == null && i++ < 3) {
            try {
                this.stageDir = File.createTempFile(STAGEDIR_PREFIX, null);
            }
            catch (IOException ex) {
                continue;
            }
            this.stageDir.delete();
            if (this.stageDir.mkdir()) continue;
            this.stageDir = null;
        }
        if (i == 3) {
            throw new IOException("Couldn't create a temporary directory in 3 tries.");
        }
        this.statusUpdate("Created staging directory at: '" + this.stageDir.getPath() + "'", 20);
        File staticDir = new File(this.stageDir, "__static__");
        staticDir.mkdir();
        this.copyOrLink(this.baseDir, this.stageDir, staticDir, false, opts);
        if (opts.isCompileJspsSet()) {
            this.compileJsps(this.stageDir, opts);
        }
        this.apiVersion = Application.findApiVersion(this.stageDir, true);
        if (opts.isSplitJarsSet()) {
            Application.splitJars(new File(new File(this.stageDir, "WEB-INF"), "lib"), opts.getMaxJarSize(), opts.getJarSplittingExcludes());
        }
        Application.checkFileSizes(this.stageDir, 10000000);
        return this.stageDir;
    }

    private static String findApiVersion(File baseDir, boolean deleteApiJars) {
        ApiVersionFinder finder = new ApiVersionFinder();
        String foundApiVersion = null;
        File webInf = new File(baseDir, "WEB-INF");
        File libDir = new File(webInf, "lib");
        for (File file : new FileIterator(libDir)) {
            if (!file.getPath().endsWith(".jar")) continue;
            try {
                String apiVersion = finder.findApiVersion(file);
                if (apiVersion == null) continue;
                if (foundApiVersion == null) {
                    foundApiVersion = apiVersion;
                } else if (!foundApiVersion.equals(apiVersion)) {
                    logger.warning("Warning: found duplicate API version: " + foundApiVersion + ", using " + apiVersion);
                }
                if (!deleteApiJars) continue;
                file.delete();
            }
            catch (IOException ex) {
                logger.log(Level.WARNING, "Could not identify API version in " + file, ex);
            }
        }
        if (foundApiVersion == null) {
            foundApiVersion = "none";
        }
        return foundApiVersion;
    }

    private static void validateXml(String xmlFilename, File schema) {
        File xml = new File(xmlFilename);
        if (!xml.exists()) {
            return;
        }
        try {
            SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            try {
                factory.newSchema(schema).newValidator().validate(new StreamSource(new FileInputStream(xml)));
            }
            catch (SAXException ex) {
                throw new AppEngineConfigException("XML error validating " + xml.getPath() + " against " + schema.getPath(), ex);
            }
        }
        catch (IOException ex) {
            throw new AppEngineConfigException("IO error validating " + xml.getPath() + " against " + schema.getPath(), ex);
        }
    }

    private void compileJsps(File stage, AppAdminFactory.ApplicationProcessingOptions opts) throws IOException {
        this.statusUpdate("Scanning for jsp files.");
        if (Application.matchingFileExists(new File(stage.getPath()), JSP_REGEX)) {
            this.statusUpdate("Compiling jsp files.");
            File webInf = new File(stage, "WEB-INF");
            for (File file : SdkImplInfo.getUserJspLibFiles()) {
                this.copyOrLinkFile(file, new File(new File(webInf, "lib"), file.getName()));
            }
            for (File file : SdkImplInfo.getSharedJspLibFiles()) {
                this.copyOrLinkFile(file, new File(new File(webInf, "lib"), file.getName()));
            }
            File classes = new File(webInf, "classes");
            File generatedWebXml = new File(webInf, "generated_web.xml");
            String classpath = this.getJspClasspath(classes);
            String javaCmd = opts.getJavaExecutable().getPath();
            String[] args = new String[]{javaCmd, "-classpath", classpath, JSPC_MAIN, "-uriroot", stage.getPath(), "-p", "org.apache.jsp", "-l", "-v", "-webinc", generatedWebXml.getPath(), "-d", classes.getPath(), "-compile", "-javaEncoding", opts.getCompileEncoding()};
            Process jspc = this.startProcess(args);
            int status = 1;
            try {
                status = jspc.waitFor();
            }
            catch (InterruptedException ex) {
                // empty catch block
            }
            if (status != 0) {
                this.detailsWriter.println("Error while executing: " + this.formatCommand(Arrays.asList(args)));
                throw new JspCompilationException("Failed to compile jsp files.", JspCompilationException.Source.JASPER);
            }
            this.webXml = new WebXmlReader(stage.getPath()).readWebXml();
        }
    }

    private String getJspClasspath(File classDir) {
        StringBuilder classpath = new StringBuilder();
        for (URL uRL : SdkImplInfo.getImplLibs()) {
            classpath.append(uRL.getPath());
            classpath.append(File.pathSeparatorChar);
        }
        for (File file : SdkInfo.getSharedLibFiles()) {
            classpath.append(file.getPath());
            classpath.append(File.pathSeparatorChar);
        }
        classpath.append(classDir.getPath());
        classpath.append(File.pathSeparatorChar);
        for (File file : new FileIterator(new File(classDir.getParentFile(), "lib"))) {
            String filename = file.getPath().toLowerCase();
            if (!filename.endsWith(".jar") && !filename.endsWith(".zip")) continue;
            classpath.append(file.getPath());
            classpath.append(File.pathSeparatorChar);
        }
        return classpath.toString();
    }

    private Process startProcess(String ... args) throws IOException {
        ProcessBuilder builder = new ProcessBuilder(args);
        Process proc = builder.redirectErrorStream(true).start();
        logger.fine(this.formatCommand(builder.command()));
        new Thread(new OutputPump(proc.getInputStream(), this.detailsWriter)).start();
        return proc;
    }

    private String formatCommand(Iterable<String> args) {
        StringBuilder command = new StringBuilder();
        for (String chunk : args) {
            command.append(chunk);
            command.append(" ");
        }
        return command.toString();
    }

    private static boolean matchingFileExists(File dir, Pattern regex) {
        for (File file : dir.listFiles()) {
            if (!(file.isDirectory() ? Application.matchingFileExists(file, regex) : regex.matcher(file.getName()).matches())) continue;
            return true;
        }
        return false;
    }

    private static void checkFileSizes(File dir, int max) {
        for (File file : dir.listFiles()) {
            if (file.isDirectory()) {
                Application.checkFileSizes(file, max);
                continue;
            }
            if (file.length() <= (long)max) continue;
            String message = file.getName().toLowerCase().endsWith(".jar") ? "Found a jar file too large to upload: \"" + file.getPath() + "\".  Consider using --enable_jar_splitting." : "Found a file too large to upload: \"" + file.getPath() + "\".  Must be under " + max + " bytes.";
            throw new IllegalStateException(message);
        }
    }

    private static void splitJars(File dir, int max, Set<String> excludes) throws IOException {
        String[] children = dir.list();
        if (children == null) {
            return;
        }
        for (String name : children) {
            File subfile = new File(dir, name);
            if (subfile.isDirectory()) {
                Application.splitJars(subfile, max, excludes);
                continue;
            }
            if (!name.endsWith(".jar") || subfile.length() <= (long)max) continue;
            new JarSplitter(subfile, dir, max, false, 4, excludes).run();
            subfile.delete();
        }
    }

    private void copyOrLink(File sourceDir, File resDir, File staticDir, boolean forceResource, AppAdminFactory.ApplicationProcessingOptions opts) throws FileNotFoundException, IOException {
        for (String name : sourceDir.list()) {
            File file = new File(sourceDir, name);
            String path = file.getPath();
            if (File.separatorChar == '\\') {
                path = path.replace('\\', '/');
            }
            if (file.getName().startsWith(".") || file.equals(GenerationDirectory.getGenerationDirectory(this.baseDir))) continue;
            if (file.isDirectory()) {
                if (file.getName().equals("WEB-INF")) {
                    this.copyOrLink(file, new File(resDir, name), new File(staticDir, name), true, opts);
                    continue;
                }
                this.copyOrLink(file, new File(resDir, name), new File(staticDir, name), forceResource, opts);
                continue;
            }
            if (SKIP_FILES.matcher(path).matches()) continue;
            if (forceResource || this.appEngineWebXml.includesResource(path) || opts.isCompileJspsSet() && name.toLowerCase().endsWith(".jsp")) {
                this.copyOrLinkFile(file, new File(resDir, name));
            }
            if (forceResource || !this.appEngineWebXml.includesStatic(path)) continue;
            this.copyOrLinkFile(file, new File(staticDir, name));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyOrLinkFile(File source, File dest) throws FileNotFoundException, IOException {
        dest.getParentFile().mkdirs();
        if (ln != null && !source.getName().endsWith("web.xml")) {
            Process link = this.startProcess(ln.getAbsolutePath(), "-s", source.getAbsolutePath(), dest.getAbsolutePath());
            try {
                int stat = link.waitFor();
                if (stat == 0) {
                    return;
                }
                System.err.println(ln.getAbsolutePath() + " returned status " + stat + ", copying instead...");
            }
            catch (InterruptedException ex) {
                System.err.println(ln.getAbsolutePath() + " was interrupted, copying instead...");
            }
            if (dest.delete()) {
                System.err.println("ln failed but symlink was created, removed: " + dest.getAbsolutePath());
            }
        }
        byte[] buffer = new byte[1024];
        FileInputStream inStream = new FileInputStream(source);
        FileOutputStream outStream = new FileOutputStream(dest);
        try {
            int readlen = inStream.read(buffer);
            while (readlen > 0) {
                outStream.write(buffer, 0, readlen);
                readlen = inStream.read(buffer);
            }
        }
        finally {
            try {
                inStream.close();
            }
            catch (IOException ex) {}
            try {
                outStream.close();
            }
            catch (IOException ex) {}
        }
    }

    public void cleanStagingDirectory() {
        if (this.stageDir != null) {
            Application.recursiveDelete(this.stageDir);
        }
    }

    public static void recursiveDelete(File dead) {
        String[] files = dead.list();
        if (files != null) {
            for (String name : files) {
                Application.recursiveDelete(new File(dead, name));
            }
        }
        dead.delete();
    }

    void setListener(UpdateListener l) {
        this.listener = l;
    }

    void setDetailsWriter(PrintWriter detailsWriter) {
        this.detailsWriter = detailsWriter;
    }

    public void statusUpdate(String message, int amount) {
        this.updateProgress += this.progressAmount;
        if (this.updateProgress > 99) {
            this.updateProgress = 99;
        }
        this.progressAmount = amount;
        if (this.listener != null) {
            this.listener.onProgress(new UpdateProgressEvent(Thread.currentThread(), message, this.updateProgress));
        }
    }

    public void statusUpdate(String message) {
        int amount = this.progressAmount / 4;
        this.updateProgress += amount;
        if (this.updateProgress > 99) {
            this.updateProgress = 99;
        }
        this.progressAmount -= amount;
        if (this.listener != null) {
            this.listener.onProgress(new UpdateProgressEvent(Thread.currentThread(), message, this.updateProgress));
        }
    }

    static {
        logger = Logger.getLogger(Application.class.getName());
        SKIP_FILES = Pattern.compile("^(.*/)?((#.*#)|(.*~)|(.*/RCS/.*)|)$");
    }
}

