/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.utils.glob;

import com.google.apphosting.utils.glob.BranchGlob;
import com.google.apphosting.utils.glob.Glob;
import com.google.apphosting.utils.glob.LeafGlob;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GlobFactory {
    public static Glob createGlob(String pattern) {
        return new LeafGlob(pattern);
    }

    public static Glob createGlob(String pattern, String propertyName, Object value) {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put(propertyName, value);
        return GlobFactory.createGlob(pattern, properties);
    }

    public static Glob createGlob(String pattern, Map<String, Object> properties) {
        return new LeafGlob(pattern, properties);
    }

    public static Glob createChildGlob(String pattern, Glob ... children) {
        BranchGlob parent = new BranchGlob(pattern);
        for (Glob child : children) {
            parent.addChild(child);
        }
        return parent;
    }

    public static Glob createChildGlob(String pattern, Glob child) {
        BranchGlob parent = new BranchGlob(pattern);
        parent.addChild(child);
        return parent;
    }

    public static Glob convertToBranch(Glob leafGlob) {
        return GlobFactory.createChildGlob(leafGlob.getPattern(), leafGlob);
    }
}

