%define name mecab-ipadic
%define prefix /usr
%define config --with-charset=utf8
%define version 2.7.0.20070801
%define release tritonn.1.0.12a
%define file_suffix 2.7.0-20070801
%define mecab-version 0.98

Name:      %{name}
Version:   %{version}
Release:   %{release}
Group:     Application/Text
Summary:   IPA dictionary for MeCab
License:   GPL, LGPL, Modified BSD License
URL:       http://mecab.sourceforge.net/
Source:    %{name}-%{file_suffix}.tar.gz
Packager:  Tritonn Project <http://qwik.jp/tritonn/>
BuildRoot: /tmp/%{name}-%{version}-root
Requires:  mecab >= 0.98

%description
MeCab IPA is a dictionary for MeCab using CRF estimation
based on IPA corpus. This dictionary is for UTF-8 use.

%prep
%setup -q -n %{name}-%{file_suffix}

%build
CFLAGS="-g -O3" CXXFLAGS="-g -O3" \
./configure --prefix=%{prefix} %{config}
make

%install
[ -d $RPM_BUILD_ROOT ] && rm -fr $RPM_BUILD_ROOT
make -e prefix=${RPM_BUILD_ROOT}%{prefix} DESTDIR=${RPM_BUILD_ROOT} install
cp *.def ${RPM_BUILD_ROOT}%{prefix}/lib/mecab/dic/ipadic/
cp *.csv ${RPM_BUILD_ROOT}%{prefix}/lib/mecab/dic/ipadic/

%clean
[ -d $RPM_BUILD_ROOT ] && rm -fr $RPM_BUILD_ROOT

%files
%defattr(-,root,root)
%{prefix}/lib/mecab/dic/ipadic/char.bin
%{prefix}/lib/mecab/dic/ipadic/dicrc
%{prefix}/lib/mecab/dic/ipadic/left-id.def
%{prefix}/lib/mecab/dic/ipadic/matrix.bin
%{prefix}/lib/mecab/dic/ipadic/pos-id.def
%{prefix}/lib/mecab/dic/ipadic/rewrite.def
%{prefix}/lib/mecab/dic/ipadic/right-id.def
%{prefix}/lib/mecab/dic/ipadic/sys.dic
%{prefix}/lib/mecab/dic/ipadic/unk.dic
%{prefix}/lib/mecab/dic/ipadic/*.csv
%{prefix}/lib/mecab/dic/ipadic/unk.def
%{prefix}/lib/mecab/dic/ipadic/char.def
%{prefix}/lib/mecab/dic/ipadic/matrix.def
%{prefix}/lib/mecab/dic/ipadic/feature.def

%changelog
* Thu Nov 26 2009 Tetsuro IKEDA <te.ikeda@jpta.scs.co.jp> 2.7.0.20070801-tritonn-1.0.12a
- Tritonn 1.0.12a

* Tue Dec 09 2008 Tetsuro IKEDA <te.ikeda@jpta.scs.co.jp> 2.7.0.20070801-tritonn-1.0.12
- Tritonn 1.0.12

* Fri Jun 13 2008 Tetsuro IKEDA <te.ikeda@jpta.scs.co.jp> 2.7.0.20070801-tritonn-1.0.10
- Added *.csv files, *.def files for make install
- Tritonn 1.0.10

* Fri Feb 1 2008 Tetsuro IKEDA <ikdttr at gmail.com> - 2.7.0.20070801-tritonn.1.0.9
- Added *.csv files, a few *.def files into %files.
- Tritonn 1.0.9

* Tue Dec 18 2007 Tetsuro IKEDA <ikdttr at gmail.com> - 2.7.0.20070801-tritonn.1.0.8
- Tritonn 1.0.8

* Tue Nov 06 2007 Tetsuro IKEDA <ikdttr at gmail.com> - 2.7.0.20070801-tritonn.1.0.7a
- added "defattr" to files section.

* Mon Oct 29 2007 Tetsuro IKEDA <ikdttr at gmail.com> - 2.7.0.20070801-tritonn.1.0.7
- Initial build.

