%define name mecab
%define prefix /usr
%define version 0.98
%define release tritonn.1.0.12a

Name:      %{name}
Version:   %{version}
Release:   %{release}
Group:     Applications/Text
Summary:   Yet Another Part-of-Speech and Morphological Analyzer
License:   GPL, LGPL, Modified BSD License
URL:       http://mecab.sourceforge.net/
Source:    %{name}-%{version}.tar.gz
Packager:  Tritonn Project <http://qwik.jp/tritonn/>
BuildRoot: /tmp/%{name}-%{version}-root
Requires:  perl >= 5.8

%description
MeCab is a open source morphological analyzer which uses 
CRF (Conditional Random Fields) as the estimation of parameters.

NOTE:
You have to install MeCab dictionary rpm to make use
of MeCab.

%prep
%setup -q -n %{name}-%{version}

%build
CFLAGS="-g -O0" CXXFLAGS="-g -O0" \
./configure --prefix=%{prefix}
make

%install
[ -d $RPM_BUILD_ROOT ] && rm -fr $RPM_BUILD_ROOT
make -e prefix=${RPM_BUILD_ROOT}%{prefix} install

%clean
[ -d $RPM_BUILD_ROOT ] && rm -fr $RPM_BUILD_ROOT

%post -p /sbin/ldconfig
%postun -p /sbin/ldconfig

%files
%defattr(-,root,root)
%{prefix}/lib/libmecab.la
%{prefix}/lib/libmecab.a
%{prefix}/lib/libmecab.so.1.0.0
%{prefix}/lib/libmecab.so
%{prefix}/lib/libmecab.so.1
%{prefix}/include/mecab.h
%{prefix}/libexec/mecab/mecab-dict-index
%{prefix}/libexec/mecab/mecab-system-eval
%{prefix}/libexec/mecab/mecab-cost-train
%{prefix}/libexec/mecab/mecab-dict-gen
%{prefix}/libexec/mecab/mecab-test-gen
%{prefix}/etc/mecabrc
%{prefix}/share/man/man1/mecab.1.gz
%{prefix}/bin/mecab-config
%{prefix}/bin/mecab

%changelog
* Thu Nov 26 2009 Tetsuro IKEDA <te.ikeda@jpta.scs.co.jp> - 0.98-tritonn-1.0.12a
- mecab 0.98 for Tritonn 1.0.12a

* Tue Dec 09 2008 Tetsuro IKEDA <te.ikeda@jpta.scs.co.jp> - 0.97-tritonn-1.0.12
- Tritonn 1.0.12

* Fri Jun 13 2008 Tetsuro IKEDA <te.ikeda@jpta.scs.co.jp> - 0.97-tritonn-1.0.10
- Tritonn 1.0.10

* Fri Feb 1 2008 Tetsuro IKEDA <ikdttr at gmail.com> - 0.96-tritonn.1.0.9
- Tritonn 1.0.9

* Tue Dec 18 2007 Tetsuro IKEDA <ikdttr at gmail.com> - 0.96-tritonn.1.0.8
- Tritonn 1.0.8

* Tue Nov 06 2007 Tetsuro IKEDA <ikdttr at gmail.com> - 0.96-tritonn.1.0.7a
- added "defattr" to files section.

* Mon Oct 29 2007 Tetsuro IKEDA <ikdttr at gmail.com> - 0.96-tritonn.1.0.7
- Initial build.
