<?php
/**
 * PHP version 5
 *
 * @category Config
 * @package  TRPG Data Bank
 * @version  beta
 * @author   Cake <cake_67@users.sourceforge.jp>
 * @license  http://www.opensource.org/licenses/mit-license.php The MIT License
 * @link     http://trpgtools-onweb.sourceforge.jp/
 */
/**
 * 追加設定
 */

/* 
 * Secure関連
 */
// 同一アカウントの二重ログインを禁止する
// ログインの際、前回セッションを必ず破棄します。
// Bot用アカウント、ゲストアカウントなど複数のユーザが同時にアクセスする必要がある場合、false
Configure::write('Session.destroyOldAuth', true);


/* 
 * ユーザID/パスワード関連
 */
// ユーザIDの文字数
Configure::write('User.UserId.Length', 
	array('min' => 4, 'max' => 12)
);

// パスワードの文字数
Configure::write('User.Password.Length', 
	array('min' => 4, 'max' => 12)
);

/*
 * キャッシュ
 */
// キャッシュの最大有効期限(秒)
Configure::write('Cache.expireLong', 30 * 24 * 3600);
Configure::write('Cache.expire', 7 * 24 * 3600);
Configure::write('Cache.expireShort', 12 * 3600); // (全体の新着など、更新が頻繁な物)
// キャッシュの詳細設定
Cache::config('default', array(
	'engine' => 'File', //保存方法
	'duration'=> Configure::read('Cache.expire'),
	'probability'=> 100, // 期限切れキャッシュの更新率
	'path' => CACHE, // Fileの保存パス
	'prefix' => 'cake_',
	'serialize' => true,
));

/* 
 * 使用言語(Language)
 */
// jpn:Japanese, en:English
Configure::write('Config.language', 'jpn'); 

