<?php
/*
 * PHP version 5
 *
 * @copyright Copyright 2010, Cake. (http://trpgtools-onweb.sourceforge.jp/)
 * @category Component
 * @package  TRPG Data Bank
 * @version  beta
 * @author   Cake <cake_67@users.sourceforge.jp>
 * @license  http://www.opensource.org/licenses/mit-license.php The MIT License
 * @link     http://trpgtools-onweb.sourceforge.jp/
 */

/* メール送信コンポーネント
 * Qdmailer使用
 */

App::import('Component', 'qdmailer');
class MailComponent  extends QdmailerComponent {
	function send_mail_regist($key_code, $to, $subject, $content = null, $template = 'default', $options = array())
	{
		if (empty($key_code)) {
			return false;
		}
		$content['key_code'] = $key_code;

		$this->send_htmlmail($to, $subject, $content, 'mail_regist', $options);
		return true;
	}

	function send_member_regist($key_code, $to, $subject, $body = null, $template = 'default', $options = array())
	{
		if (empty($key_code)) {
			return false;
		}
		$content['key_code'] = $key_code;

		$this->send_htmlmail($to, $subject, $content, 'member_regist', $options);
		return true;
	}

	function send_mail($to, $subject = 'No Title', $content = null, $template = 'default', $options = array())
	{
		$this->send_htmlmail($to, $subject, $content, $template, $options);
	}

	function send_htmlmail($to, $subject = 'No Title', $content = null, $template = 'default', $options = array())
	{
		$this->_send_mail($to, $subject, $content, $template, true, $options);
	}

	function send_textmail($to, $subject = 'No Title', $content = null, $template = 'default', $options = array())
	{
		$this->_send_mail($to, $subject, $content, $template, false, $options);
	}

	function _send_mail($to, $subject = 'No Title', $content = null, $template = null, $isHtml = false, $options = array())
	{
		if (empty($to)) {
			return false;
		}

		if (isset($options['from'])) {
			if (!isset($options['replyto'])) {
				$options['replyto'] = $options['from'];
			}
		}


		// SMTP
		$config = Configure::read('Qdmailer');
		if ($config['smtp']) {
			$this->smtp(true);
			$this->smtpServer($config['smtpServer']);
		}

		// エラー処理
		$this->errorDisplay(false);

		$options = array_merge(array(
			'from' => Configure::read('Site.adminAddress'),
			'replyto' => Configure::read('Site.adminAddress'),
			'mtaOption' => '-f '.Configure::read('Site.adminAddress'),
			'cc' => '',
			'bcc' => '',
		), $options);

		$this->to($to);
		$this->from($options['from']);
		$this->replyto($options['replyto']);
		$this->mtaOption($options['mtaOption']);
		if (!empty($options['cc'])) {
			$this->cc($options['bcc']); 
		}
		if (!empty($options['bcc'])) {
			$this->bcc($options['bcc']); 
		}
		$this->kana(true);
		$this->subject($subject);

		$content['signature'] = $this->getSignature();

		if ($isHtml) {
			$this->cakeHtml($content, $template, 'default');
		} else {
			$this->cakeText($content, $template, 'default');
		}

		$this->send();

		return true;
	}

	function getSignature($isText = true)
	{
		$siteName = Configure::read('Site.siteName');

		$url = Configure::read('Routing.basePath');

		$signature = 
			"$siteName\n".
			"URL: $url\n";

		return $signature;
	}
}
