<?php
class SessionBehavior extends CakeSession {
	function setup(&$Model,$config = array()){
		$base = null;
		$start = Configure::read('Session.start');
		extract($config);
		
		$session = null;
		if(ClassRegistry::isKeySet('CakeSession')){
			$session = ClassRegistry::getObject('CakeSession');
		}else{
			App::import('Core','CakeSession');
			$session = new CakeSession($base,$start);
			
			ClassRegistry::addObject('CakeSession',$session);
		}
		
		$Model->Session = $session;
		if($start && !$Model->Session->started()){
			$Model->Session->start();
		}
	}

	function id($id = null) {
		return parent::id($id);
	}
}
