<?php


/**
 * Tables Helper: create extended tableHeaders And tableCells.
 *
 * Licensed under The MIT License
 * Redistributions of files must retain the above copyright notice.
 *
 * @copyright     Copyright 2010, Cake (http://d.hatena.ne.jp/cake67/)
 * @link          http://d.hatena.ne.jp/cakephper/
 * @package       cakeplus
 * @subpackage    cakeplus
 * @version       0.01
 * @license       MIT License (http://www.opensource.org/licenses/mit-license.php)
 *
 *
 * =====Usage=====
 * //in controller
 *   var $helpers = array('Cakeplus.Tables');
 *
 * //in view(ctp file) for using $names, $trOptions and $thOptions arr parameter, 
 *   <?php echo $tables->tableHeaders($names, $trOptions, $thOptions); ?>
 *
 * ===============
 *
 */
class TablesHelper extends HtmlHelper {
    var $helpers = array('Html');

    /**
     * Extended tableHeaders
     * You can set diffedent $thOptions on each $names.
     *
     * @param array $names //same as original tableHeaders
     * @param array $trOptions //same as original tableHeaders
     * @param array $thOptions //HTML options for "each" $names elements.
     *              Ex. $names = array('first_name', 'family_name') -> 
     *                  $thOptions = array(array('id' => 'familyName'), array('id' => 'firstName')).
)
     * @return String
     */
	function tableHeaders($names, $trOptions = null, $thOptions = null) {
		$out = array();
		foreach ($names as $key => $arg) {
			$out[] = sprintf($this->tags['tableheader'], $this->_parseAttributes($thOptions[$key]), $arg);
		}
		$data = sprintf($this->tags['tablerow'], $this->_parseAttributes($trOptions), join(' ', $out));
		return $this->output($data);
	}


}

?>
