<div class="characterSheets index">

<div class="characters listview">
<div class="box full">
<div class="boxHeader"><h2><span>
<?php if (isset($this_system['System'])): ?>
	<?php echo $html->link($this_system['System']['name'], array('controller' => 'systems', 'action' => 'view', $this_system['System']['id']), array('escape' => false), false) ?>
<?php endif; ?> 
<?php if (isset($target_user['User'])): ?>
<?php
	printf(__("%s's", true), 
		$target_user['User']['name']
	);
?>
<?php endif; ?>
<?php __('List of All CharacterSheets');?>
</h2>
</span></div>
<div class="boxBody">
<p>
<?php
$paginator->options(array('url' => $this->passedArgs));
$pagenator_options = array();

$paginator->options(array('url' => $this->passedArgs));

echo $paginator->counter(array(
'format' => __('Page %page% of %pages%, showing %current% records out of %count% total, starting on record %start%, ending on %end%', true)
));
?></p>

<div class="paging">
<?php echo $paginator->prev('<< '.__('previous', true), array(), null, array('class'=>'disabled'));?>
 | <?php echo $paginator->numbers();?> | 
<?php echo $paginator->next(__('next', true).' >>', array(), null, array('class' => 'disabled'));?>
</div>

<table cellpadding="0" cellspacing="0">
<tr>
	<th><?php echo $paginatorEx->sortAllow('id');?></th>
	<th><?php echo $paginatorEx->sortAllow(__('Name', true), 'name');?></th>
	<th><?php echo $paginatorEx->sortAllow(__('Key Name', true), 'key_name');?></th>
	<th><?php echo $paginatorEx->sortAllow(__('Public', true), 'public_flag');?></th>
<?php if (!isset($this_system)): ?>
	<th><?php echo $paginatorEx->sortAllow(__('System', true), 'system_id');?></th>
<?php endif; ?>
	<th><?php echo $paginatorEx->sortAllow(__('User Name', true), 'user_id');?></th>
<?php if (!empty($isAdmin)): ?>
	<th><?php __('User');?></th>
<?php endif; ?>
	<th><?php __('Order');?></th>
	<th><?php echo $paginatorEx->sortAllow(__('Modified', true), 'modified');?></th>
</tr>

<?php
$i = 0;
foreach ($characterSheets as $characterSheet):
	$class = null;
	if ($i++ % 2 == 0) {
		$class = ' class="altrow"';
	}
?>
<tr<?php echo $class;?>>
<td>
	<?php echo $characterSheet['CharacterSheet']['id']; ?>
</td>
<td>
<?php 
if (!empty($isAdmin) || $characterSheet['CharacterSheet']['user_id'] == $user['User']['id']) {
	echo $html->link(
		$characterSheet['CharacterSheet']['name'], 
		array(
			'controller' => 'character_sheets', 
			'action' => 'view', 
			$characterSheet['CharacterSheet']['id']
		), array('escape' => false), false
	); 
} else {
	echo $characterSheet['CharacterSheet']['name'];
}
?>
</td>
<td>
	<?php echo $characterSheet['CharacterSheet']['key_name']; ?>
</td>
<td>
<?php 
	echo $select->get_i18n_public_flag($characterSheet['CharacterSheet']['public_flag'], $public_flags); 
?>
</td>
<?php if (!isset($this_system)): ?>
<td>
<?php 
	echo $html->link(
		$characterSheet['System']['name'], 
		array(
			'controller' => 'character_sheets', 
			'action' => 'index', 
			$characterSheet['System']['id']
		), array('escape' => false), false
	); 
?>
</td>
<?php endif; ?>
<td>
<?php 
	$user_url = array(
		'controller' => 'character_sheets', 
		'action' => 'index',
		'user_id' => $characterSheet['User']['id']
	);
	if (isset($this_system)) {
		$user_url[] = $this_system['System']['id'];
	}
	echo $html->link(
		$characterSheet['User']['name'], 
		$user_url,
		array('escape' => false), false
	); 
?>
</td>
<?php if (!empty($isAdmin)): ?>
<td>
<?php 
if (!in_array($characterSheet['User']['group_id'], array(1,2,3))) {
	__('true');
}
?>
</td>
<?php endif; ?>
<td>
	<?php echo $characterSheet['CharacterSheet']['sort_order']; ?>
</td>
<td>
	<?php echo $time->niceShort($characterSheet['CharacterSheet']['modified'], array('format' => 'Y/m/d H:i')); ?>
</td>
</tr>
<?php endforeach; ?>
</table>

<div class="paging">
<?php echo $paginator->prev('<< '.__('previous', true), array(), null, array('class'=>'disabled'));?>
 | <?php echo $paginator->numbers();?> | 
<?php echo $paginator->next(__('next', true).' >>', array(), null, array('class' => 'disabled'));?>
</div>

<div class="action">
<?php 
	if (isset($this_system['System']['id'])) {
		$system_id = $this_system['System']['id'];
	} else {
		$system_id = null;
	}
	$url = array(
		'controller' => 'character_sheets',
		'action' => 'add',
		$system_id
	);
	echo $form->create('CharacterSheet', array('url' => $url, 'type' => 'get'));
?>
<?php echo $form->end(__('New CharacterSheet', true));?>
</div>


</div>
</div>

</div>