<div class="character_sheet view">

<div class="box" style="padding-bottom: 20px;">
<div class="boxHeader"><h2>
<?php
	__('How to make Skin');
?>
</h2></div>
<div class="boxBody">
<ul class="HowToSkinList">
<li><?php __('You can write the skin by using HTML tags.'); ?></li>
<li><?php __('If you write the statement enclosed in {} brackets, it will be converted to the user input values.'); ?>
<ul class="allowTags">
<li><?php __('For Example, Skin : {C:name} -> View: CharacterName'); ?></li>
</ul></li>
<li><?php __('{T:***} - {/T} and {M:***} - {/M} mean the repeating. You can use them for the table type or the multi-input type profiles.'); ?></li>
<li><?php __('You cannot BREAK in {T:***} - {/T} and {M:***} - {/M}.'); ?></li>
<?php if (empty($admin)): ?>
<li><?php __('You can use the following HTML tags '); ?>
<pre>
<ul class="allowTags">
<?php 
foreach($allow_tags as $k => $v) {
	if ($k != 0) {
		echo __(', ');
		if ($k % 10 === 0) {
			echo "\n";
		}
	}

	echo $html->tag('li', $v);
}
 ?>
</ul>
</pre>
</li>
<li><?php __('CSS must be written Exactly as follows:'); ?>
<pre>
<ul class="cssSample">
<li>&lt;style type="text/css"&gt;
&lt;!--

body {
	background: #000000;
	color: #FFFFFF;
......


--&gt;
&lt;/style&gt;
</li></ul>
</pre>
</li>
<li><?php __('You cannot use the outer CSS file.'); ?>
<li><?php __('If you want to use outer CSS, image files, script and so on, Please contact to Administrator.'); ?></li>
<?php else: ?>
<li><?php __('Administrator can use ANY HTML tags and outer CSS, Javascript and so on.'); ?></li>
<?php endif; ?>
</ul>
</div>
</div>


<div class="box">
<?php if (!empty($system)): ?>
<div class="boxHeader"><h2>
<?php
	printf(__('Sample for %s', true), $system['System']['name']);
?>
</h2></div>
<?php endif; ?>
<div class="boxBody">

<!-- Character:name  -->
<h3><?php __('Charater Name') ?></h3>
<table class="skinSample" id="skinSample_CharacterName">
<tr class="outputSample">
<th><?php __('Sample View') ?></th>
<td>
<b><?php __('Charater Name') ?></b> : ***
</td>
</tr>
<tr class="skinFormatSample">
<th><?php __('Skin Sample') ?></th>
<td>
&lt;b&gt;<?php __('Charater Name') ?></b>&lt;/b&gt; : {C:name}
</td>
</tr>
</table>

<!-- User:name  -->
<h3><?php __('User Name') ?></h3>
<table class="skinSample" id="skinSample_UserName">
<tr class="outputSample">
<th><?php __('Sample View') ?></th>
<td>
<b><?php __('User Name') ?></b> : ***
</td>
</tr>
<tr class="skinFormatSample">
<th><?php __('Skin Sample') ?></th>
<td>
&lt;b&gt;<?php __('User Name') ?></b>&lt;/b&gt; : {C:userName}
</td>
</tr>
</table>

<!-- Character:Notes  -->
<h3><?php __('Notes') ?></h3>
<table class="skinSample" id="skinSample_CharacterNotes">
<tr class="outputSample">
<th><?php __('Sample View') ?></th>
<td>
<div><b><?php __('Notes') ?></b></div>
<div>
*********<br>
******<br>
*************.......
</div>
</td>
</tr>
<tr class="skinFormatSample">
<th><?php __('Skin Sample') ?></th>
<td>
<?php echo nl2br('&lt;div&gt;'. __('Notes', true). '&lt;/div&gt;
&lt;div&gt;{C:notes}&lt;/div&gt;'); ?>
</td>
</tr>
</table>

<!-- Character:Modified  -->
<h3><?php __('Modified') ?></h3>
<table class="skinSample" id="skinSample_Modified">
<tr class="outputSample">
<th><?php __('Sample View') ?></th>
<td>
<small>(2010/12/15 11:08)</small>
</td>
</tr>
<tr class="skinFormatSample">
<th><?php __('Skin Sample') ?></th>
<td>
&lt;small&gt;{C:modified:short}&lt;/small&gt;
</td>
</tr>
</table>


<!-- Character:MainImage  -->
<h3><?php __('Main Picture') ?></h3>
<table class="skinSample" id="skinSample_mainImage">
<tr class="outputSample">
<th><?php __('Sample View') ?></th>
<td>
{C:mainPicture:l:CLASSNAME} <?php __(' -> ') ?> &lt;img src="<?php __('Main Picture') ?>" class="CLASSNAME" height="150" width="150"&gt;}
?>
</td>
</tr>
<tr class="skinFormatSample">
<th><?php __('Skin Sample') ?></th>
<td>
{C:mainPicture:$size:$class}<br>
<ul class="allowSize"><?php __('Image Size List'); ?>
<br>
<?php
$filters = Configure::read('Media.filter.image');
foreach ($filters as $key => $filter){
	$w = null;
	$h = null;
	if (isset($filter['fitCrop'])) {
		$w = $filter['fitCrop'][0];
		$h = $filter['fitCrop'][1];
	} elseif (isset($filter['fit'])) {
		$w = $filter['fit'][0];
		$h = $filter['fit'][1];
	} elseif (isset($filter['fitOutside'])) {
		$w = $filter['fitOutside'][0];
		$h = $filter['fitOutside'][1];
	} elseif (isset($filter['zoomCrop'])) {
		$w = $filter['zoomCrop'][0];
		$h = $filter['zoomCrop'][1];
	}
	if (!empty($w) && !empty($h)) {
		$size = sprintf('<b>%s</b> : %d x %d pixel', $key, $w, $h);
	} else {
		$size = sprintf('<b>%s</b> : %s', $key, __('Same size as the original image', true));
	}
	echo $html->tag('li', $size);
}
?>
</ul>
</td>
</tr>
</table>

<!-- Character:FullImage  -->
<h3><?php __('Fulll-Length Picture') ?></h3>
<table class="skinSample" id="skinSample_fullImage">
<tr class="outputSample">
<th><?php __('Sample View') ?></th>
<td>
{C:fullPicture:fullPicture_m:CLASSNAME} <?php __(' -> ') ?>
<pre>
&lt;style type="text/css"&gt;
&lt;!--
.CLASSNAME {
	background-image: url(<?php __('Fulll-Length Picture') ?>);
	background-repeat: no-repeat;
}
......
</pre>
</td>
</tr>
<tr class="skinFormatSample">
<th><?php __('Skin Sample') ?></th>
<td>
{C:fullPicture:$size:$class}<br>
<br>
<?php __('Image Size Settings are same above.'); ?>
</td>
</tr>
</table>

<?php if (!empty($system)): ?>
<?php
$i = 0;
foreach ($system['Profile'] as $profile):
	$class = null;
	$profiledisp->set_profile_type4view($profile);

	$sampleData = null;
	$skinFomat = null;
	$pattern = null;
	$rows = 2;

	// Profile Format
	if (CorePlus::get_profile_type($profile['profile_type']) == 's-table') {
		if (empty($profile['ProfileTable'][0]['ProfileTableStatic'])) {
			$format_pattern = $sample_pattern = null;
			$formatData = $sampleData = array();
			break;
		}

		$cols = array();
		$format_th = null;
		$sample_th = null;
		$sampleData[] = $profile['name'];
		foreach ($profile['ProfileTable'] as $j => $table) {
			$cols[$j] = $table['tablekey_name'];
			$format_th .= '&lt;th&gt;'. sprintf('%s', $table['title']). '&lt;/th&gt;';
			$sample_th .= '<th>%s</th>';
			$sampleData[] = $table['title'];
		}

		$rows = array();
		for ($i=0;$i<count($profile['ProfileTable'][0]['ProfileTableStatic']);$i++) {
			$rows[$i] = $profile['ProfileTable'][0]['ProfileTableStatic'][$i]['title'];
		}

		$format_td = null;
		$sample_td = null;
		foreach ($rows as $i => $row) {
			$format_td .= "&lt;tr&gt;";
			$sample_td .= "<tr>";

			foreach ($cols as $j => $tablekey_name) {
				$format_td .= '&lt;td&gt;'. 
					sprintf('{ST:%s:%s:%d}', 
						$profile['key_name'],
						$tablekey_name,
						$i+1
					). 
					'&lt;/td&gt;';

				if ($j==0) {
					$sample_td .= '<th>%s</th>';
					$sampleData[] = $row;
				} else {
					$sample_td .= '<td>%s</td>';
//					$sampleData[] = '***'. "_". $k;
					$sampleData[] = '***';
				}
			}
			$format_td .= "&lt;/tr&gt;\n";
			$sample_td .= "</tr>\n";
		}

		$format_pattern = '&lt;table&gt;
				&lt;caption&gt;{%s:title}&lt;/caption&gt;
				&lt;tr&gt;'. $format_th. '&lt;/tr&gt;
				';
		$format_pattern .= $format_td;
		$format_pattern .= '&lt;/table&gt;';

		$sample_pattern = '<table>
				<caption>%s</caption>
				<tr>'. $sample_th. '</tr>';
		$sample_pattern .= $sample_td;
		$sample_pattern .= '</table>';

	} elseif (CorePlus::get_profile_type($profile['profile_type']) == 'table') {

		$format_th = null;
		$format_td = null;
		$sample_th = null;
		$sample_td = null;
		$sampleData[] = $profile['name'];
		foreach ($profile['ProfileTable'] as $table) {
			$table_keyname = $table['tablekey_name'];
			$sampleData[] = $table['title'];

			$format_th .= '&lt;th&gt;'. sprintf('%s', $table['title']). '&lt;/th&gt;';
			$format_td .= '&lt;td&gt;'. sprintf('{%s}', $table_keyname). '&lt;/td&gt;';
			$sample_th .= '<th>%s</th>';
			$sample_td .= '<td>%s</td>';
		}
		$count = count($profile['ProfileTable']);
		$sampleData = array_merge($sampleData, array_fill($count+1, $count*2, '***'));

		$format_pattern = '&lt;table&gt;
				&lt;caption&gt;{%s:title}&lt;/caption&gt;
				&lt;tr&gt;
				'. $format_th. '
				&lt;/tr&gt;
				&lt;tr&gt;
				';
		$format_pattern .= '{T:%s}'. $format_td. '{/T}'."\n";
		$format_pattern .= '&lt;/tr&gt;
				&lt;/table&gt;';
		$formatData = array( 
			$profile['key_name'], 
			$profile['key_name']
		);

		$sample_pattern = '<table>
				<caption>%s</caption>
				<tr>'. $sample_th. '</tr>
				<tr>'. $sample_td. '</tr>
				<tr>'. $sample_td.'</tr>
				</table>';

	} elseif ($profiledisp->profile_type['is_checkbox'] || $profiledisp->profile_type['is_multi']) {
		$format_pattern = '&lt;b&gt;{%s:title}&lt;/b&gt; : 
				{M}&lt;font color="blue"&gt;{%s}&lt;/font&gt;{/M}
				 ';
		$sample_pattern = '<b>%s</b> : 
				<font color="blue">%s</font>
				<font color="blue">%s</font>
				';
		$formatData = array( 
			$profile['key_name'], 
			$profile['key_name']
		);
		$sampleData = array(
			$profile['name'],
			sprintf('%s', '***'),
			sprintf('%s', '***'). ' ...',
		);

	} else {
		$format_pattern = '&lt;b&gt;{%s:title}&lt;/b&gt; : {%s}';
		$sample_pattern = '<b>%s</b> : %s';
		if (($profiledisp->profile_type['is_select'] || $profiledisp->profile_type['is_radio']) && !empty($profile['ProfileSelect'])) {
			$select = array_shift($profile['ProfileSelect']);

			$data = $select['value'];
		} else {
			$data = '***';
		}
		$formatData = array( 
			$profile['key_name'], 
			$profile['key_name']
		);
		$sampleData = array(
			$profile['name'],
			$data
		);
	}
?>

<!-- <?php echo $profile['name'] ?> -->
<h3><?php echo $profile['name'] ?></h3>
<table class="skinSample" id="skinSample_<?php echo $profile['key_name'] ?>">
<tr class="outputSample">
<th><?php __('Sample View') ?></th>
<td>
<?php 
	call_user_func_array('printf', array_merge((array)$sample_pattern, $sampleData));
?>
</td>
</tr>
<tr class="skinFormatSample">
<th><?php __('Skin Sample') ?></th>
<td>
<?php 
	call_user_func_array('printf', array_merge((array)nl2br($format_pattern), $formatData));
?>
</td>
</tr>
</table>
<?php endforeach; ?>
<?php endif; ?>
</div>


<div class="boxFooter" style="text-align:center;">
<span><a href="#" onClick="window.close(); return false;"><?php __('Close this window') ?></a></span>
</div>


</div>