<div class="characterSheets view">
<?php 
	$url = array(
		'controller' => 'character_sheets',
		'action' => 'upload',
		$characterSheets['CharacterSheet']['id'],
		''
	);
	echo $form->create('CharacterSheet', array(
		'type' => 'file',
		'url' => $url
	));
?>

<?php
	$character_sheet_name = $characterSheets['CharacterSheet']['name'];

	if (!empty($isAdmin)) {
		$character_sheet_name .= $html->tag('span', 
			' By '. $html->link($characterSheets['User']['name'], array('controller' => 'users', 'action' => 'view', $characterSheets['User']['id']), array('escape' => false), false),
			array(
				'class' => 'text',
			)
		);
	}

	$system_name = $html->tag('span', 
		$html->link($characterSheets['System']['name'], array('controller' => 'systems', 'action' => 'view', $characterSheets['System']['id']), array('escape' => false), false),
		array(
			'class' => 'text',
		)
	);

	$public = $html->tag('span', 
		$select->get_i18n_public_flag($characterSheets['CharacterSheet']['public_flag'], $public_flags),
		array(
			'class' => 'text publicFlag',
		)
	);

	$header = $character_sheet_name. $system_name. $public;

	// Notice
	$header .= $html->tag('span', 
		$html->link( __('How to make Skin', true), array(
				'action' => 'skinsample',
				$characterSheets['System']['id'],
			), array('escape' => false, 'target' => 'help'), false, array()
		), 
		array('class' => 'upfileNotice')
	);

	if (!empty($view_link)) {
		$header .= $html->tag('span', 
			$html->link(
				__('Check View', true), 
				$view_link,
				array(
					'target' => 'sampleView',
				)
			),
			array(
				'class' => 'text',
			)
		);
	}

	// メイン表示
	// Upfile
	$body = "<fieldset>\n".
		$html->div('upsheet', 
		$form->input('file', array(
			'label' => __('Upload CharacterSheet', true),
			'type'  => 'file',
			'error' => array(
			),
		))
	).
	$token->create().
	$form->end(array('label' => __('Submit', true)));

	$body .= "</fieldset>\n";

	$footer = null;

	echo $this->element('box', array(
		'header' => $header,
		'body' => $body,
		'footer' => $footer,
	));

?>

</div>

<div class="characterSheets form">
<?php 
	$url = array(
		'controller' => 'character_sheets',
		'action' => 'edit',
		$characterSheets['CharacterSheet']['id'],
		''
	);
	echo $form->create('CharacterSheet', array(
		'url' => $url
	));
?>

<?php

	$header = __('Edit CharacterSheet', true);
	$header .= $html->tag('span',
		$html->link(__('Delete CharacterSheet', true), array(
			'action' => 'delete', $characterSheets['CharacterSheet']['id']), null, 
			sprintf(__('Are you sure you want to delete # %s?', true), $characterSheets['CharacterSheet']['name'])
		),
		array(
			'class' => 'text',
		)
	);

	$body = "<fieldset>\n".
		$form->input('name', array(
			'type' => 'text',
			'label' => __('Name', true).
				$html->tag(
					'span',
					__(' required', true),
				array('class' => 'required')
				),
			'default' => $characterSheets['CharacterSheet']['name'],
			'after' => $html->tag(
				'div',
				sprintf(__('Less than %d characters', true), 64),
				array('class' => 'attention')
			)
		)).
		$select->create_publicflag_select($public_flags, 'public_flag', array(
			'label' => __('Public Flag', true),
			'default' => $characterSheets['CharacterSheet']['public_flag'],
		)).
		$form->input('sort_order', array(
			'label' => __('Order', true),
			'style' => 'ime-mode:inactive;',
			'default' => $characterSheets['CharacterSheet']['sort_order'],
		)).
		$token->create().
		$form->end(array('label' => __('Submit', true)));

	$body .= "</fieldset>\n";

	$footer = null;

	echo $this->element('box', array(
		'header' => $header,
		'body' => $body,
		'footer' => $footer,
	));


?>
</div>