<?php
/*
 Ajax Chat for TRPG ver.2.6.2
 (c)2007-2009 Cake All Rights Reserved.
 Mail : cake_67@users.sourceforge.jp
 Home : http://trpgtools-onweb.sourceforge.jp/
 */

/*****************
 *  PHPライブラリ：書きこみ用
 *****************/

/*
 * 改行変換
 */
function convertCr($str)
{
    if (strpos($str, "\r") !== false || strpos($str, "\n") !== false) {
        $str = "<br />". $str;
    }
    $str = nl2br($str);
    $str = str_replace(array("\r\n","\r","\n"), '', $str);
    return $str;
}

/*
 * HTMLタグ変換
 */
function convert_html_tag($str)
{
    if (ALLOW_TAG) {
        // fontタグ
        $str = preg_replace("/&lt;font(\s{1,}size=[1-7\+\-][0-4]{0,}||\s{1,}color=[#]{0,}[0-9a-z]{1,7}||\s{1,}size=[1-7\+\-][0-4]{0,}\s{1,}color=[#]{0,}[0-9a-z]{1,7}||\s{1,}color=[#]{0,}[0-9a-z]{1,7}\s{1,}size=[1-7\+\-][0-4]{0,})&gt;(.*?)&lt;\/font&gt;/i", "<font$1>$2</font>", $str);
        // iniで指定のタグ
        foreach($GLOBALS['AJAX_CHAT_TRPG']['TAGS'] as $t) {
            if ($t[1]) {
            $str = preg_replace("/&lt;($t[0])&gt;(.*?)&lt;\/$t[0]&gt;/i", "<$1>$2</$1>", $str);
            }
        }
    }
    return $str;
}

/*
 * オートリンク変換
 */
function convert_autolink($str)
{
    if (AUTOLINK) {
        $str = preg_replace("/((http)|(https)):\/\/[0-9a-zA-Z\+\-\$\;\?\/\.,!#%&=~@*:_]+/i", "<a href=\"$0\" target=\"_blank\">$0</a>", $str);
    }
    return $str;
}


/*
 * 直近の過去ログ取得
 */
function write_recent_past($write, $pdata) {
    $pfp = @fopen($pdata, "a+") or die("過去ログファイルを開けません。");

    fwrite($pfp, $write);

    return true;
}

 ?>