<?php
/*
 Ajax Chat for TRPG ver.2.6.2
 (c)2007-2009 Cake All Rights Reserved.
 Mail : cake_67@users.sourceforge.jp
 Home : http://trpgtools-onweb.sourceforge.jp/
 */
/*******************
 *  カード機能：デック交換
 *******************/

// デバッグ用設定
ini_set('log_errors', false);
ini_set('error_log', "./php_error.log");

// 設定ファイルの読み込み
require_once './trpgchat-ini.php';
require_once './lib/trpgchat.php';
require_once './lib/member_check.php';
require_once './lib/card.php';

// 受信データの成形
if (!$request = request()) {
    error('リクエストを受信できません', true);
}

// 設定セット
set_config(read_config());

// 書き込みブロック
write_block();

// アクセスブロック
access_block();

// デック交換者チェック
$plname = htmlspecialchars($request['n']);
if (!$plname) {
    error('チャットに参加してください', true);
}
if (OBFUSCATION) {
    $plname = obf_xor($plname);
}
$now_member = get_member_log();
$member_flag = false;
foreach($now_member as $v) {
    if ($plname == $v[0]) {
        $member_flag = true;
        break;
    }
}
if (!$member_flag) {
    error('デック変更は参加者のみ可能です', true);
}

// ユーザデックフラグ
$userdeck_flg = false;

$write_msg = array();
// 新デック設定がある場合、設定を読み込みつつ内容チェック
if (!$request['newdeck']) {
    error('デックを指定して下さい', true);
} elseif ($request['newdeck'] != 'noCard') {
    // ユーザ設定デックの場合
    if ($request['newdeck'] == NOW_DECK_USER) {
        $userdeck_flg = true;
        $deck_config = array("config" => array("name" => USER_DECK_NAME));
        if ($deck_config['config']['name'] != USER_DECK_NAME) {
            $deck_config['config']['name'] .= '('.USER_DECK_NAME.')';
        }
        $deck_body = parse_ini_file(NOW_DECK_USER, true);

        if (!$deck_body) {
            error(USER_DECK_NAME.'デックがありません', true);
        }

        $deck_ini = array_merge($deck_config, $deck_body);

        $deck_name = $deck_ini['config']['name'].'('.USER_DECK_NAME.')';
    } else {
        $deck_ini = parse_ini_file(CARD_DIR.$request['newdeck'], true);
        $deck_name = $deck_ini['config']['name'];
    }


    if (!$deck_ini) {
        error($request['newdeck'].' デックの設定がありません', true);
    }

    // デック設定
    if (!$deck_ini['config']) {
        error($request['newdeck'].' 設定ファイルが不正です', true);
    }

    // デックパスワードチェック
    if ($deck_ini['config']['password'] != '') {
        $user_password = get_user_password();
        $deck_password = md5($deck_ini['config']['password'].ADMIN_HASH_KEY);
        if ($deck_password != $user_password) {
            error($request['newdeck'].'パスワードを正しく入力してください', true);
        }
    }

    // 追加カード用設定
    $deck_ini['config']['add'] = 0;
    $deck_ini['config']['blank'] = 0;

    // 新しいデック作成
    $deck_config = set_deckset($deck_ini);

    // カード状態セット
    $GLOBALS['AJAX_CHAT_TRPG']['deck']['status'] = array();
    foreach($deck_ini as $k => $v) {
        if ($v && $k != 'config') {
            card_status("deckCardSet", $k);
        }
    }
    $write_msg[]['msg'] = '現在のデックを'.$deck_name.'に変えました。';

// デック削除
} else {
    $deck_ini = array();
    $deck_ini['config'] = array('name' => 'なし');
    $deck_config = set_array2json($deck_ini);
    $GLOBALS['AJAX_CHAT_TRPG']['deck']['status'] = array();
    $write_msg[]['msg'] = '現在のデックを片付けました。';
}

// ファイルロック
$lfp = fopen(LOCK3,"w");
stream_set_write_buffer($lfp, 0);
flock($lfp,LOCK_EX);

// 現在のデックを削除
if (file_exists(NOW_DECK)) {
    unlink(NOW_DECK);
    unlink(NOW_DECK_STATUS);
}
// デック書き込み
if ($deck_config) {
    $fp = @fopen(NOW_DECK, "w") or error("デックファイルを開けません。", true);
    if ($deck_config) {
        fwrite($fp, $deck_config);
    }
    fclose($fp);
}
if (file_exists(NOW_DECK)) {
    chmod(NOW_DECK, 0666);
}

// 現在のカード配置書き込み
$deck_status = $GLOBALS['AJAX_CHAT_TRPG']['deck']['status'];
$fp = @fopen(NOW_DECK_STATUS, "w") or error("デックファイルを開けません。", true);
fwrite($fp, set_array2json($deck_status));
fclose($fp);
if (file_exists(NOW_DECK_STATUS)) {
    chmod(NOW_DECK_STATUS, 0666);
}

// 新デック展開をチャットに書き込み
echo set_array2json($write_msg);

// ユーザ設定デック以外の場合、ユーザデックをクリア
if (!$userdeck_flg) {
    $fp = @fopen(NOW_DECK_USER, "w") or error(USER_DECK_NAME."デックファイルを開けません。", true);
    fclose($fp);
}

// ロック解除
fflush($lfp);
fclose($lfp);

exit;

?>