<?php
/*
 Ajax Chat for TRPG ver.2.6.2
 (c)2007-2009 Cake All Rights Reserved.
 Mail : cake_67@users.sourceforge.jp
 Home : http://trpgtools-onweb.sourceforge.jp/
 */
/*******************
 *  カード機能：ユーザによるデックアップロード
 *******************/

// デバッグ用設定
ini_set('log_errors', true);
ini_set('error_log', "./php_error.log");

// 設定ファイルの読み込み
require_once './trpgchat-ini.php';
require_once './lib/trpgchat.php';
require_once './lib/card.php';
require_once './lib/AjaxChat/init.php';
require_once './lib/AjaxChat/ini_filer_deck.php';
require_once './lib/AjaxChat/post.php';
require_once './lib/AjaxChat/executant.php';

// 初期設定セット
$init = new Tw_Init(OBFUSCATION);

$msg_prefix= '['.basename($_SERVER['SCRIPT_NAME']).']';
set_config(read_config());

// 管理設定のチェック
if (!ALLOW_USER_DECK_ADD) {
    error('この機能は現在使用できません。');
}

// 書き込みブロック
write_block();

// アクセスブロック
access_block();

// 受信データチェック
$post = new Tw_Post();
$files = $post->get_files();
if (!$files || !$files['deckfile']['name']) {
    error('ファイルを指定して下さい', true);
}
$posts = $post->get_posts();
if (!$posts || !$posts['dealer_name']) {
    error('送信情報が不正です', true);
}
// 実行者チェック
$executant = new Tw_Executant($posts['dealer_name'], $init);
$executant->check_only_member();
if ($msg = $executant->get_error()) {
    error($msg, true);
}

// アップロードファイル読込み
$upfile = save_upload_card_inifile($files['deckfile']);
if ($upfile['error']) {
    error($ini['error'], true);
}

// アップロードファイルをユーザカード設定に書込み
$write_msg = array();
$ini_filer = new Tw_Ini_Filer_Deck();
$ini_filer->save_ini_file(NOW_DECK_USER, $upfile["card_ini"], 'user');
if ($msg = $ini_filer->get_error()) {
    error($msg, true);
}

// 操作のシステムログ書込み
write_syslog('Set User Deck by '.$posts['dealer_name'] , $msg_prefix);

// カード表示に戻る
$self_url = get_self_url();
$url = str_replace('card_deck_upload.php', '', $self_url).'card.php';

header('Location: '. $url);

// ユーザデック変更をチャットに書き込み
//echo set_array2json($write_msg);

exit;
