<?php
/*
 Ajax Chat for TRPG ver.2.6.2
 (c)2007-2009 Cake All Rights Reserved.
 Mail : cake_67@users.sourceforge.jp
 Home : http://trpgtools-onweb.sourceforge.jp/
 */
/*******************
 *  カード機能：カード更新（引く、捨てる）
 *******************/

// デバッグ用設定
ini_set('log_errors', false);
ini_set('error_log', "./php_error.log");

// 設定ファイルの読み込み
require_once './trpgchat-ini.php';
require_once './lib/trpgchat.php';
require_once './lib/member_check.php';
require_once './lib/card.php';

// 受信データの成形
if (!$request = request()) {
    error('リクエストを受信できません', true);
}

// 設定セット
set_config(read_config());

// 書き込みブロック
write_block();

// アクセスブロック
access_block();

// 実行者チェック
$plname = htmlspecialchars($request['n']);
if (!$plname) {
    error('チャットに参加してください', true);
}

if (!$request['cn']) {
    $request['cn'] = 1;
}

// 難読化
if (OBFUSCATION) {
    $from = obf_xor($request['f']);
    $to = obf_xor($request['t']);
    $deckOwner = obf_xor('deckCardSet');
} else {
    $from = $request['f'];
    $to = $request['t'];
    $deckOwner = 'deckCardSet';
}

$fieldFrom =$request['ff'];
$fieldTo = $request['ft'];
$action = $request['a'];

if (!($to && $from && $fieldFrom && $fieldTo && $action)) {
    error('パラメータ不足です。', true);
}
if (!$to || !$from
    || ($fieldFrom != 'Secret' && $fieldFrom != 'Field')
    || ($fieldTo != 'Secret' && $fieldTo != 'Field')
    || ($action != 'r' && ($request['cn'] < 1))
    || ($action != 'd' && $action != 'c' && $action != 'r')) {
    error('パラメータが不正です。', true);
}

// カード移動
// ファイルロック
$lfp = fopen(LOCK3,"w");
stream_set_write_buffer($lfp, 0);
flock($lfp,LOCK_EX);

// 現在のカード状態
$deck_json = file_get_contents(NOW_DECK);
$deck = set_json2array($deck_json);
$deck_status_json = file_get_contents(NOW_DECK_STATUS);
$deck_status = set_json2array($deck_status_json);

if (!$deck || !$deck_status) {
    error('現在のカード状態設定がありません', true);
}

// 移動元のカード
if (count((array)$deck_status[$from][$fieldFrom]['card']) < 1) {
    error($request['f'].'の'.$fieldFrom.'札がありません。', true);
}
// 移動先のカード
$to_card_set = $deck_status[$to][$fromTo]['card'];

// カード操作
$write_msg = array();
$target_keys = array();
// 指定場所の札を全て山に戻す
if ($action == 'r') {
    $deck_status[$deckOwner]['Secret']['card'] = array_merge($deck_status[$deckOwner]['Secret']['card'], $deck_status[$from][$fieldFrom]['card']);
    unset($deck_status[$from][$fieldFrom]['card']);

    list($write_msg[0]['msg'], $action, $is_secret) = writeMoveCard($request['f'], $fieldFrom, $request['t'], $fieldTo, '', $request['tm']);
// ランダムで移動
} elseif (!$request['id']) {
    list($write_msg[0]['msg'], $action, $is_secret) = writeMoveCard($request['f'], $fieldFrom, $request['t'], $fieldTo, $request['cn'], $request['tm']);
    $write_msg[1] = setCardMoveDetailForWriteToChat($action, $is_secret);

    // カード移動
    for ($i=0;$i<$request['cn'];$i++) {
        if (!$deck_status[$from][$fieldFrom]['card']) {
            break;
        }

        $target_index = array_rand($deck_status[$from][$fieldFrom]['card'], 1);
        $target_card = array_splice($deck_status[$from][$fieldFrom]['card'], $target_index, 1);

        list($target_card_id, $card_head) = moveCardByTargetId(&$deck_status, $target_card, $from, $to, $fieldFrom, $fieldTo, $request['ih']);

        $card_name = $deck[$target_card_id]['name_long'];
        if (OBFUSCATION) {
            $card_name = de_obf_xor($card_name);
        }

        if ($card_head) {
            $card_name = '(逆位置)'. $card_name;
        }

        if ($write_msg[1]) {
            if ($i) {
                $write_msg[1]['msg'] .= "、";
            }
            $write_msg[1]['msg'] .= $card_name;
        }

        if (count($deck_status[$from][$fieldFrom]['card']) < 1) {
            break;
        }
    }
// カードを指定して移動
} else {
    if (OBFUSCATION) {
        $target_card_id = obf_xor($request['id']);
    } else {
        $target_card_id = $request['id'];
    }

    $flag_move = false;
    foreach ($deck_status[$from][$fieldFrom]['card'] as $target_index => $v) {
        if ($v['id'] == $target_card_id) {
            list($write_msg[0]['msg'], $action, $is_secret) = writeMoveCard($request['f'], $fieldFrom, $request['t'], $fieldTo, 1, $request['tm']);
            $write_msg[1] = setCardMoveDetailForWriteToChat($action, $is_secret);

            $target_card = array_splice($deck_status[$from][$fieldFrom]['card'], $target_index, 1);

            list($target_card_id, $card_head) = moveCardByTargetId(&$deck_status, $target_card, $from, $to, $fieldFrom, $fieldTo, $request['ih']);

            $card_name = $deck[$target_card_id]['name_long'];
            if ($card_head) {
                $card_name = '(逆位置)'. $card_name;
            }

        if ($write_msg[1]) {
            if ($i) {
                $write_msg[1]['msg'] .= "、";
            }
            $write_msg[1]['msg'] .= $card_name;
        }

            $flag_move = true;
            break;
        }
    }
    if (!$flag_move) {
        error('指定のカードがありません', true);
    }
}

if ($write_msg[1]['isSecret']) {
    if ($request['t'] == $request['n']) {
        $write_msg[1]['secretTo'] = $request['f'];
    } elseif ($request['f'] == $request['n']) {
        $write_msg[1]['secretTo'] = $request['t'];
    }
}

// カード操作結果の書き込み
$fp = @fopen(NOW_DECK_STATUS, "w") or error("カードファイルを開けません。", true);
fwrite($fp, set_array2json($deck_status));
fclose($fp);

// ロック解除
fflush($lfp);
fclose($lfp);

// 操作結果をチャットに書き込み
if ($write_msg) {
    echo set_array2json($write_msg);
}

exit;
