<?php
/*
 Ajax Chat for TRPG ver.2.7
 (c)2007-2009 Cake All Rights Reserved.
 Mail : cake_67@users.sourceforge.jp
 Home : http://trpgtools-onweb.sourceforge.jp/
 */

/*
 * デック
 */

class Deck
{

    private $deckset = array();
    private $new_deskset;
    private $deckstatus = array();
    private $new_deskstatus;
    private $handled_cards = array();

    /* 現在の設定ファイルセットとチェック */
    public function set_deckset($isAvailable=false)
    {
        $this->deckset = $this->get_deckfile2arr(NOW_DECK);
         if ($isAvailable && !$this->deckset) {
            throw new FileLocked_Exception('現在のカード設定がありません');
        }
   }
    public function set_deckstatus($isAvailable=false)
    {
        $this->deckstatus = $this->get_deckfile2arr(NOW_DECK_STATUS);
        if ($isAvailable && !$this->deckstatus) {
            throw new FileLocked_Exception('現在のカード配置設定がありません');
        }
    }


    /* カード追加 */
    public function set_new_deck($card_arr)
    {
        if (!$card_arr) {
            throw new FileLocked_Exception('追加のカード設定がありません');
        }
        $this->new_deskset = $this->get_deckset();
        if (!$this->new_deskset) {
            $this->new_deskset = array('config' => array('name' => 'なし'));
        }
        $this->new_deskstatus = $this->get_deckstatus();

        $keys = array_keys($card_arr);
        $id_prefix = $keys[0];
        switch($id_prefix) {
            case 'add':
                $i = intval($this->new_deskset['config']['add']);
                $owner = Tw_Obf::obf_xor('deckCardSet', OBFUSCATION);
                $field = 'Secret';
                break;
            default:
                throw new FileLocked_Exception('追加の設定が不正です');
                break;
        }

        foreach ($card_arr[$id_prefix] as $k => $v) {
Controller::dump2error_log($v);
            $key = $id_prefix.'_'.$i;
            $this->new_deskset['config'][$id_prefix]++;
            $this->new_deskset[$key] = $v;

            $deck_stats = array(
                'id' => Tw_Obf::obf_xor($key, OBFUSCATION),
                'open' => false
            );
            $this->new_deskstatus[$owner][$field]['card'][] = $deck_stats;
            $this->set_handled_cards(Tw_Obf::de_obf_xor($v['name_long'], OBFUSCATION));

            $i++;
        }

        return true;
    }

    public function get_deckset()
    {
        return $this->deckset;
    }
    public function get_deckstatus()
    {
        return $this->deckstatus;
    }
    public function get_new_deskset()
    {
        return $this->new_deskset;
    }
    public function get_new_deckstatus()
    {
        return $this->new_deskstatus;
    }

    /* 操作カード名一覧 */
    public function set_handled_cards($card_name)
    {
        $this->handled_cards[] = $card_name;
    }
    public function get_handled_cards()
    {
        return $this->handled_cards;
    }

    /*
     * デックファイル(JSON)読込んで配列にセット
     */
    private function get_deckfile2arr($filepath)
    {
        return Tw_JSON::get_jsonfile2arr($filepath);
    }

}