<?php
/*
 Ajax Chat for TRPG ver.2.7
 (c)2007-2009 Cake All Rights Reserved.
 Mail : cake_67@users.sourceforge.jp
 Home : http://trpgtools-onweb.sourceforge.jp/
 */

/*
 * 操作の実行者
 */

class Tw_Executant
{
    public static $host;
    public static $ua;
    private $name;
    private $is_member = false;

    public function init($name)
    {
        // 記号処理・難読化して実行者名セット
        if ($name) {
            $this->set_name($name);
        }

        return $this;
    }

    function __construct()
    {
        // ユーザの情報
        $this->set_host();
        $this->set_ua();
    }

    /* 参加者のみ */
    public function check_only_member($membersObj)
    {
        if (!$exeName = $this->get_name()) {
            throw new Return_Exception('チャットに参加してください', true);
        }
        if (!$this->get_is_member($membersObj, $exeName)) {
            throw new Return_Exception('参加者のみ可能です', true);
        }
        return true;
    }

    /*
     * チャット参加状態チェック
     * リアルタイム確認
     */
    public function get_is_member($membersObj, $name)
    {
        return $membersObj->get_is_member($name);
    }
    private function set_is_member()
    {
        return $this->check_only_member();
    }

    /* 基本変数など */
    /* 実行者名 */
    private function set_name($name)
    {
        $name = Tw_Obf::obf_xor($name, OBFUSCATION);
        return $this->name = $name;
    }
    public function get_name()
    {
        return $this->name;
    }

    /* host情報 */
    private function set_host()
    {
        $this->host = gethostbyaddr($_SERVER['REMOTE_ADDR']);

    }
    public static function get_host()
    {
        return self::$host;
    }
    /* User Agent 情報 */
    private function set_ua()
    {
        $this->ua = getenv("HTTP_USER_AGENT");

    }
    public static function get_ua()
    {
        return self::$ua;
    }

    public static function &getInstance($name)
    {
        static $singleton;
        if (empty($singleton)) {
            $singleton = new Tw_Executant;
            $singleton->init($name);
        }

        return $singleton;
    }

}
