<?php
/*
 Ajax Chat for TRPG ver.2.7
 (c)2007-2009 Cake All Rights Reserved.
 Mail : cake_67@users.sourceforge.jp
 Home : http://trpgtools-onweb.sourceforge.jp/
 */

/*
 * JSON⇔配列変換
 */

require_once './lib/include/Jsphon/Encoder.php';
require_once './lib/include/Jsphon/Decoder.php';

class Tw_JSON
{

    /*
     * JSONファイルを読込んで配列にセット
     */
    public static function get_jsonfile2arr($filepath, $decodeOverUCS2=false)
    {
        $json = file_get_contents($filepath);

        if (!$json) {
            $json = "[]";
        }

        return self::set_json2array($json, $decodeOverUCS2);
    }

    /* 
     * 配列をJSONへパース
     */
    public static function set_array2json($data, $escapeNonASCII=false, $escapeOverUCS2=false)
    {
        if (!is_array($data)) {
            $data = array();
        }

        $json =& self::getEncodeInstance($escapeNonASCII, $escapeOverUCS2);
        $purse = $json->encode($data);

        return $purse;
    }

    /* 
     * JSONを配列へパース
     */
    public static function set_json2array($data, $decodeOverUCS2=false)
    {
        $json =& self::getDecodeInstance($decodeOverUCS2);
        $arr = $json->decode($data);

        return $arr;
    }

    /* getInstance */
    public static function &getEncodeInstance($escapeNonASCII=true, $escapeOverUCS2=false)
    {
        static $encode_singleton;
        if (empty($encode_singleton)) {
            $encode_singleton = new Jsphon_Encoder($escapeNonASCII, $escapeOverUCS2);
        }

        return $encode_singleton;
    }

    public static function &getDecodeInstance($decodeOverUCS2=false)
    {
        static $decode_singleton;
        if (empty($decode_singleton)) {
            $decode_singleton = new Jsphon_Decoder($decodeOverUCS2);
        }

        return $decode_singleton;
    }

}