<?php
/*
 Ajax Chat for TRPG ver.2.6.2
 (c)2007-2009 Cake All Rights Reserved.
 Mail : cake_67@users.sourceforge.jp
 Home : http://trpgtools-onweb.sourceforge.jp/
 */

/*****************
 *  PHPライブラリ：共通
 *****************/

// toDo: 3で直す
require_once './lib/Controller.php';
require_once './lib/include/Tw/JSON.php';
/*
if (DEVELOP_MODE) {
    require_once './lib/include/Var_Dump/Var_Dump.php';
    require_once './lib/include/Var_Dump/Var_Dump/Renderer.php';
}
*/

/* リクエストを取得 */
function request() {
    if (!strcasecmp(METHOD, 'GET')) {
        $request = $_GET;
    } elseif (!strcasecmp(METHOD, 'POST')) {
        $request = $_POST;
    }
    return $request;
}

/* 設定ファイル個別読み込み */
function read_config_one($configfile) {
    $lines = file($configfile);
    return $lines;
}

/* 全設定ファイル */
/* 全設定ファイル読み込み */
function read_config() {
    return array_merge(read_config_one(CONFIG_IMPORTANT), read_config_one(CONFIG_TAG), read_config_one(CONFIG_TRPG), read_config_one(CONFIG_CARD), read_config_one(CONFIG_BASE_COLOR), read_config_one(CONFIG_MAIN_COLOR), read_config_one(CONFIG_MAIN), read_config_one(CONFIG_ICON), read_config_one(CONFIG_MOBILE));
}

/* 設定を変数にセット */
// 0設定項目名,1備考,2変数名,3変数(0)/配列(1)/2次元配列(2),4入力形式(0:INPUT,1:TEXTAREA,2:radio[YES/NO]),5プレビュータイプ,6-設定内容
// 編集画面ではセット名を若干変更する
function set_config($lines, $editmode = false){
    if (!$lines) error ("設定データがありません");

    foreach ($lines as $v1) {
        $v1 = rtrim($v1);
        if ($v1) {
            $config = explode("<>", $v1);
            if ($config[2]) {
                if ($editmode) {
                    $name = $config[2]."_EDIT";
                } else {
                    $name = $config[2];
                }
                // 変数の場合：セット
                if ($config[3] == 0) {
                    define($name, $config[6]);
                } else {
                    // 配列の場合
                    // 2次元配列の場合
                    if($config[3] >= 2) {
                        $GLOBALS['AJAX_CHAT_TRPG'][$name] = array();
                        for ($i=0;$i<=count($config)-7;$i++) {
                            $GLOBALS['AJAX_CHAT_TRPG'][$name][] = explode("</>", $config[$i+6]);
                        }
                    // 1次元配列の場合
                    } else {
                        $GLOBALS['AJAX_CHAT_TRPG'][$name] = explode("</>", $config[6]);
                    }
                }
            }
        } else {
           error(設定ファイルが不正です);
        }
    }
}


/*
 * 指定ディレクトリ内のファイル・ディレクトリ一覧
 */
function get_dir_contents_list($dir, $sort = 'DESC', $set_sort=true) {
    $file_list = array();
    $dir_list = array();

    $dp = opendir($dir);
    while($str = readdir($dp)) {
        if (is_dir($dir.$str) && $str != '.' && $str != '..') {
            $dir_list[] = $str;
        } elseif (is_file($dir.$str) && $str != 'index.html') {
            $file_list[] = $str;
        }
    }
    closedir($dp);

    // ソート
    if ($set_sort) {
        if($sort == 'ASC') {
            sort($file_list);
            sort($dir_list);
        } else {
            rsort($file_list);
            rsort($dir_list);
        }
    }

    return array('dirs' => $dir_list, 'files' => $file_list);
}

/* 色選択出力 */
function colorbox($id, $select=''){
    $color_list = array();
    foreach ($GLOBALS['AJAX_CHAT_TRPG']['COLOR_CODE'] as $k1 => $v1) {
        foreach ($GLOBALS['AJAX_CHAT_TRPG']['COLOR_CODE'] as $v2) {
            foreach ($GLOBALS['AJAX_CHAT_TRPG']['COLOR_CODE'] as $v3) {
                $color_list[] = $v1.$v2.$v3;
            }
        }
    }
    array_unique($color_list);
    sort($color_list);
    foreach ($color_list as $k => $v) {
        print'<option value="'.$v.'" style="color: #'.$v.';"';
        if ($select == $v) { print ' selected';}
        print '>'.$v.'</option>'."\n";
    }
}

/* ヘッター */
function html_header($title, $window = false, $js = true, $no_cache = true) {
    $header = '<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN">'."\n";
    $header .= '<html>'."\n";
    $header .= '<head>'."\n";
    $header .= '<meta http-equiv="Content-Type" content="text/html; charset=utf-8">'."\n";
    $header .= '<meta http-equiv="Content-Style-Type" content="text/css" />'."\n";
    if ($js) {
        $header .= '<meta http-equiv="Content-Script-Type" content="text/javascript" />'."\n";
    }
    if ($no_cache) {
        $header .= '<meta http-equiv="Pragma" content="no-cache">'."\n";
        $header .= '<meta http-equiv="Cache-Control" content="no-store, no-cache, must-revalidate">'."\n";
        $header .= '<meta http-equiv="Expires" content="Thu, 01 Feb 1960 00:00:00 GMT">'."\n";
    }

    // css
    if ($window != 'pastlog') {
        $header .= '<link rel="stylesheet" type="text/css" href="./css/trpgchat.css">'."\n";
    }
    if ($window == 'index' || $window == 'card') {
        $header .= '<link rel="stylesheet" type="text/css" href="./css/index.css">'."\n";
    } elseif ($window == 'main' || $window == 'admin') {
        $header .= '<link rel="stylesheet" type="text/css" href="./css/main.css">'."\n";
    }
    if ($window == 'admin' || $window == 'edit_config') {
        $header .= '<link rel="stylesheet" type="text/css" href="./css/admin.css">'."\n";
    }
    if ($window == 'card') {
        $header .= '<link rel="stylesheet" type="text/css" href="./css/card.css">'."\n";
    }

    // 管理機能からの設定
    if ($window == 'main') {
        $header .= '<link rel="stylesheet" type="text/css" href="./css/main_css.php">'."\n";
    }
    $header .= '<style type="text/css">'."\n";
    $header .= '<!--'."\n";
    if ($window == 'pastlog') {
        $header .= output_file_line('./css/trpgchat.css', 3, 0);
        $header .= output_file_line('./css/main.css', 3, 0);
    }
    $header .= 'body {'."\n";
    if ($window == 'main' || $window == 'pastlog') {
        $header .= '    color: #'.MAIN_TEXTCOLOR.';'."\n";
        if (MAIN_BGCSS) {
            $header .= '    background: '.MAIN_BGCSS."\n";
        } else {
            $header .= '    background-color: #'.MAIN_BGCOLOR.";\n";
            $header .= '    background-image: url('.MAIN_BGIMAGE.');'."\n";
        }
        $header .= '}'."\n";
        $header .= 'a:link {'."\n";
        $header .= '    color: #'.MAIN_LINK.';'."\n";
        if (!MAIN_LINK_UNDERLINE) $header .= '    text-decoration: none;'."\n";
        $header .= '}'."\n";
        $header .= 'a:visited {'."\n";
        $header .= '    color: #'.MAIN_VLINK.';'."\n";
        if (!MAIN_VLINK_UNDERLINE) $header .= '    text-decoration: none;'."\n";
        $header .= '}'."\n";
        $header .= 'a:hover {'."\n";
        $header .= '    color: #'.MAIN_HLINK.';'."\n";
        if (!MAIN_HLINK_UNDERLINE) $header .= '    text-decoration: none;'."\n";
        $header .= '}'."\n";
        $header .= 'img.btn {'."\n";
        $header .= '    color: #'.INPUT_BORDER_COLOR.";\n";
        $header .= '}'."\n";
        $header .= '.break, .break_hr {'."\n";
        if (MAIN_BREAK_COLOR) {
            $header .= '    color: #'.MAIN_BREAK_COLOR.";\n";
        }
        if ((int)MAIN_BREAK_WIDTH) {
            $header .= '    border-bottom-width: '.(int)MAIN_BREAK_WIDTH."px;\n";
        }
        if (MAIN_BREAK_STYLE_DEFAULT) {
            $header .= '    border-style: '.MAIN_BREAK_STYLE_DEFAULT.";\n";
        } else {
            $header .= "    border-style: none\n";
        }
        $header .= '}'."\n";

    } elseif ($window == 'edit_config') {
        $header .= '    color: #'.BASE_TEXTCOLOR_EDIT.';'."\n";
        if (BASE_BGCSS_EDIT) {
            $header .= '    background: '.BASE_BGCSS_EDIT."\n";
        } else {
            $header .= '    background-color: #'.BASE_BGCOLOR_EDIT.";\n";
            $header .= '    background-image: url('.BASE_BGIMAGE_EDIT.');'."\n";
        }
        $header .= '}'."\n";
        $header .= 'a:link {'."\n";
        $header .= '    color: #'.BASE_LINK_EDIT.';'."\n";
        if (!BASE_LINK_UNDERLINE_EDIT) $header .= '    text-decoration: none;'."\n";
        $header .= '}'."\n";
        $header .= 'a:visited {'."\n";
        $header .= '    color: #'.BASE_VLINK_EDIT.';'."\n";
        if (!BASE_VLINK_UNDERLINE_EDIT) $header .= '    text-decoration: none;'."\n";
        $header .= '}'."\n";
        $header .= 'a:hover {'."\n";
        $header .= '    color: #'.BASE_HLINK_EDIT.';'."\n";
        if (!BASE_HLINK_UNDERLINE_EDIT) $header .= '    text-decoration: none;'."\n";
        $header .= '}'."\n";
        $header .= 'img.btn {'."\n";
        $header .= '    color: #'.INPUT_BORDER_COLOR_EDIT.";\n";
        $header .= '}'."\n";
        $header .= 'input.text, input.password, textarea, select {'."\n";
        $header .= '    color: #'.INPUT_TEXTCOLOR_EDIT.';'."\n";
        $header .= '    background-color: #'.INPUT_BGCOLOR_EDIT.";\n";
        if (INPUT_BORDER_CSS_EDIT) {
            $header .= '    border: '.INPUT_BORDER_CSS_EDIT."\n";
        } else {
            $header .= '    border-color: #'.INPUT_BORDER_COLOR_EDIT.";\n";
        }
        $header .= '}'."\n";
        $header .= 'table, td {'."\n";
        if (INPUT_BORDER_CSS_EDIT) {
            $header .= '    border: '.INPUT_BORDER_CSS_EDIT."\n";
        } else {
            $header .= '    border-color: #'.INPUT_BORDER_COLOR_EDIT.";\n";
            $header .= "    border-style: solid;\n";
            $header .= "    border-width: 1px;\n";
        }
        $header .= '}'."\n";
    } elseif ($window == 'card') {
        $header .= '}'."\n";
    } else {
        $header .= '    color: #'.BASE_TEXTCOLOR.';'."\n";
        if (BASE_BGCSS) {
            $header .= '    background: '.BASE_BGCSS."\n";
        } else {
            $header .= '    background-color: #'.BASE_BGCOLOR.";\n";
            $header .= '    background-image: url('.BASE_BGIMAGE.');'."\n";
        }
        $header .= '}'."\n";
        $header .= 'a:link {'."\n";
        $header .= '    color: #'.BASE_LINK.';'."\n";
        if (!BASE_LINK_UNDERLINE) $header .= '    text-decoration: none;'."\n";
        $header .= '}'."\n";
        $header .= 'a:visited {'."\n";
        $header .= '    color: #'.BASE_VLINK.';'."\n";
        if (!BASE_VLINK_UNDERLINE) $header .= '    text-decoration: none;'."\n";
        $header .= '}'."\n";
        $header .= 'a:hover {'."\n";
        $header .= '    color: #'.BASE_HLINK.';'."\n";
        if (!BASE_HLINK_UNDERLINE) $header .= '    text-decoration: none;'."\n";
        $header .= '}'."\n";
        $header .= 'img.btn {'."\n";
        $header .= '    color: #'.INPUT_BORDER_COLOR.";\n";
        $header .= '}'."\n";
        $header .= 'input.text, input.password, textarea, select {'."\n";
        $header .= '    color: #'.INPUT_TEXTCOLOR.';'."\n";
        $header .= '    background-color: #'.INPUT_BGCOLOR.";\n";
        if (INPUT_BORDER_CSS) {
            $header .= '    border: '.INPUT_BORDER_CSS."\n";
        } else {
            $header .= '    border-color: #'.INPUT_BORDER_COLOR.";\n";
        }
        $header .= '}'."\n";
        $header .= '.mainframe {'."\n";
        if (MAIN_BORDER) {
            $header .= '    border: '.MAIN_BORDER.";\n";
        } else {
            $header .= '    border-color: #'.MAIN_BORDER_COLOR.";\n";
        }
        $header .= '}'."\n";
        $header .= '.inputmain {'."\n";
        $header .= '    color: #'.MAIN_TEXTCOLOR.';'."\n";
        if (MAIN_BGCSS) {
            $header .= '    background: '.MAIN_BGCSS."\n";
        } else {
            $header .= '    background-color: #'.MAIN_BGCOLOR.";\n";
            $header .= '    background-image: url('.MAIN_BGIMAGE.');'."\n";
        }
        $header .= '}'."\n";
        
        if ($window == 'admin') {
            $header .= 'table {'."\n";
                if (INPUT_BORDER_CSS) {
                $header .= '    border: '.INPUT_BORDER_CSS.";\n";
            } else {
                $header .= '    border-color: #'.INPUT_BORDER_COLOR.";\n";
                $header .= "    border-style: solid;\n";
                $header .= "    border-width: 1px;\n";
            }
            $header .= '}'."\n";
        }
    }

if ($window == 'card') {
    $header .= '.secretCard {'."\n";
    $header .= '    background-image: url('.CARD_BGIMAGE.');'."\n";
    $header .= '}'."\n";
    $header .= '.card  {'."\n";
    $header .= "    background-color: #".CARD_BGCOLOR.";\n";
    $header .= "    color: #".CARD_TEXTCOLOR.";\n";
    $header .= '}'."\n";
    $header .= '.openCard  {'."\n";
    $header .= "    background-color: #".CARD_BGCOLOR.";\n";
    $header .= "    color: #".CARD_TEXTCOLOR.";\n";
    $header .= '}'."\n";
    $header .= '#cardDetail {'."\n";
    $header .= "    background-color: #".CARD_BGCOLOR.";\n";
    $header .= "    color: #".CARD_TEXTCOLOR.";\n";
    $header .= '}'."\n";
    $header .= '#deckUtil #body {'."\n";
    $header .= '    background-color: #'.MAIN_BGCOLOR.";\n";
    $header .= '}'."\n";
}
    // 全体共通CSS
    // ステータス色
    $header .= '.status {'."\n";
    $header .= '    color: #'.STATUS_COLOR.";\n";
    $header .= "}\n";

    // input設定
    $header .= 'input.radio, input.checkbox {'."\n";
    $header .= '    border-style: none;'."\n";
    $header .= '}'."\n";

    // アイコン
    $header .= 'input.btn {'."\n";
    $header .= '    background-color: '.BASE_BGCOLOR.';'."\n";
    $header .= '}'."\n";

    // コンソール色設定
    $console_header_css = '
	padding: 3px;
        font-size:14px;
    ';
    $console_body_css = '
	padding: 3px;
	padding-top: 3px;
    ';
    $console_footer_css = '
	padding: 3px;
    ';

    $header .= '.console {'."\n";
    $header .= '    color: #'.MAIN_TEXTCOLOR.';'."\n";
    if (MAIN_BGCSS) {
        $header .= '    background: '.MAIN_BGCSS."\n";
    } else {
        $header .= '    background-color: #'.MAIN_BGCOLOR.";\n";
        $header .= '    background-image: url('.MAIN_BGIMAGE.');'."\n";
    }
    $header .= '}'."\n";
    $header .= '.console a:link {'."\n";
    $header .= '    color: #'.MAIN_LINK.';'."\n";
    if (!MAIN_LINK_UNDERLINE) $header .= '    text-decoration: none;'."\n";
    $header .= '}'."\n";
    $header .= '.console a:visited {'."\n";
    $header .= '    color: #'.MAIN_VLINK.';'."\n";
    if (!MAIN_VLINK_UNDERLINE) $header .= '    text-decoration: none;'."\n";
    $header .= '}'."\n";
    $header .= '.console a:hover {'."\n";
    $header .= '    color: #'.MAIN_HLINK.';'."\n";
    if (!MAIN_HLINK_UNDERLINE) $header .= '    text-decoration: none;'."\n";
    $header .= '}'."\n";
    $header .= '.console .break, .break_hr {'."\n";
    if (MAIN_BREAK_COLOR) {
        $header .= '    color: #'.MAIN_BREAK_COLOR.";\n";
    }
    if ((int)MAIN_BREAK_WIDTH) {
        $header .= '    border-width: '.(int)MAIN_BREAK_WIDTH."px 0 0 0;\n";
    }
    if (MAIN_BREAK_STYLE_DEFAULT) {
        $header .= '    border-style:'.MAIN_BREAK_STYLE_DEFAULT.";\n";
    } else {
        $header .= "    border-style: none\n";
    }
    $header .= '}'."\n";
    $header .= '.console #console{'."\n";
    $header .= $console_header_css."\n";
    $header .= '}'."\n";
    $header .= '.console #console{'."\n";
    $header .= $console_body_css."\n";
    $header .= '}'."\n";
    $header .= '.console #console{'."\n";
    $header .= $console_footer_css."\n";
    $header .= '}'."\n";

    $header .= '-->'."\n";
    $header .= '</style>'."\n";
    if ($js) {
        if (DEVELOP_MODE) {
            $header .= '<script type="text/javascript" src="./lib/js/prettyprint.js"></script>'."\n";
        }
        $header .= '<script type="text/javascript" src="./lib/js/jquery-1.3.1.min.js"></script>'."\n";
//        $header .= '<script type="text/javascript" src="./lib/js/core.js" charset="utf-8"></script>'."\n";
        $header .= '<script type="text/javascript" src="./lib/js/trpgchat.js" charset="utf-8"></script>'."\n";
        $header .= '<script type="text/javascript" src="./lib/js/obf.js" charset="utf-8"></script>'."\n";
        if ($window == 'index') {
            $header .= '<script type="text/javascript" src="./lib/js/index.js" charset="utf-8"></script>'."\n";
            $header .= '<script type="text/javascript" src="./lib/js/pastlog.js" charset="utf-8"></script>'."\n";
            if (DICE_MAX) {
                $header .= '<script type="text/javascript" src="./lib/js/trpg.js" charset="utf-8"></script>'."\n";
                if (USE_CONSUMER_RULES) {
                    $header .= '<script type="text/javascript" src="./lib/js/consumer-rule.js" charset="utf-8"></script>'."\n";
                }
            }
            $header .= '<script type="text/javascript" src="./lib/js/ui.core.js"></script>'."\n";
//            $header .= '<script type="text/javascript" src="./lib/js/ui.resizable.min.js"></script>'."\n";
            $header .= '<script type="text/javascript" src="./lib/js/ui.draggable.min.js"></script>'."\n";
            $header .= '<script type="text/javascript" src="./lib/js/ui.accordion.min.js"></script>'."\n";
        } elseif ($window == 'pastlog') {
            $header .= '<script type="text/javascript" src="./lib/js/pastlog.js" charset="utf-8"></script>'."\n";
        } elseif ($window == 'main') {
            $header .= '<script type="text/javascript" src="./lib/js/main.js" charset="utf-8"></script>'."\n";
        } elseif ($window == 'card') {
            $header .= '<script type="text/javascript" src="./lib/js/jquery.upload.js" charset="utf-8"></script>'."\n";
            $header .= '<script type="text/javascript" src="./lib/js/card.js" charset="utf-8"></script>'."\n";
            $header .= '<script type="text/javascript" src="./lib/js/ui.core.js"></script>'."\n";
            $header .= '<script type="text/javascript" src="./lib/js/ui.draggable.min.js"></script>'."\n";
//            $header .= '<script type="text/javascript" src="./lib/js/ui.droppable.min.js"></script>'."\n";
            $header .= '<script type="text/javascript" src="./lib/js/ui.accordion.min.js"></script>'."\n";
            $header .= '<script type="text/javascript" src="./lib/js/jquery.blockUI.js"></script>'."\n";
        }
    }

    $header .= '<title>'.$title.'</title>'."\n";

    return $header;
}

/* フッター */
function html_footer($copyright = true, $adminlogin = false) {
    $footer = '';
    $footer .= '<table style="width:100%; border-style:none; padding:3px;">
'."\n";
    $footer .= '<tr><td>'."\n";
    if ($adminlogin) {
        $footer .= '<form action="./auth.php" method="'.METHOD.'" target="admin">'."\n";
        $footer .= '管理画面：<input type="password" name="admin_pwd" size="20" class="inputpwd" value=""><input name="action" type="hidden" value="admin.php"> <input type="image" class="btn sub" src="'.ADMIN_ICON.'"></form>'."\n";
    }
    $footer .= '</td><td align="right" nowrap style="width:350px; border-style:none;">'."\n";
    if ($copyright) {
        $copyright_msg = COPYRIGHT;
        if (USER_COPYRIGHT) {
            $copyright_msg .= " ".USER_COPYRIGHT;
        }
        $copyright_msg .= " Thanks!";
        $footer .= '<p class="copyright">'.$copyright_msg.'</p>'."\n";
    }
    $footer .= '</td></tr></table>'."\n";
    $footer .= '</body>'."\n";
    $footer .= '</html>'."\n";

    return $footer;
}

/* 指定ファイルを読み込んで出力
 * 引数：ファイル、出力開始行、末尾削除する行数
 */
function output_file_line($filename, $start_line=0, $endcut=0){
    $fp = file($filename);
    if (!$fp) {
        return false;
    }
    if (((int)$start_line != 0 || (int)$endcut != 0) 
        && count($fp)-(int)$endcut-(int)$start_line >= 1
        ) {
        $fp = array_splice($fp, (int)$start_line, count($fp)-(int)$endcut-(int)$start_line);
        $content = "";
        foreach($fp as $v) {
            $content .= mb_convert_encoding($v, "UTF-8", auto);
        }
        return $content;
    } else {
        return false;
    }
}


/* エラー表示 */
function error($msg, $back = false, $close = false, $reload = false) {
    error_log($msg);

    print html_header('エラー', 'admin', false, false);
    print <<<ERROR
<style type="text/css">
<!--
* {
	margin: 5px;
}
-->
</style>
</head>
<body>
<p class="msg">エラー<br>
<br>
$msg
<br>
</p>
ERROR;

    if ($back || $reload || $close) print  "<center>\n";
    if ($back) print  '<FORM><INPUT TYPE="button" VALUE="戻る" onClick="javascript:history.back()"></FORM>'."\n";
    if ($close) print  '<FORM><INPUT TYPE="button" VALUE="閉じる" onClick="javascript:window.close()"></FORM>'."\n";
    if ($reload) print  '<FORM><INPUT TYPE="button" VALUE="再読み込み" onClick="javascript:window.location.reload()"></FORM>'."\n";
    if ($back || $reload || $close) print  "</center>\n";
    print  html_footer();
    exit;
}

/* トリップ生成 */
function create_hash($name,$pwd) {
    //パスワードがなければ中止
    if (!$pwd) {
        return false;
    }

    if (!UPPER_CRYPT) {
        $key = substr(substr($pwd,1,2)."dummy",0,2);
        $key = strtr($key,':;<=>?@[\]^_`','ABCDEFGabcdef');
        $pwd = substr(crypt($name, $key), -10);
    } else {
        $key = substr(md5($name),0,1).substr(ADMIN_HASH_KEY,0,1);
        $key = strtr($key,':;<=>?@[\]^_`','ABCDEFGabcdef');
        $pwd = substr(crypt($pwd, $key), -10);
    }

    return $pwd;
}

/* 書き込みブロック */
function write_block() {
    if (!$GLOBALS['AJAX_CHAT_TRPG']['W_BLOCK_IPS']) {
        return false;
    } else {
        foreach ($GLOBALS['AJAX_CHAT_TRPG']['W_BLOCK_IPS'] as $v) {
            if ($v) {
                if (strstr($_SERVER['REMOTE_ADDR'], $v) || strstr(gethostbyaddr($_SERVER['REMOTE_ADDR']), $v) || strstr($_SERVER['REMOTE_HOST'], $v)) error("書きこみできません。", false);
            }
        }
    }
}

/* アクセスブロック */
function access_block() {
    if (!$GLOBALS['AJAX_CHAT_TRPG']['A_BLOCK_IPS']) {
        return false;
    } else {
        foreach ($GLOBALS['AJAX_CHAT_TRPG']['A_BLOCK_IPS'] as $v) {
            if ($v) {
                if (strstr($_SERVER['REMOTE_ADDR'], $v) || strstr(gethostbyaddr($_SERVER['REMOTE_ADDR']), $v) || strstr($_SERVER['REMOTE_HOST'], $v)) error("接続に失敗しました");
            }
        }
    }
}

// クッキーの読み込み
function read_cookie() {
    $cookies_value = explode("&", $_COOKIE[COOKIE]);
    if($cookies_value) {
        foreach($cookies_value as $v) {
            $c_tmp = explode("=", $v);
            // バージョンUP前のクッキー対応
            if (!preg_match('/^[%0-9A-F]+$/', $c_tmp[1])) {
                $cookies[$c_tmp[0]] = $c_tmp[1];
            } else {
                $cookies[$c_tmp[0]] = rawurldecode($c_tmp[1]);
            }
        }
    }
    return $cookies;
}

// コンソール窓の内容セット
function write_console($top, $left, $width, $display, $id, $header, $msg_st, $msg_acc, $footer, $copyright=false) {
    print '<span id="'.$id.'" class="console" style="display:'.$display.'; width: '.$width.'; top:'.$top.'; left:'.$left.';">'."\n";

    print '<div id="header"><form action="#" onsubmit="return false;">'."\n";
    $onclick = 'hideTarget(\''.$id.'\');';
    print show_icon(HIDE_ICON, "", "", "del_win", "×", "ウィンドウを閉じます", $onclick);
    if ($header) print ' <span class="title">'.$header.'</span>';
    print '</form></div>'."\n";

    print '<div id="body">'."\n";
    if ($msg_st) {
        print nl2br($msg_st)."\n";
    }
    if ($msg_acc) {
        print '<dl id="'.$id.'_acc_list">'."\n";
        foreach ($msg_acc as $v) {
            print "<dt>".nl2br($v['title'])."</dt>\n";
            print "<dd>".nl2br($v['body'])."</dd>\n";
        }
        print '</dl>'."\n";
    }
    print '</div>'."\n";

    if ($footer || $copyright) {
        print '<div id="footer">';
        if ($footer) print $footer;
        if ($copyright) print '<p class="copyright">'.COPYRIGHT.'</p>';
        print '</div>'."\n";
    }
    print '</span>'."\n";
}

// アイコン表示
function show_icon($img1, $img2, $class, $id, $alt, $title, $onclick, $print=true) {
    $icon = '<input type="image" src="'.$img1;
    if ($id) $icon .= '" id="'.$id;
    if ($alt) $icon .= '" alt="'.$alt;
    if ($title) $icon .= '" title="'.$title;
    if ($onclick || $img2) {
        $icon .= '" onclick="';
        // クリックで画像変更
        if ($img2) {
            $icon .= "$('#".$id."').src='".$img2."'; var iconImgSrc=$('#".$id."').attr('src');if(iconImgSrc=='".$img1."'){\$('#".$id."').attr('src', '".$img2."');}else{\$('#".$id."').attr('src', '".$img1."');}";
        }
        if ($onclick) {
            $icon .= $onclick;
        }
    }
    $icon .= '" class="btn';
    if ($class) {
        $icon .= ' '.$class;
    }
    if (!$onclick || $style) $icon .= '" style="';
    if (!$onclick) $icon .= 'cursor: auto;';
    if (!$style) $icon .= $style;
    $icon .= '">';
    if ($print) {
        print $icon;
    } else {
        return $icon;
    }
}

// モバイルアイコン表示
function show_mobile_icon($img1, $img2, $class, $id, $alt, $title, $onclick, $print=true) {
    if ($img1) {
        return show_icon($img1, $img2, $class, $id, $alt, $title, $onclick, $print);
    } else {
        return "(M)";
    }
}
// 難読化設定
$cycle = array('4','2','7');
$key = floor($cycle[0]|$cycle[1]+$cycle[2]^$cycle[0]);
$GLOBALS['AJAX_CHAT_TRPG']['CHAR_CODE'] = strrev($key);
function obf_xor($str) {
    if (!OBFUSCATION) return $str;
    $output = "";
//    $str = mb_convert_kana(mb_convert_kana($str, "A"), "a", "UTF-8");
    for($i=0;$i<mb_strlen($str);$i++) {
        $letter = mb_substr($str, $i, 1);
        if (!mb_ereg('/^[^ -~｡-ﾟ]$/', $letter)) $letter = mb_convert_encoding($letter, "UCS-2", "UTF-8");
        $hex_l = bin2hex($letter);
        $dec_l =  hexdec($hex_l);
        $char_code = $dec_l + $GLOBALS['AJAX_CHAT_TRPG']['CHAR_CODE'];
        $output .= $char_code."|";
    }
    return $output;
}
function de_obf_xor($str) {
    $letters = explode("|", $str);
    $output = "";
    foreach($letters as $v){
        if ($v) {
            $char_code = $v - $GLOBALS['AJAX_CHAT_TRPG']['CHAR_CODE'];
            $hex_l = dechex($char_code);
            $letter = pack("H*", $hex_l);
            if (strlen($letter) == 2) $letter = mb_convert_encoding($letter, "UTF-8", "UCS-2");
            $output .= $letter;
        }
    }
    return $output;
}

// フォーム入力欄
function input_area($type, $name, $value, $size='60', $id='', $free='') {
    if ($free) $form_free = ' '.$free;

    if ($type == 'textarea') {
        $form = '<textarea name="'.$name.'" cols="'.$size.'"'.$form_free.'>'.$value.'</textarea>';
    } else {
        $form = '<input type="'.$type.'" name="'.$name.'" value="'.$value.'" size="'.$size.'"'.$form_free.'>';
    } 
    return $form;
}


/*
 * ファイル･ディレクトリ名チェック
 */
// スラッシュ・ドット許可
function check_name2($name, $msg='') {
    if (!$name) {
        if ($msg) {
            error($msg, true);
        } else {
            error('ファイル名またはディレクトリ名を入力してください', true);
        }
    }
    if (preg_match('/[\\:;*?"<>\|]/', $name, $match)) {
        if ($msg) {
            error($msg, true);
        } else {
            error('ファイル名またはディレクトリ名を変更してください。<br>バックスラッシュ(\)、コロン(:)、セミコロン(;)、アスタリスク(*)、クエスチョン(?)、ダブルクォーテーション(")、不等号&lt;&gt;、パイプ(|)は使えません。', true);
        }
    }
}
// スラッシュ・ドット不許可
function check_name($name) {
    if (!$name)  error('ファイル名またはディレクトリ名を入力してください', true);
    if (preg_match('/[\\:;*?"<>\|\.\/]/', $name)) {
        error('ファイル名またはディレクトリ名を変更してください。<br>使える文字は、スラッシュ(/)、ドット(.)、バックスラッシュ(\)、コロン(:)、アスタリスク(*)、クエスチョン(?)、ダブルクォーテーション(")、山カッコ&lt;&gt;、パイプ(|)は使えません。', true);
    }
}

// パーミッション変更
// 読み書き可能
function set_permission_666($file, $permission) {
    if ($permission) {
        chmod($file, 0606);
    } else {
        chmod($file, 0666);
    }
} 
// 読み書き実行可能
function set_permission_777($obj, $permission) {
    if ($permission) {
        chmod($obj, 0707);
    } else {
        chmod($obj, 0777);
    }
} 

/* 
 * 過去ログディレクトリ作成
 */
function mk_pastlog_dir($dirname, $type, $permission = true) {

    if (file_exists($type.$dirname)) {
        return "同じ名前のディレクトリが存在します";
    } else {
        if (!mkdir ($type.$dirname)) {
            return "ディレクトリの作成に失敗しました";
        }
        set_permission_777($type.$dirname, $permission);
        @touch($type.$dirname."/index.html");
    }
}

/* 
 * 自URLを取得
 */
function get_self_url($get_query=false)
{
    if (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] == 'on') {
        $scheme = 'https://';
    } else {
        $scheme = 'http://';
    }

    $host = $_SERVER['HTTP_HOST'];
    $script_name = $_SERVER['SCRIPT_NAME'];
    $query = '';
    if ($get_query) {
        $query = $_SERVER['QUERY_STRING'];
    }
    return $scheme.$host.$script_name.$query;
}

/* 
 * MSIEか否か
 */
function isIE() {
    $ua = getenv("HTTP_USER_AGENT");
    if (strstr($ua, "MSIE ")) {
        return true;
    } else {
        return false;
    }
}

// システムログ書込み
function write_syslog($msg, $msg_prefix='', $msg_postfix='') {
    ini_set('log_errors', true);
    ini_set('error_log', SYSTEM_LOG);

    // ユーザの情報
    $host = gethostbyaddr($_SERVER['REMOTE_ADDR']);
    $ua = getenv("HTTP_USER_AGENT");

    // システムログ用設定
    $msg_postfix .= " (".$host.'/'.$ua.")";

    error_log($msg_prefix." ".$msg." ".$msg_postfix);

    return true;
}


/* Debugging用 */
function error_log_recursive()
{

}