/*!40101 SET NAMES utf8 */;

--
-- Table structure for table `acos`
--

DROP TABLE IF EXISTS `acos`;
CREATE TABLE `acos` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `parent_id` int(10) default NULL,
  `model` varchar(255) default '',
  `foreign_key` int(10) unsigned default NULL,
  `alias` varchar(255) default '',
  `lft` int(10) default NULL,
  `rght` int(10) default NULL,
  PRIMARY KEY  (`id`),
  KEY `alias` (`alias`),
  KEY `lft_rght` (`lft`,`rght`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `acos`
--

LOCK TABLES `acos` WRITE;
/*!40000 ALTER TABLE `acos` DISABLE KEYS */;
INSERT INTO `acos` VALUES 
(1,NULL,'',NULL,'controllers',1,6),
(2,1,'',NULL,'Users',2,3),
(3,1,'',NULL,'Groups',4,5),
(4,NULL,'',NULL,'prefix',7,14),
(5,4,'',NULL,'admin',8,9),
(6,4,'',NULL,'pc',10,11),
(7,4,'',NULL,'m',12,13);
/*!40000 ALTER TABLE `acos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `aros`
--

DROP TABLE IF EXISTS `aros`;
CREATE TABLE `aros` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `parent_id` int(10) default NULL,
  `model` varchar(255) default '',
  `foreign_key` int(10) unsigned default NULL,
  `alias` varchar(255) default '',
  `lft` int(10) default NULL,
  `rght` int(10) default NULL,
  PRIMARY KEY  (`id`),
  KEY `model_foreign_key` (`model`,`foreign_key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `aros`
--

LOCK TABLES `aros` WRITE;
/*!40000 ALTER TABLE `aros` DISABLE KEYS */;
INSERT INTO `aros` VALUES 
(1,NULL,'Group',1,'Group::1',1,4),
(2,NULL,'Group',2,'Group::2',5,6),
(3,NULL,'Group',3,'Group::3',7,8),
(4,NULL,'Group',4,'Group::4',9,10),
(5,NULL,'Group',5,'Group::5',11,12),
(6,NULL,'Group',6,'Group::6',13,14),
(7,NULL,'Group',7,'Group::7',15,16),
(8,NULL,'Group',8,'Group::8',17,18),
(9,1,'User',1,'User::1',2,3);
/*!40000 ALTER TABLE `aros` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `aros_acos`
--

DROP TABLE IF EXISTS `aros_acos`;
CREATE TABLE `aros_acos` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `aro_id` int(10) unsigned NOT NULL,
  `aco_id` int(10) unsigned NOT NULL,
  `_create` char(2) NOT NULL default '0',
  `_read` char(2) NOT NULL default '0',
  `_update` char(2) NOT NULL default '0',
  `_delete` char(2) NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `aro_aco` (`aro_id`,`aco_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `aros_acos`
--

LOCK TABLES `aros_acos` WRITE;
/*!40000 ALTER TABLE `aros_acos` DISABLE KEYS */;
INSERT INTO `aros_acos` VALUES 
(1,1,1,'1','1','1','1'),
(2,1,4,'1','1','1','1'),
(3,2,1,'1','1','1','1'),
(4,2,4,'1','1','1','1'),
(5,2,3,'-1','-1','-1','-1'),
(6,3,1,'-1','-1','-1','-1'),
(7,3,4,'1','1','1','1'),
(8,3,2,'1','1','1','1'),
(9,3,5,'0','1','0','1'),
(10,4,4,'1','1','1','1'),
(11,4,2,'1','1','1','1'),
(12,4,1,'-1','-1','-1','-1'),
(13,4,5,'-1','-1','-1','-1'),
(14,5,1,'-1','-1','-1','-1'),
(15,5,4,'1','1','1','1'),
(16,5,5,'-1','-1','-1','-1'),
(17,5,2,'0','0','1','0'),
(18,6,1,'-1','-1','-1','-1'),
(19,7,1,'-1','-1','-1','-1'),
(20,8,1,'-1','-1','-1','-1');
/*!40000 ALTER TABLE `aros_acos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cake_sessions`
--

DROP TABLE IF EXISTS `cake_sessions`;
CREATE TABLE `cake_sessions` (
  `id` varchar(255) NOT NULL default '',
  `data` text,
  `expires` int(11) default NULL,
  PRIMARY KEY  (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Table structure for table `groups`
--

DROP TABLE IF EXISTS `groups`;
CREATE TABLE `groups` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `name` varchar(8) default NULL,
  `parent_id` int(10) unsigned default NULL,
  PRIMARY KEY  (`id`),
  KEY `groups_parent_id` (`parent_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `groups`
--

LOCK TABLES `groups` WRITE;
/*!40000 ALTER TABLE `groups` DISABLE KEYS */;
INSERT INTO `groups` VALUES 
(1,'admin',0),
(2,'subadmin',0),
(3,'watcher',0),
(4,'member',0),
(5,'pre',0),
(6,'locked',0),
(7,'deleted',0),
(8,'banned',0);
/*!40000 ALTER TABLE `groups` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `users`
--

DROP TABLE IF EXISTS `users`;
CREATE TABLE `users` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `group_id` int(10) unsigned NOT NULL,
  `name` varchar(64) NOT NULL,
  `username` varchar(40) NOT NULL,
  `password` varchar(40) NOT NULL,
  `pcmail` blob NOT NULL,
  `mobile_mail` blob NOT NULL,
  `useragent` varchar(512) NOT NULL,
  `host` varchar(64) NOT NULL,
  `created` datetime NOT NULL,
  `modified` datetime NOT NULL,
  PRIMARY KEY  (`id`),
  UNIQUE KEY `users_username` (`username`),
  KEY `users_login` (`username`,`password`),
  KEY `users_modefied` (`modified`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


