<?php
class Group extends AppModel {

	var $name = 'Group';
	var $actsAs = array(
		'Acl' => 'requester', // ARO自動登録用
	);

	function parentNode() {
		if (!$this->id) {
			return null;
		}
		$data = $this->read();
		if (!$data['Group']['parent_id']){
			return null;
		} else {
			return array('model' => 'Group', 'foreign_key' => $data['Group']['parent_id']);
		}
	}

	// 更新時に親IDを変更する
	function save($data = null, $validate = true, $fieldList = array())
	{
		if (parent::save($data, $validate, $fieldList)) {
			$conditions = array(
				'model' => $this->name,
				'foreign_key' => $this->id,
			);

			App::import('Component', 'Acl');
			$Aro = new Aro;
			$Aro->id = $Aro->field('id', $conditions);
			$Aro->saveField('parent_id', $data['Group']['parent_id']);
			$Aro->saveField('alias', $this->name . '::' . $this->id);
			return true;
		}
		return false;
	}

}
?>
