<?php
class User extends AppModel {

	var $name = 'User';
	var $belongsTo = array('Group');
	var $actsAs = array(
		'Acl' => 'requester', // ARO自動登録用
		'Containable',
	);

	var $fields = array(
		'id' => array(
			'auto' => true,
		),
		'group_id' => array(
			'auto' => false,
			'add' => true,
			'edit' => false,
		),
		'name' => array(
			'auto' => false,
			'add' => true,
			'edit' => true,
			'escape' => array(
				'html' => true,
				'all' => true,
			),
		),
		'username' => array(
			'auto' => false,
			'add' => true,
			'edit' => false,
		),
		'password' => array(
			'auto' => false,
			'add' => true,
			'edit' => false,
		),
		'pcmail' => array(
			'auto' => false,
			'add' => false,
			'edit' => false,
		),
		'mobile_mail' => array(
			'auto' => false,
			'add' => false,
			'edit' => false,
		),
		'useragent' => array(
			'auto' => true,
		),
		'host' => array(
			'auto' => true,
		),
		'created' => array(
			'auto' => true,
		),
		'modified' => array(
			'auto' => true,
		),
	);

	var $validate = array(
		'name' => array(
			'MaxLength' => array(
				'rule' => array('MaxLength', 64),
			),
			'notEmpty' => array(
				'rule' => 'notEmpty',
			),
		),
		'username' => array(
			'isUnique' => array(
				'rule' => array('isUnique'),
			),
			'betweenWrapper' => array(
				'rule' => array('betweenUsername'),
			),
			'alphaNumeric' => array(
				'rule' => 'alphaNumeric',
			),
			'notEmpty' => array(
				'rule' => 'notEmpty',
			),
		),
		'password1' => array(
			'betweenWrapper' => array(
				'rule' => array('betweenPassword'),
			),
			'alphaNumeric' => array(
				'rule' => 'alphaNumeric',
			),
			'notEmpty' => array(
				'rule' => 'notEmpty',
			),
		),
		'password2' => array(
			'compare2fields' => array(
				'rule' => array('compare2fields', 'password1', false),
			),
			'alphaNumeric' => array(
				'rule' => 'alphaNumeric',
			),
			'notEmpty' => array(
				'rule' => 'notEmpty',
			),
		),
	);

	/* コールバックメソッド */
	function beforeValidate($options = array())
	{

		return parent::beforeValidate($options);

	}
	function beforeSave($options = array())
	{

		// $fieldsの設定でSanitize
		foreach($this->data['User'] as $field => $value) {
			$this->data['User'][$field]  = $this->escapeByFields($field, $value);
		}

		return parent::beforeSave($options);
	}


	/* validation */
	function betweenUsername($data)
	{
		$idLength = Configure::read('User.UserId.Length');
		return self::betweenWrapper($data, $idLength);
	}

	function betweenPassword($data)
	{
		$idLength = Configure::read('User.Password.Length');
		return self::betweenWrapper($data, $idLength);
	}

	function betweenWrapper($data, $idLength)
	{
		$check = array_values($data);

		return parent::betweenWrapper($check[0], $idLength['min'], $idLength['max']);
	}

	// ACL
	function parentNode()
	{
		if (!$this->id && empty($this->data)) {
			return null;
		}
		$data = $this->data;
		if (empty($this->data)) {
			$data = $this->read();
		} elseif (!isset($data['User']['group_id']) || !$data['User']['group_id']) {
			$data['User']['group_id'] = $this->read('group_id');
		}
		if (!$data['User']['group_id']) {
			return null;
		} else {
			return array('model' => 'Group', 'foreign_key' => $data['User']['group_id']);
		}
	}
	// 更新時に親IDを変更する
	function save($data = null, $validate = true, $fieldList = array())
	{
		if (parent::save($data, $validate, $fieldList)) {
			$conditions = array(
				'model' => $this->name,
				'foreign_key' => $this->id,
			);

			App::import('Component', 'Acl');
			$Aro = new Aro;
			$Aro->id = $Aro->field('id', $conditions);
			if (isset($data['User']['group_id']) && $data['User']['group_id']) {
				$Aro->saveField('parent_id', $data['User']['group_id']);
			}
			$Aro->saveField('alias', $this->name . '::' . $this->id);
			return true;
		}
		return false;
	}

}
?>